/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fonts;

import com.android.ide.common.fonts.FontProvider;
import com.android.tools.idea.downloads.DownloadService;
import com.android.tools.idea.fonts.DownloadableFontCacheServiceImpl;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ResourceUtil;
import java.io.File;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

class FontDirectoryDownloadService
extends DownloadService {
    private static final String SERVICE_POSTFIX = " Downloadable Fonts";
    private static final String TEMPORARY_FONT_DIRECTORY_FILENAME = "temp_font_directory.xml";
    private final FontProvider myProvider;
    private final DownloadableFontCacheServiceImpl myFontService;

    public FontDirectoryDownloadService(@NotNull DownloadableFontCacheServiceImpl fontService, @NotNull FontProvider provider, @NotNull File fontCachePath) {
        super(provider.getName() + SERVICE_POSTFIX, provider.getUrl(), FontDirectoryDownloadService.getFallbackResourceUrl(provider), FontDirectoryDownloadService.getCachePath(provider, fontCachePath), TEMPORARY_FONT_DIRECTORY_FILENAME, "font_directory.xml");
        this.myFontService = fontService;
        this.myProvider = provider;
    }

    @Override
    public void loadFromFile(@NotNull URL url) {
        this.myFontService.loadDirectory(this.myProvider, url);
    }

    @NotNull
    private static File getCachePath(@NotNull FontProvider provider, @NotNull File fontCachePath) {
        File providerPath = new File(fontCachePath, provider.getAuthority());
        File directoryPath = new File(providerPath, "directory");
        FileUtil.createDirectory((File)directoryPath);
        return directoryPath;
    }

    static URL getFallbackResourceUrl(@NotNull FontProvider provider) {
        String filename = provider.equals((Object)FontProvider.GOOGLE_PROVIDER) ? "google_font_directory.xml" : "empty_font_directory.xml";
        return ResourceUtil.getResource(FontDirectoryDownloadService.class, (String)"fonts", (String)filename);
    }
}

