/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fonts;

import com.android.ide.common.fonts.FontDetail;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.fonts.FontProvider;
import com.android.ide.common.res2.ValueXmlHelper;
import com.android.resources.ResourceFolderType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.fonts.DownloadableFontCacheService;
import com.android.tools.idea.fonts.DownloadableFontCacheServiceImpl;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.utils.XmlUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.intellij.lang.annotations.Language;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontFamilyCreator {
    private static final String PRELOADED_FONTS = "preloaded_fonts";
    private static final String PRELOADED_FONTS_FILE = "preloaded_fonts.xml";
    private static final String FONT_CERTS_FILE = "font_certs.xml";
    private final AndroidFacet myFacet;
    private final Project myProject;
    private final DownloadableFontCacheService myService;

    public FontFamilyCreator(@NotNull AndroidFacet facet) {
        this.myFacet = facet;
        this.myProject = facet.getModule().getProject();
        this.myService = DownloadableFontCacheService.getInstance();
    }

    @NotNull
    public String createFontFamily(final @NotNull FontDetail font, final @NotNull String fontName, final boolean downloadable) throws IOException {
        Project project = this.myFacet.getModule().getProject();
        TransactionGuard.submitTransaction((Disposable)project, () -> new WriteCommandAction.Simple(project, "Create new font file", new PsiFile[0]){

            protected void run() throws Throwable {
                if (downloadable) {
                    FontFamilyCreator.this.createDownloadableFont(font, fontName);
                } else {
                    FontFamilyCreator.this.createEmbeddedFont(font, fontName);
                }
            }
        }.execute());
        return "@font/" + fontName;
    }

    private void createDownloadableFont(@NotNull FontDetail font, @NotNull String fontName) throws IOException {
        VirtualFile fontFolder = this.getResourceFolder(ResourceFolderType.FONT);
        String content = this.createFontFamilyContent(font);
        this.saveContent(fontFolder, fontName + ".xml", content.getBytes(StandardCharsets.UTF_8));
        FontProvider provider = font.getFamily().getProvider();
        this.createCertFileIfNeeded(provider);
        this.createOrUpdateFile(PRELOADED_FONTS_FILE, "array", PRELOADED_FONTS, "@font/", fontName, FontFamilyCreator::insertItem);
        this.addPreloadedFontsToManifest();
        FileDocumentManager.getInstance().saveAllDocuments();
    }

    private void createEmbeddedFont(@NotNull FontDetail font, @NotNull String fontName) throws IOException {
        VirtualFile fontFolder = this.getResourceFolder(ResourceFolderType.FONT);
        File cachedFile = this.myService.getCachedFontFile(font);
        if (cachedFile != null && cachedFile.exists()) {
            this.saveContent(fontFolder, fontName + "." + FileUtilRt.getExtension((String)cachedFile.getName()), FileUtil.loadFileBytes((File)cachedFile));
        }
    }

    private void saveContent(@NotNull VirtualFile folder, @NotNull String fileName, byte[] content) throws IOException {
        folder.createChildData((Object)this, fileName).setBinaryContent(content);
    }

    @NotNull
    private VirtualFile getResourceFolder(@NotNull ResourceFolderType folderType) throws IOException {
        VirtualFile resourceDirectory = this.myFacet.getPrimaryResourceDir();
        if (resourceDirectory == null) {
            throw new IOException("PrimaryResourceDirectory is null");
        }
        VirtualFile fontFolder = resourceDirectory.findChild(folderType.getName());
        if (fontFolder == null) {
            fontFolder = resourceDirectory.createChildDirectory((Object)this, folderType.getName());
        }
        return fontFolder;
    }

    public static String getFontName(@NotNull FontDetail font) {
        String name = font.getFamily().getName();
        String styleName = StringUtil.trimStart((String)font.getStyleName(), (String)"Regular").trim();
        if (!styleName.isEmpty()) {
            name = name + " " + styleName;
        }
        return DownloadableFontCacheServiceImpl.convertNameToFilename(name);
    }

    @NotNull
    @Language(value="XML")
    private String createFontFamilyContent(@NotNull FontDetail font) {
        FontFamily family = font.getFamily();
        FontProvider provider = family.getProvider();
        AndroidModuleInfo info = AndroidModuleInfo.getInstance(this.myFacet);
        AndroidVersion minSdkVersion = info.getMinSdkVersion();
        if (minSdkVersion.getApiLevel() >= 26) {
            return String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>%n<font-family xmlns:android=\"http://schemas.android.com/apk/res/android\"%n        android:fontProviderAuthority=\"" + FontFamilyCreator.escapeXmlValue(provider.getAuthority()) + "\"%n        android:fontProviderPackage=\"" + FontFamilyCreator.escapeXmlValue(provider.getPackageName()) + "\"%n        android:fontProviderQuery=\"" + FontFamilyCreator.escapeXmlValue(font.generateQuery(false)) + "\"%n        android:fontProviderCerts=\"@array/" + FontFamilyCreator.escapeXmlValue(provider.getCertificateResourceName()) + "\">%n</font-family>%n", new Object[0]);
        }
        if (minSdkVersion.getApiLevel() == 25 && minSdkVersion.isPreview()) {
            return String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>%n<font-family xmlns:android=\"http://schemas.android.com/apk/res/android\"%n        xmlns:app=\"http://schemas.android.com/apk/res-auto\"%n        android:fontProviderAuthority=\"" + FontFamilyCreator.escapeXmlValue(provider.getAuthority()) + "\"%n        android:fontProviderPackage=\"" + FontFamilyCreator.escapeXmlValue(provider.getPackageName()) + "\"%n        android:fontProviderQuery=\"" + FontFamilyCreator.escapeXmlValue(font.generateQuery(false)) + "\"%n        android:fontProviderCerts=\"@array/" + FontFamilyCreator.escapeXmlValue(provider.getCertificateResourceName()) + "\"%n        app:fontProviderAuthority=\"" + FontFamilyCreator.escapeXmlValue(provider.getAuthority()) + "\"%n        app:fontProviderPackage=\"" + FontFamilyCreator.escapeXmlValue(provider.getPackageName()) + "\"%n        app:fontProviderQuery=\"" + FontFamilyCreator.escapeXmlValue(font.generateQuery(false)) + "\"%n        app:fontProviderCerts=\"@array/" + FontFamilyCreator.escapeXmlValue(provider.getCertificateResourceName()) + "\">%n</font-family>%n", new Object[0]);
        }
        return String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>%n<font-family xmlns:app=\"http://schemas.android.com/apk/res-auto\"%n        app:fontProviderAuthority=\"" + FontFamilyCreator.escapeXmlValue(provider.getAuthority()) + "\"%n        app:fontProviderPackage=\"" + FontFamilyCreator.escapeXmlValue(provider.getPackageName()) + "\"%n        app:fontProviderQuery=\"" + FontFamilyCreator.escapeXmlValue(font.generateQuery(false)) + "\"%n        app:fontProviderCerts=\"@array/" + FontFamilyCreator.escapeXmlValue(provider.getCertificateResourceName()) + "\">%n</font-family>%n", new Object[0]);
    }

    @NotNull
    @Language(value="XML")
    private static String createValuesFileContent(@NotNull String tag, @NotNull String name, @NotNull String prefix, @NotNull String value) {
        return String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>%n<resources>%n    <" + tag + " name=\"" + FontFamilyCreator.escapeXmlValue(name) + "\" translatable=\"false\">%n        <item>" + prefix + ValueXmlHelper.escapeResourceString((String)value) + "</item>%n    </" + tag + ">%n</resources>%n", new Object[0]);
    }

    @NotNull
    @Language(value="XML")
    private static String createCertificateFileContent(@NotNull FontProvider provider) {
        String certName = FontFamilyCreator.escapeXmlValue(provider.getCertificateResourceName());
        return String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?>%n<resources>%n    <array name=\"" + certName + "\">%n        <item>@array/" + certName + "_dev</item>%n        <item>@array/" + certName + "_prod</item>%n    </array>%n    <string-array name=\"" + certName + "_dev\">%n        <item>%n            " + provider.getDevelopmentCertificate() + "%n        </item>%n    </string-array>%n    <string-array name=\"" + certName + "_prod\">%n        <item>%n            " + provider.getCertificate() + "%n        </item>%n    </string-array>%n</resources>%n", new Object[0]);
    }

    private void createOrUpdateFile(@NotNull String fileName, @NotNull String tagName, @NotNull String name, @NotNull String prefix, @NotNull String value, @NotNull XmlTagUpdater updater) throws IOException {
        VirtualFile valuesFolder = this.getResourceFolder(ResourceFolderType.VALUES);
        VirtualFile file = valuesFolder.findChild(fileName);
        if (file == null) {
            String content = FontFamilyCreator.createValuesFileContent(tagName, name, prefix, value);
            this.saveContent(valuesFolder, fileName, content.getBytes(StandardCharsets.UTF_8));
        } else {
            XmlTag newTag;
            XmlFile xmlFile;
            XmlTag rootTag;
            PsiFile psiFile = AndroidPsiUtils.getPsiFileSafely(this.myProject, file);
            if (psiFile instanceof XmlFile && (rootTag = (xmlFile = (XmlFile)psiFile).getRootTag()) != null && (newTag = FontFamilyCreator.updateFile(rootTag, tagName, name, prefix, value, tag -> tag.getAttributeValue("name"), updater)) != null) {
                CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)rootTag);
            }
        }
    }

    private void createCertFileIfNeeded(@NotNull FontProvider provider) throws IOException {
        VirtualFile valuesFolder = this.getResourceFolder(ResourceFolderType.VALUES);
        VirtualFile file = valuesFolder.findChild(FONT_CERTS_FILE);
        if (file == null) {
            String content = FontFamilyCreator.createCertificateFileContent(provider);
            this.saveContent(valuesFolder, FONT_CERTS_FILE, content.getBytes(StandardCharsets.UTF_8));
        }
    }

    private void addPreloadedFontsToManifest() {
        Manifest manifest = this.myFacet.getManifest();
        if (manifest == null) {
            return;
        }
        XmlTag manifestTag = manifest.getXmlTag();
        if (manifestTag == null) {
            return;
        }
        XmlTag applicationTag = manifestTag.findFirstSubTag("application");
        if (applicationTag == null) {
            return;
        }
        XmlTag newTag = FontFamilyCreator.updateFile(applicationTag, "meta-data", PRELOADED_FONTS, "@array/", PRELOADED_FONTS, tag -> tag.getAttributeValue("name", "http://schemas.android.com/apk/res/android"), FontFamilyCreator::setMetaDataAttributes);
        if (newTag != null) {
            CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)newTag);
        }
    }

    @Nullable
    private static XmlTag updateFile(@NotNull XmlTag parent, @NotNull String tagName, @NotNull String name, @NotNull String prefix, @NotNull String value, @NotNull Function<XmlTag, String> nameAttributeGetter, @NotNull XmlTagUpdater updater) {
        XmlTag before = null;
        XmlTag last = null;
        for (XmlTag tag : parent.getSubTags()) {
            if (!tag.getName().equals(tagName)) continue;
            last = tag;
            String nameAttribute = nameAttributeGetter.apply(tag);
            if (nameAttribute == null || nameAttribute.compareTo(name) < 0) continue;
            if (nameAttribute.equals(name)) {
                return updater.update(tag, prefix, value);
            }
            before = tag;
        }
        XmlTag newTag = parent.createChildTag(tagName, "", null, false);
        if (newTag == null) {
            return null;
        }
        newTag = before != null ? (XmlTag)parent.addBefore((PsiElement)newTag, before) : (last != null ? (XmlTag)parent.addAfter((PsiElement)newTag, (PsiElement)last) : parent.addSubTag(newTag, false));
        updater.update(newTag, prefix, value);
        return newTag;
    }

    @Nullable
    private static XmlTag insertItem(@NotNull XmlTag parent, @NotNull String prefix, @NotNull String newValue) {
        XmlTag before = null;
        for (XmlTag tag : parent.getSubTags()) {
            if (!tag.getName().equals("item")) continue;
            String value = tag.getValue().getText();
            int compare = value.compareTo(prefix + newValue);
            if (compare == 0) {
                return null;
            }
            if (compare <= 0) continue;
            before = tag;
            break;
        }
        XmlTag newTag = parent.createChildTag("item", "", prefix + ValueXmlHelper.escapeResourceString((String)newValue), false);
        if (before != null) {
            parent.addBefore((PsiElement)newTag, before);
        } else {
            parent.addSubTag(newTag, false);
        }
        return newTag;
    }

    private static XmlTag setMetaDataAttributes(@NotNull XmlTag tag, @NotNull String prefix, @NotNull String newValue) {
        tag.setAttribute("name", "http://schemas.android.com/apk/res/android", PRELOADED_FONTS);
        tag.setAttribute("resource", "http://schemas.android.com/apk/res/android", prefix + FontFamilyCreator.escapeXmlValue(newValue));
        return tag;
    }

    @NotNull
    private static String escapeXmlValue(@NotNull String value) {
        return XmlUtils.toXmlAttributeValue((String)value);
    }

    private static interface XmlTagUpdater {
        public XmlTag update(@NotNull XmlTag var1, @NotNull String var2, @NotNull String var3);
    }
}

