/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fonts;

import com.android.ide.common.fonts.MutableFontDetail;
import com.android.ide.common.fonts.QueryParser;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class FontFamilyParser {
    FontFamilyParser() {
    }

    @NotNull
    static QueryParser.ParseResult parseFontFamily(@NotNull File xmlFile) {
        try {
            return FontFamilyParser.parseFontReference(xmlFile);
        }
        catch (QueryParser.FontQueryParserError ex) {
            return new ParseErrorResult(ex.getMessage());
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            String message = "Could not parse font xml file " + xmlFile;
            Logger.getInstance(FontFamilyParser.class).error(message, (Throwable)ex);
            return new ParseErrorResult(message);
        }
    }

    private static QueryParser.ParseResult parseFontReference(@NotNull File xmlFile) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        FontFamilyHandler handler = new FontFamilyHandler(xmlFile);
        parser.parse(xmlFile, (DefaultHandler)handler);
        return handler.getResult();
    }

    static int parseInt(@Nullable String intAsString, int defaultValue) {
        if (intAsString == null) {
            return defaultValue;
        }
        try {
            return Math.round(Float.parseFloat(intAsString));
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    static boolean parseFontStyle(@Nullable String fontStyle) {
        return fontStyle != null && fontStyle.startsWith("italic");
    }

    static class CompoundFontResult
    extends QueryParser.ParseResult {
        private Map<String, MutableFontDetail> myFonts = new HashMap<String, MutableFontDetail>();

        CompoundFontResult() {
        }

        @NotNull
        Map<String, MutableFontDetail> getFonts() {
            return this.myFonts;
        }

        private void addFont(@NotNull String fontName, int weight, int width, boolean italics) {
            this.myFonts.put(fontName, new MutableFontDetail(weight, width, italics));
        }
    }

    private static class FontFamilyHandler
    extends DefaultHandler {
        private static final String FONT_FAMILY = "font-family";
        private static final String FONT = "font";
        private static final String ATTR_AUTHORITY = "fontProviderAuthority";
        private static final String ATTR_QUERY = "fontProviderQuery";
        private static final String ATTR_FONT = "font";
        private static final String ATTR_FONT_WEIGHT = "fontWeight";
        private static final String ATTR_FONT_WIDTH = "fontWidth";
        private static final String ATTR_FONT_STYLE = "fontStyle";
        private final File myFile;
        private QueryParser.ParseResult myResult;

        private FontFamilyHandler(@NotNull File file) {
            this.myFile = file;
        }

        @NotNull
        private QueryParser.ParseResult getResult() {
            if (this.myResult == null) {
                this.myResult = new ParseErrorResult("The font file is empty");
            }
            return this.myResult;
        }

        @Override
        public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String name, @NotNull Attributes attributes) throws SAXException {
            switch (name) {
                case "font-family": {
                    this.myResult = this.parseQuery(FontFamilyHandler.getAttributeValue(attributes, ATTR_AUTHORITY), FontFamilyHandler.getAttributeValue(attributes, ATTR_QUERY));
                    break;
                }
                case "font": {
                    String fontName = FontFamilyHandler.getAttributeValue(attributes, "font");
                    int weight = FontFamilyParser.parseInt(FontFamilyHandler.getAttributeValue(attributes, ATTR_FONT_WEIGHT), 400);
                    int width = FontFamilyParser.parseInt(FontFamilyHandler.getAttributeValue(attributes, ATTR_FONT_WIDTH), 100);
                    boolean italics = FontFamilyParser.parseFontStyle(FontFamilyHandler.getAttributeValue(attributes, ATTR_FONT_STYLE));
                    this.myResult = this.addFont(fontName, weight, width, italics);
                    break;
                }
                default: {
                    Logger.getInstance(FontFamilyParser.class).warn("Unrecognized tag: " + name + " in file: " + this.myFile);
                }
            }
        }

        @Nullable
        private static String getAttributeValue(@NotNull Attributes attributes, @NotNull String attrName) {
            String value = attributes.getValue("http://schemas.android.com/apk/res/android", attrName);
            if (value != null) {
                return value;
            }
            return attributes.getValue("http://schemas.android.com/apk/res-auto", attrName);
        }

        @Nullable
        private QueryParser.ParseResult parseQuery(@Nullable String authority, @Nullable String query) {
            if (this.myResult instanceof ParseErrorResult) {
                return this.myResult;
            }
            if (authority == null && query == null) {
                return this.myResult;
            }
            if (this.myResult != null) {
                return new ParseErrorResult("<font-family> must be the root element");
            }
            if (authority == null) {
                return new ParseErrorResult("The <font-family> tag must contain an fontProviderAuthority attribute");
            }
            if (query == null) {
                return new ParseErrorResult("The <font-family> tag must contain a fontProviderQuery attribute");
            }
            return QueryParser.parseDownloadableFont((String)authority, (String)query);
        }

        private QueryParser.ParseResult addFont(@Nullable String fontName, int weight, int width, boolean italics) {
            if (this.myResult instanceof ParseErrorResult) {
                return this.myResult;
            }
            if (this.myResult != null && !(this.myResult instanceof CompoundFontResult)) {
                return new ParseErrorResult("<font> is not allowed in a downloadable font definition");
            }
            if (fontName == null) {
                return new ParseErrorResult("The <font> tag must contain a font attribute");
            }
            CompoundFontResult result = (CompoundFontResult)this.myResult;
            if (result == null) {
                result = new CompoundFontResult();
            }
            result.addFont(fontName, weight, width, italics);
            return result;
        }
    }

    static class ParseErrorResult
    extends QueryParser.ParseResult {
        private final String myMessage;

        ParseErrorResult(@NotNull String message) {
            this.myMessage = message;
        }

        public String getMessage() {
            return this.myMessage;
        }
    }
}

