/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.builder.model.AndroidArtifactOutput;
import com.android.builder.model.level2.Library;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeVariant;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.model.ClassJarProvider;
import com.android.utils.ImmutableCollectors;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidGradleClassJarProvider
extends ClassJarProvider {
    @Override
    @Nullable
    public VirtualFile findModuleClassFile(@NotNull String className, @NotNull Module module) {
        AndroidModuleModel model = AndroidModuleModel.get(module);
        if (model == null) {
            return null;
        }
        for (VirtualFile outputDir : AndroidGradleClassJarProvider.getCompilerOutputRoots(model)) {
            VirtualFile file = ClassJarProvider.findClassFileInPath(outputDir, className);
            if (file == null) continue;
            return file;
        }
        return null;
    }

    @NotNull
    private static Collection<VirtualFile> getCompilerOutputRoots(@NotNull AndroidModuleModel model) {
        File outFolder;
        File file;
        IdeVariant variant = model.getSelectedVariant();
        String variantName = variant.getName();
        IdeAndroidArtifact mainArtifactInfo = model.getMainArtifact();
        File classesFolder = mainArtifactInfo.getClassesFolder();
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        if (classesFolder == null) {
            AndroidArtifactOutput output = GradleUtil.getOutput(mainArtifactInfo);
            file = output.getMainOutputFile().getOutputFile();
            File buildFolder = file.getParentFile().getParentFile();
            classesFolder = new File(buildFolder, "classes");
        }
        if ((outFolder = new File(classesFolder, variantName.replace('-', File.separatorChar))).exists() && (file = VfsUtil.findFileByIoFile((File)outFolder, (boolean)true)) != null) {
            listBuilder.add((Object)file);
        }
        for (File additionalFolder : mainArtifactInfo.getAdditionalClassesFolders()) {
            VirtualFile file2 = VfsUtil.findFileByIoFile((File)additionalFolder, (boolean)true);
            if (file2 == null) continue;
            listBuilder.add((Object)file2);
        }
        return listBuilder.build();
    }

    @Override
    @NotNull
    public List<File> getModuleExternalLibraries(@NotNull Module module) {
        AndroidModuleModel model = AndroidModuleModel.get(module);
        if (model == null) {
            return Lists.transform(AndroidRootUtil.getExternalLibraries(module), VfsUtilCore::virtualToIoFile);
        }
        return (List)Stream.concat(model.getSelectedMainCompileLevel2Dependencies().getAndroidLibraries().stream().map(library -> new File(library.getJarFile())), model.getSelectedMainCompileLevel2Dependencies().getJavaLibraries().stream().map(Library::getArtifact)).collect(ImmutableCollectors.toImmutableList());
    }
}

