/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.android.builder.model.BaseArtifact;
import com.android.builder.model.Dependencies;
import com.android.builder.model.JavaLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.model.android.CompileOptionsModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.model.java.JavaModel;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeBaseArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeVariant;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.testartifacts.scopes.TestArtifactSearchScopes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.roots.JavaProjectModelModifier;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class AndroidGradleJavaProjectModelModifier
extends JavaProjectModelModifier {
    @NotNull
    private static final Map<String, String> EXTERNAL_LIBRARY_VERSIONS = ImmutableMap.of((Object)"net.jcip:jcip-annotations", (Object)"1.0", (Object)"org.jetbrains:annotations-java5", (Object)"15.0", (Object)"org.jetbrains:annotations", (Object)"15.0", (Object)"junit:junit", (Object)"4.12", (Object)"org.testng:testng", (Object)"6.9.6");

    @Nullable
    public Promise<Void> addModuleDependency(@NotNull Module from, @NotNull Module to, @NotNull DependencyScope scope) {
        final Project project = from.getProject();
        VirtualFile openedFile = FileEditorManagerEx.getInstanceEx((Project)from.getProject()).getCurrentFile();
        String gradlePath = GradleUtil.getGradlePath(to);
        final GradleBuildModel buildModel = GradleBuildModel.get(from);
        if (buildModel != null && gradlePath != null) {
            DependenciesModel dependencies2 = buildModel.dependencies();
            String configurationName = AndroidGradleJavaProjectModelModifier.getConfigurationName(from, scope, openedFile);
            dependencies2.addModule(configurationName, gradlePath, null);
            new WriteCommandAction(project, "Add Gradle Module Dependency", new PsiFile[0]){

                protected void run(@NotNull Result result) throws Throwable {
                    buildModel.applyChanges();
                    AndroidGradleJavaProjectModelModifier.registerUndoAction(project);
                }
            }.execute();
            return AndroidGradleJavaProjectModelModifier.requestProjectSync(project);
        }
        if (buildModel == null ^ gradlePath == null) {
            return Promises.rejectedPromise();
        }
        return null;
    }

    @Nullable
    public Promise<Void> addExternalLibraryDependency(@NotNull Collection<Module> modules, @NotNull ExternalLibraryDescriptor descriptor, @NotNull DependencyScope scope) {
        ArtifactDependencySpec dependencySpec = new ArtifactDependencySpec(descriptor.getLibraryArtifactId(), descriptor.getLibraryGroupId(), AndroidGradleJavaProjectModelModifier.selectVersion(descriptor));
        return AndroidGradleJavaProjectModelModifier.addExternalLibraryDependency(modules, dependencySpec, scope);
    }

    @Nullable
    public Promise<Void> addLibraryDependency(@NotNull Module from, @NotNull Library library, @NotNull DependencyScope scope) {
        if (!GradleFacet.isAppliedTo(from)) {
            return null;
        }
        ArtifactDependencySpec dependencySpec = AndroidGradleJavaProjectModelModifier.findNewExternalDependency(from.getProject(), library);
        if (dependencySpec == null) {
            return Promises.rejectedPromise();
        }
        return AndroidGradleJavaProjectModelModifier.addExternalLibraryDependency((Collection<Module>)ImmutableList.of((Object)from), dependencySpec, scope);
    }

    @Nullable
    private static Promise<Void> addExternalLibraryDependency(@NotNull Collection<Module> modules, @NotNull ArtifactDependencySpec dependencySpec, @NotNull DependencyScope scope) {
        Module firstModule = (Module)Iterables.getFirst(modules, null);
        if (firstModule == null) {
            return null;
        }
        final Project project = firstModule.getProject();
        VirtualFile openedFile = FileEditorManagerEx.getInstanceEx((Project)firstModule.getProject()).getCurrentFile();
        final ArrayList buildModelsToUpdate = Lists.newArrayList();
        for (Module module : modules) {
            GradleBuildModel buildModel = GradleBuildModel.get(module);
            if (buildModel == null) {
                return null;
            }
            String configurationName = AndroidGradleJavaProjectModelModifier.getConfigurationName(module, scope, openedFile);
            DependenciesModel dependencies2 = buildModel.dependencies();
            dependencies2.addArtifact(configurationName, dependencySpec);
            buildModelsToUpdate.add(buildModel);
        }
        new WriteCommandAction(project, "Add Gradle Library Dependency", new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                for (GradleBuildModel buildModel : buildModelsToUpdate) {
                    buildModel.applyChanges();
                }
                AndroidGradleJavaProjectModelModifier.registerUndoAction(project);
            }
        }.execute();
        return AndroidGradleJavaProjectModelModifier.requestProjectSync(project);
    }

    @Nullable
    public Promise<Void> changeLanguageLevel(@NotNull Module module, @NotNull LanguageLevel level) {
        final Project project = module.getProject();
        if (!GradleFacet.isAppliedTo(module)) {
            return null;
        }
        final GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (buildModel == null) {
            return null;
        }
        if (Projects.getAndroidModel(module) != null) {
            AndroidModel android = buildModel.android();
            if (android == null) {
                return null;
            }
            CompileOptionsModel compileOptions = android.compileOptions();
            compileOptions.setSourceCompatibility(level);
            compileOptions.setTargetCompatibility(level);
        } else {
            JavaFacet javaFacet = JavaFacet.getInstance(module);
            if (javaFacet == null || javaFacet.getJavaModuleModel() == null) {
                return null;
            }
            JavaModel javaModel = buildModel.java();
            javaModel.setSourceCompatibility(level);
            javaModel.setTargetCompatibility(level);
        }
        new WriteCommandAction(project, "Change Gradle Language Level", new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                buildModel.applyChanges();
                AndroidGradleJavaProjectModelModifier.registerUndoAction(project);
            }
        }.execute();
        return AndroidGradleJavaProjectModelModifier.requestProjectSync(project);
    }

    @NotNull
    private static String getConfigurationName(@NotNull Module module, @NotNull DependencyScope scope, @Nullable VirtualFile openedFile) {
        TestArtifactSearchScopes testScopes;
        if (!scope.isForProductionCompile() && (testScopes = TestArtifactSearchScopes.get(module)) != null && openedFile != null) {
            return testScopes.isAndroidTestSource(openedFile) ? "androidTestCompile" : "testCompile";
        }
        return "compile";
    }

    @Nullable
    private static String selectVersion(@NotNull ExternalLibraryDescriptor descriptor) {
        String groupAndId = descriptor.getLibraryGroupId() + ":" + descriptor.getLibraryArtifactId();
        return EXTERNAL_LIBRARY_VERSIONS.get(groupAndId);
    }

    @NotNull
    private static Promise<Void> requestProjectSync(@NotNull Project project) {
        final AsyncPromise promise = new AsyncPromise();
        GradleSyncInvoker.Request request = new GradleSyncInvoker.Request().setGenerateSourcesOnSuccess(false).setTrigger(GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED);
        GradleSyncInvoker.getInstance().requestProjectSync(project, request, new GradleSyncListener.Adapter(){

            @Override
            public void syncSucceeded(@NotNull Project project) {
                promise.setResult(null);
            }

            @Override
            public void syncFailed(@NotNull Project project, @NotNull String errorMessage) {
                promise.setError(errorMessage);
            }
        });
        return promise;
    }

    private static void registerUndoAction(final @NotNull Project project) {
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

            public void undo() throws UnexpectedUndoException {
                AndroidGradleJavaProjectModelModifier.requestProjectSync(project);
            }

            public void redo() throws UnexpectedUndoException {
                AndroidGradleJavaProjectModelModifier.requestProjectSync(project);
            }
        });
    }

    @Nullable
    private static ArtifactDependencySpec findNewExternalDependency(@NotNull Project project, @NotNull Library library) {
        if (library.getName() == null) {
            return null;
        }
        ArtifactDependencySpec result = null;
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(module);
            if (androidModel == null || LibraryUtil.findLibrary((Module)module, (String)library.getName()) == null) continue;
            result = AndroidGradleJavaProjectModelModifier.findNewExternalDependency(library, androidModel.getSelectedVariant());
            break;
        }
        if (result == null) {
            result = AndroidGradleJavaProjectModelModifier.findNewExternalDependencyByExaminingPath(library);
        }
        return result;
    }

    @Nullable
    private static ArtifactDependencySpec findNewExternalDependency(@NotNull Library library, @NotNull IdeVariant selectedVariant) {
        IdeBaseArtifact testArtifact;
        JavaLibrary matchedLibrary = null;
        Iterator<IdeBaseArtifact> iterator = selectedVariant.getTestArtifacts().iterator();
        while (iterator.hasNext() && (matchedLibrary = AndroidGradleJavaProjectModelModifier.findMatchedLibrary(library, testArtifact = iterator.next())) == null) {
        }
        if (matchedLibrary == null) {
            matchedLibrary = AndroidGradleJavaProjectModelModifier.findMatchedLibrary(library, selectedVariant.getMainArtifact());
        }
        if (matchedLibrary == null) {
            return null;
        }
        MavenCoordinates coordinates = matchedLibrary.getResolvedCoordinates();
        if (coordinates == null) {
            return null;
        }
        return new ArtifactDependencySpec(coordinates.getArtifactId(), coordinates.getGroupId(), coordinates.getVersion());
    }

    @Nullable
    private static JavaLibrary findMatchedLibrary(@NotNull Library library, @NotNull BaseArtifact artifact) {
        Dependencies dependencies2 = artifact.getDependencies();
        for (JavaLibrary gradleLibrary : dependencies2.getJavaLibraries()) {
            String libraryName = FileUtil.getNameWithoutExtension((File)gradleLibrary.getJarFile());
            if (!libraryName.equals(library.getName())) continue;
            return gradleLibrary;
        }
        return null;
    }

    @Nullable
    private static ArtifactDependencySpec findNewExternalDependencyByExaminingPath(@NotNull Library library) {
        VirtualFile[] files = library.getFiles(OrderRootType.CLASSES);
        if (files.length == 0) {
            return null;
        }
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)files[0]);
        String libraryName = library.getName();
        if (libraryName == null) {
            return null;
        }
        List pathSegments = FileUtil.splitPath((String)file.getPath());
        for (int i = 1; i < pathSegments.size() - 2; ++i) {
            if (!libraryName.startsWith((String)pathSegments.get(i))) continue;
            String groupId = (String)pathSegments.get(i - 1);
            String artifactId = (String)pathSegments.get(i);
            String version = (String)pathSegments.get(i + 1);
            if (!libraryName.endsWith(version)) continue;
            return new ArtifactDependencySpec(artifactId, groupId, version);
        }
        return null;
    }
}

