/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle;

import com.intellij.jarFinder.InternetAttachSourceProvider;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryFilePaths {
    @NotNull
    public static LibraryFilePaths getInstance() {
        return (LibraryFilePaths)ServiceManager.getService(LibraryFilePaths.class);
    }

    @Nullable
    public File findSourceJarPath(@NotNull File libraryPath) {
        return LibraryFilePaths.findArtifactFilePathInRepository(libraryPath, "-sources.jar", true);
    }

    @Nullable
    public File findJavadocJarPath(@NotNull File libraryPath) {
        return LibraryFilePaths.findArtifactFilePathInRepository(libraryPath, "-javadoc.jar", true);
    }

    @Nullable
    public File findPomPathForLibrary(@NotNull File libraryPath) {
        return LibraryFilePaths.findArtifactFilePathInRepository(libraryPath, ".pom", false);
    }

    @Nullable
    private static File findArtifactFilePathInRepository(@NotNull File libraryPath, @NotNull String fileNameSuffix, boolean searchInIdeCache) {
        File librarySourceDirPath;
        File sourceJarPath;
        if (!libraryPath.isFile()) {
            return null;
        }
        File parentPath = libraryPath.getParentFile();
        String name = FileUtil.getNameWithoutExtension((File)libraryPath);
        String sourceFileName = name + fileNameSuffix;
        if (parentPath != null) {
            File sourceJar = LibraryFilePaths.findChildPath(parentPath, sourceFileName);
            if (sourceJar != null) {
                return sourceJar;
            }
            if ((parentPath = parentPath.getParentFile()) != null) {
                for (File child : FileUtil.notNullize((File[])parentPath.listFiles())) {
                    if (!child.isDirectory() || (sourceJar = LibraryFilePaths.findChildPath(child, sourceFileName)) == null) continue;
                    return sourceJar;
                }
            }
        }
        if (searchInIdeCache && (sourceJarPath = new File(librarySourceDirPath = InternetAttachSourceProvider.getLibrarySourceDir(), sourceFileName)).isFile()) {
            return sourceJarPath;
        }
        return null;
    }

    @Nullable
    private static File findChildPath(@NotNull File parentPath, @NotNull String childName) {
        for (File child : FileUtil.notNullize((File[])parentPath.listFiles())) {
            if (!childName.equals(child.getName())) continue;
            return child.isFile() ? child : null;
        }
        return null;
    }
}

