/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ApkPathFinder {
    ApkPathFinder() {
    }

    @Nullable
    File findExistingApkPath(@NotNull Module module, @Nullable String potentialPathValue) {
        AndroidModuleModel androidModel;
        File potentialPath;
        if (StringUtil.isNotEmpty((String)potentialPathValue) && (potentialPath = new File(potentialPathValue)).isDirectory()) {
            return potentialPath;
        }
        if (GradleProjectInfo.getInstance(module.getProject()).isBuildWithGradle() && (androidModel = AndroidModuleModel.get(module)) != null) {
            File buildFolderPath = androidModel.getAndroidProject().getBuildFolder();
            File potentialPath2 = new File(buildFolderPath, FileUtil.join((String[])new String[]{"outputs", "apk"}));
            if (potentialPath2.isDirectory()) {
                return potentialPath2;
            }
            if (buildFolderPath.isDirectory()) {
                return buildFolderPath;
            }
        }
        return (potentialPath = Projects.findModuleRootFolderPath(module)) != null && potentialPath.isDirectory() ? potentialPath : null;
    }
}

