/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.actions;

import com.android.tools.idea.gradle.actions.GoToApkLocationTask;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.run.OutputBuildAction;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class BuildApkAction
extends DumbAwareAction {
    private static final String ACTION_TEXT = "Build APK(s)";

    public BuildApkAction() {
        super(ACTION_TEXT);
    }

    public void update(AnActionEvent e) {
        Project project = e.getProject();
        e.getPresentation().setEnabledAndVisible(project != null && GradleProjectInfo.getInstance(project).isBuildWithGradle());
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project != null && GradleProjectInfo.getInstance(project).isBuildWithGradle()) {
            ArrayList<Module> appModules = new ArrayList<Module>();
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                String assembleTaskName;
                AndroidModuleModel androidModel;
                AndroidFacet facet = AndroidFacet.getInstance(module);
                if (facet == null || (androidModel = AndroidModuleModel.get(facet)) == null || androidModel.getAndroidProject().getProjectType() != 0 && androidModel.getAndroidProject().getProjectType() != 4 || !StringUtil.isNotEmpty((String)(assembleTaskName = facet.getProperties().ASSEMBLE_TASK_NAME))) continue;
                appModules.add(module);
            }
            if (!appModules.isEmpty()) {
                GradleBuildInvoker gradleBuildInvoker = GradleBuildInvoker.getInstance(project);
                gradleBuildInvoker.add(new GoToApkLocationTask(appModules, ACTION_TEXT));
                gradleBuildInvoker.assemble(appModules.toArray(new Module[appModules.size()]), TestCompileType.ALL, new OutputBuildAction(BuildApkAction.getModuleGradlePaths(appModules)));
            }
        }
    }

    @NotNull
    private static List<String> getModuleGradlePaths(@NotNull List<Module> modules) {
        ArrayList<String> gradlePaths = new ArrayList<String>();
        for (Module module : modules) {
            String gradlePath = GradleUtil.getGradlePath(module);
            if (gradlePath == null) continue;
            gradlePaths.add(gradlePath);
        }
        return gradlePaths;
    }
}

