/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dependencies;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.templates.RepositoryUrlManager;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleDependencyManager {
    private static final String ADD_DEPENDENCY = "Add Dependency";

    @NotNull
    public static GradleDependencyManager getInstance(@NotNull Project project) {
        return (GradleDependencyManager)ServiceManager.getService((Project)project, GradleDependencyManager.class);
    }

    public boolean dependsOn(@NotNull Module module, @NotNull String artifact) {
        AndroidModuleModel gradleModel = AndroidModuleModel.get(module);
        return gradleModel != null && GradleUtil.dependsOn(gradleModel, artifact);
    }

    @NotNull
    public List<GradleCoordinate> findMissingDependencies(@NotNull Module module, @NotNull Iterable<GradleCoordinate> dependencies2) {
        AndroidModuleModel gradleModel = AndroidModuleModel.get(module);
        GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (gradleModel == null && buildModel == null) {
            return Collections.emptyList();
        }
        String configurationName = GradleUtil.mapConfigurationName("compile", GradleUtil.getAndroidGradleModelVersionInUse(module), false);
        List<ArtifactDependencyModel> compileDependencies = buildModel != null ? buildModel.dependencies().artifacts(configurationName) : null;
        GradleVersion appCompatVersion = null;
        if (compileDependencies != null) {
            for (ArtifactDependencyModel dependency : compileDependencies) {
                if (!Objects.equal((Object)"com.android.support", dependency.group().value()) || Objects.equal((Object)"multidex", (Object)dependency.name().value())) continue;
                String s = (String)dependency.version().value();
                if (s == null) break;
                appCompatVersion = GradleVersion.tryParse((String)s);
                break;
            }
        }
        Project project = module.getProject();
        RepositoryUrlManager manager = RepositoryUrlManager.get();
        ArrayList missingLibraries = Lists.newArrayList();
        for (GradleCoordinate coordinate : dependencies2) {
            String groupId = coordinate.getGroupId();
            String artifactId = coordinate.getArtifactId();
            if (artifactId == null || groupId == null) continue;
            GradleCoordinate resolvedCoordinate = manager.resolveDynamicCoordinate(coordinate, project);
            if (appCompatVersion != null && coordinate.acceptsGreaterRevisions() && "com.android.support".equals(groupId) && !artifactId.equals("multidex")) {
                resolvedCoordinate = GradleCoordinate.parseCoordinateString((String)(groupId + ":" + artifactId + ":" + appCompatVersion.toString()));
            }
            if (resolvedCoordinate != null) {
                coordinate = resolvedCoordinate;
            }
            boolean dependencyFound = false;
            if (gradleModel != null && GradleUtil.dependsOn(gradleModel, String.format("%s:%s", groupId, artifactId))) {
                dependencyFound = true;
            } else if (compileDependencies != null) {
                for (ArtifactDependencyModel dependency : compileDependencies) {
                    if (!Objects.equal((Object)groupId, dependency.group().value()) || !Objects.equal((Object)artifactId, (Object)dependency.name().value())) continue;
                    dependencyFound = true;
                    break;
                }
            }
            if (dependencyFound) continue;
            missingLibraries.add(coordinate);
        }
        return missingLibraries;
    }

    public boolean ensureLibraryIsIncluded(@NotNull Module module, @NotNull Iterable<GradleCoordinate> dependencies2, @Nullable Runnable callback) {
        List<GradleCoordinate> missing = this.findMissingDependencies(module, dependencies2);
        if (missing.isEmpty()) {
            return true;
        }
        GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (buildModel == null) {
            return false;
        }
        if (GradleDependencyManager.userWantToAddDependencies(module, missing)) {
            GradleDependencyManager.addDependenciesInTransaction(buildModel, module, missing, callback);
            return true;
        }
        return false;
    }

    public boolean updateLibrariesToVersion(@NotNull Module module, @NotNull List<GradleCoordinate> dependencies2, @Nullable Runnable callback) {
        GradleBuildModel buildModel = GradleBuildModel.get(module);
        if (buildModel == null) {
            return false;
        }
        GradleDependencyManager.updateDependenciesInTransaction(buildModel, module, dependencies2, callback);
        return true;
    }

    public static boolean userWantToAddDependencies(@NotNull Module module, @NotNull Collection<GradleCoordinate> missing) {
        String libraryNames = StringUtil.join(missing, GradleCoordinate::getArtifactId, (String)", ");
        String message = String.format("This operation requires the %1$s %2$s. \n\nWould you like to add %3$s %1$s now?", StringUtil.pluralize((String)"library", (int)missing.size()), libraryNames, StringUtil.pluralize((String)"this", (int)missing.size()));
        Project project = module.getProject();
        return Messages.showOkCancelDialog((Project)project, (String)message, (String)"Add Project Dependency", (Icon)Messages.getErrorIcon()) == 0;
    }

    public static void addDependenciesInTransaction(final @NotNull GradleBuildModel buildModel, final @NotNull Module module, final @NotNull List<GradleCoordinate> coordinates, final @Nullable Runnable callback) {
        assert (!coordinates.isEmpty());
        final Project project = module.getProject();
        new WriteCommandAction(project, ADD_DEPENDENCY, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                GradleDependencyManager.addDependencies(buildModel, module, coordinates);
                GradleDependencyManager.requestProjectSync(project, callback);
            }
        }.execute();
    }

    private static void addDependencies(@NotNull GradleBuildModel buildModel, @NotNull Module module, @NotNull List<GradleCoordinate> coordinates) {
        ModuleRootModificationUtil.updateModel((Module)module, model -> {
            DependenciesModel dependenciesModel = buildModel.dependencies();
            for (GradleCoordinate coordinate : coordinates) {
                String name = GradleUtil.mapConfigurationName("compile", GradleUtil.getAndroidGradleModelVersionInUse(module), false);
                dependenciesModel.addArtifact(name, coordinate.toString());
            }
            buildModel.applyChanges();
        });
    }

    private static void updateDependenciesInTransaction(final @NotNull GradleBuildModel buildModel, final @NotNull Module module, final @NotNull List<GradleCoordinate> coordinates, final @Nullable Runnable callback) {
        assert (!coordinates.isEmpty());
        final Project project = module.getProject();
        new WriteCommandAction(project, ADD_DEPENDENCY, new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                GradleDependencyManager.updateDependencies(buildModel, module, coordinates);
                GradleDependencyManager.requestProjectSync(project, callback);
            }
        }.execute();
    }

    private static void requestProjectSync(@NotNull Project project, @Nullable Runnable callback) {
        if (callback != null) {
            GradleBuildInvoker.getInstance(project).add(new GradleCompletionTask(project, callback));
        }
        GradleSyncInvoker.Request request = new GradleSyncInvoker.Request().setGenerateSourcesOnSuccess(true).setTrigger(GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED);
        GradleSyncInvoker.getInstance().requestProjectSync(project, request, null);
    }

    private static void updateDependencies(@NotNull GradleBuildModel buildModel, @NotNull Module module, @NotNull List<GradleCoordinate> coordinates) {
        ModuleRootModificationUtil.updateModel((Module)module, model -> {
            DependenciesModel dependenciesModel = buildModel.dependencies();
            for (GradleCoordinate gc : coordinates) {
                ArrayList artifacts = Lists.newArrayList(dependenciesModel.artifacts());
                for (ArtifactDependencyModel m : artifacts) {
                    if (gc.getGroupId() == null || !gc.getGroupId().equals(m.group().value()) || gc.getArtifactId() == null || !gc.getArtifactId().equals(m.name().value()) || gc.getRevision().equals(m.version().value())) continue;
                    dependenciesModel.remove(m);
                    dependenciesModel.addArtifact(m.configurationName(), gc.toString());
                }
            }
            buildModel.applyChanges();
        });
    }

    private static class GradleCompletionTask
    implements GradleBuildInvoker.AfterGradleInvocationTask {
        private final Project myProject;
        private final Runnable myCallback;

        private GradleCompletionTask(@NotNull Project project, @NotNull Runnable callback) {
            this.myProject = project;
            this.myCallback = callback;
        }

        @Override
        public void execute(@NotNull GradleInvocationResult result) {
            GradleBuildInvoker.getInstance(this.myProject).remove(this);
            this.myCallback.run();
        }
    }
}

