/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.model.values.GradleNullableValue;
import com.android.tools.idea.gradle.dsl.parser.android.AdbOptionsDslElement;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdbOptionsModel
extends GradleDslBlockModel {
    @NonNls
    private static final String INSTALL_OPTIONS = "installOptions";
    @NonNls
    private static final String TIME_OUT_IN_MS = "timeOutInMs";

    public AdbOptionsModel(@NotNull AdbOptionsDslElement dslElement) {
        super(dslElement);
    }

    @Nullable
    public List<GradleNotNullValue<String>> installOptions() {
        return this.myDslElement.getListProperty(INSTALL_OPTIONS, String.class);
    }

    @NotNull
    public AdbOptionsModel addInstallOption(@NotNull String installOption) {
        this.myDslElement.addToNewLiteralList(INSTALL_OPTIONS, installOption);
        return this;
    }

    @NotNull
    public AdbOptionsModel removeInstallOption(@NotNull String installOption) {
        this.myDslElement.removeFromExpressionList(INSTALL_OPTIONS, installOption);
        return this;
    }

    @NotNull
    public AdbOptionsModel removeAllInstallOptions() {
        this.myDslElement.removeProperty(INSTALL_OPTIONS);
        return this;
    }

    @NotNull
    public AdbOptionsModel replaceInstallOption(@NotNull String oldInstallOption, @NotNull String newInstallOption) {
        this.myDslElement.replaceInExpressionList(INSTALL_OPTIONS, oldInstallOption, newInstallOption);
        return this;
    }

    @NotNull
    public GradleNullableValue<Integer> timeOutInMs() {
        return this.myDslElement.getLiteralProperty(TIME_OUT_IN_MS, Integer.class);
    }

    @NotNull
    public AdbOptionsModel setTimeOutInMs(int timeOutInMs) {
        this.myDslElement.setNewLiteral(TIME_OUT_IN_MS, timeOutInMs);
        return this;
    }

    @NotNull
    public AdbOptionsModel removeTimeOutInMs() {
        this.myDslElement.removeProperty(TIME_OUT_IN_MS);
        return this;
    }
}

