/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.android.AaptOptionsModel;
import com.android.tools.idea.gradle.dsl.model.android.AdbOptionsModel;
import com.android.tools.idea.gradle.dsl.model.android.BuildTypeModel;
import com.android.tools.idea.gradle.dsl.model.android.CompileOptionsModel;
import com.android.tools.idea.gradle.dsl.model.android.DataBindingModel;
import com.android.tools.idea.gradle.dsl.model.android.DexOptionsModel;
import com.android.tools.idea.gradle.dsl.model.android.ExternalNativeBuildModel;
import com.android.tools.idea.gradle.dsl.model.android.LintOptionsModel;
import com.android.tools.idea.gradle.dsl.model.android.PackagingOptionsModel;
import com.android.tools.idea.gradle.dsl.model.android.ProductFlavorModel;
import com.android.tools.idea.gradle.dsl.model.android.SigningConfigModel;
import com.android.tools.idea.gradle.dsl.model.android.SourceSetModel;
import com.android.tools.idea.gradle.dsl.model.android.SplitsModel;
import com.android.tools.idea.gradle.dsl.model.android.TestOptionsModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.model.values.GradleNullableValue;
import com.android.tools.idea.gradle.dsl.parser.android.AaptOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.AdbOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.AndroidDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.BuildTypeDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.BuildTypesDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.CompileOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.DataBindingDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.DexOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.ExternalNativeBuildDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.LintOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.PackagingOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.ProductFlavorDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.ProductFlavorsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.SigningConfigDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.SigningConfigsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.SourceSetDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.SourceSetsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.SplitsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.TestOptionsDslElement;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidModel
extends GradleDslBlockModel {
    @NonNls
    private static final String BUILD_TOOLS_VERSION = "buildToolsVersion";
    @NonNls
    private static final String COMPILE_SDK_VERSION = "compileSdkVersion";
    @NonNls
    private static final String DEFAULT_CONFIG = "defaultConfig";
    @NonNls
    private static final String DEFAULT_PUBLISH_CONFIG = "defaultPublishConfig";
    @NonNls
    private static final String FLAVOR_DIMENSIONS = "flavorDimensions";
    @NonNls
    private static final String GENERATE_PURE_SPLITS = "generatePureSplits";
    @NonNls
    private static final String PUBLISH_NON_DEFAULT = "publishNonDefault";
    @NonNls
    private static final String RESOURCE_PREFIX = "resourcePrefix";

    public AndroidModel(@NotNull AndroidDslElement dslElement) {
        super(dslElement);
    }

    @NotNull
    public AaptOptionsModel aaptOptions() {
        AaptOptionsDslElement aaptOptionsElement = this.myDslElement.getPropertyElement("aaptOptions", AaptOptionsDslElement.class);
        if (aaptOptionsElement == null) {
            aaptOptionsElement = new AaptOptionsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("aaptOptions", aaptOptionsElement);
        }
        return new AaptOptionsModel(aaptOptionsElement);
    }

    @NotNull
    public AdbOptionsModel adbOptions() {
        AdbOptionsDslElement adbOptionsElement = this.myDslElement.getPropertyElement("adbOptions", AdbOptionsDslElement.class);
        if (adbOptionsElement == null) {
            adbOptionsElement = new AdbOptionsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("adbOptions", adbOptionsElement);
        }
        return new AdbOptionsModel(adbOptionsElement);
    }

    @NotNull
    public GradleNullableValue<String> buildToolsVersion() {
        return this.getIntOrStringValue(BUILD_TOOLS_VERSION);
    }

    @NotNull
    public AndroidModel setBuildToolsVersion(int buildToolsVersion) {
        this.myDslElement.setNewLiteral(BUILD_TOOLS_VERSION, buildToolsVersion);
        return this;
    }

    @NotNull
    public AndroidModel setBuildToolsVersion(@NotNull String buildToolsVersion) {
        this.myDslElement.setNewLiteral(BUILD_TOOLS_VERSION, buildToolsVersion);
        return this;
    }

    @NotNull
    public AndroidModel removeBuildToolsVersion() {
        this.myDslElement.removeProperty(BUILD_TOOLS_VERSION);
        return this;
    }

    @NotNull
    public List<BuildTypeModel> buildTypes() {
        BuildTypesDslElement buildTypes = this.myDslElement.getPropertyElement("buildTypes", BuildTypesDslElement.class);
        return buildTypes == null ? ImmutableList.of() : buildTypes.get();
    }

    @NotNull
    public AndroidModel addBuildType(@NotNull String buildType) {
        BuildTypeDslElement buildTypeElement;
        BuildTypesDslElement buildTypes = this.myDslElement.getPropertyElement("buildTypes", BuildTypesDslElement.class);
        if (buildTypes == null) {
            buildTypes = new BuildTypesDslElement(this.myDslElement);
            this.myDslElement.setNewElement("buildTypes", buildTypes);
        }
        if ((buildTypeElement = buildTypes.getPropertyElement(buildType, BuildTypeDslElement.class)) == null) {
            buildTypeElement = new BuildTypeDslElement(buildTypes, buildType);
            buildTypes.setNewElement(buildType, buildTypeElement);
        }
        return this;
    }

    @NotNull
    public AndroidModel removeBuildType(@NotNull String buildType) {
        BuildTypesDslElement buildTypes = this.myDslElement.getPropertyElement("buildTypes", BuildTypesDslElement.class);
        if (buildTypes != null) {
            buildTypes.removeProperty(buildType);
        }
        return this;
    }

    @NotNull
    public CompileOptionsModel compileOptions() {
        CompileOptionsDslElement element = this.myDslElement.getPropertyElement("compileOptions", CompileOptionsDslElement.class);
        if (element == null) {
            element = new CompileOptionsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("compileOptions", element);
        }
        return new CompileOptionsModel(element, false);
    }

    @NotNull
    public GradleNullableValue<String> compileSdkVersion() {
        return this.getIntOrStringValue(COMPILE_SDK_VERSION);
    }

    @NotNull
    public AndroidModel setCompileSdkVersion(int compileSdkVersion) {
        this.myDslElement.setNewLiteral(COMPILE_SDK_VERSION, compileSdkVersion);
        return this;
    }

    @NotNull
    public AndroidModel setCompileSdkVersion(@NotNull String compileSdkVersion) {
        this.myDslElement.setNewLiteral(COMPILE_SDK_VERSION, compileSdkVersion);
        return this;
    }

    @NotNull
    public AndroidModel removeCompileSdkVersion() {
        this.myDslElement.removeProperty(COMPILE_SDK_VERSION);
        return this;
    }

    @NotNull
    public DataBindingModel dataBinding() {
        DataBindingDslElement dataBindingElement = this.myDslElement.getPropertyElement("dataBinding", DataBindingDslElement.class);
        if (dataBindingElement == null) {
            dataBindingElement = new DataBindingDslElement(this.myDslElement);
            this.myDslElement.setNewElement("dataBinding", dataBindingElement);
        }
        return new DataBindingModel(dataBindingElement);
    }

    @NotNull
    public ProductFlavorModel defaultConfig() {
        ProductFlavorDslElement defaultConfigElement = this.myDslElement.getPropertyElement(DEFAULT_CONFIG, ProductFlavorDslElement.class);
        if (defaultConfigElement == null) {
            defaultConfigElement = new ProductFlavorDslElement(this.myDslElement, DEFAULT_CONFIG);
            this.myDslElement.setNewElement(DEFAULT_CONFIG, defaultConfigElement);
        }
        return new ProductFlavorModel(defaultConfigElement);
    }

    @NotNull
    public GradleNullableValue<String> defaultPublishConfig() {
        return this.myDslElement.getLiteralProperty(DEFAULT_PUBLISH_CONFIG, String.class);
    }

    @NotNull
    public AndroidModel setDefaultPublishConfig(@NotNull String defaultPublishConfig) {
        this.myDslElement.setNewLiteral(DEFAULT_PUBLISH_CONFIG, defaultPublishConfig);
        return this;
    }

    @NotNull
    public AndroidModel removeDefaultPublishConfig() {
        this.myDslElement.removeProperty(DEFAULT_PUBLISH_CONFIG);
        return this;
    }

    @NotNull
    public DexOptionsModel dexOptions() {
        DexOptionsDslElement dexOptionsElement = this.myDslElement.getPropertyElement("dexOptions", DexOptionsDslElement.class);
        if (dexOptionsElement == null) {
            dexOptionsElement = new DexOptionsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("dexOptions", dexOptionsElement);
        }
        return new DexOptionsModel(dexOptionsElement);
    }

    @NotNull
    public ExternalNativeBuildModel externalNativeBuild() {
        ExternalNativeBuildDslElement externalNativeBuildDslElement = this.myDslElement.getPropertyElement("externalNativeBuild", ExternalNativeBuildDslElement.class);
        if (externalNativeBuildDslElement == null) {
            externalNativeBuildDslElement = new ExternalNativeBuildDslElement(this.myDslElement);
            this.myDslElement.setNewElement("externalNativeBuild", externalNativeBuildDslElement);
        }
        return new ExternalNativeBuildModel(externalNativeBuildDslElement);
    }

    @Nullable
    public List<GradleNotNullValue<String>> flavorDimensions() {
        return this.myDslElement.getListProperty(FLAVOR_DIMENSIONS, String.class);
    }

    @NotNull
    public AndroidModel addFlavorDimension(@NotNull String flavorDimension) {
        this.myDslElement.addToNewLiteralList(FLAVOR_DIMENSIONS, flavorDimension);
        return this;
    }

    @NotNull
    public AndroidModel removeFlavorDimension(@NotNull String flavorDimension) {
        this.myDslElement.removeFromExpressionList(FLAVOR_DIMENSIONS, flavorDimension);
        return this;
    }

    @NotNull
    public AndroidModel removeAllFlavorDimensions() {
        this.myDslElement.removeProperty(FLAVOR_DIMENSIONS);
        return this;
    }

    @NotNull
    public AndroidModel replaceFlavorDimension(@NotNull String oldFlavorDimension, @NotNull String newFlavorDimension) {
        this.myDslElement.replaceInExpressionList(FLAVOR_DIMENSIONS, oldFlavorDimension, newFlavorDimension);
        return this;
    }

    @NotNull
    public GradleNullableValue<Boolean> generatePureSplits() {
        return this.myDslElement.getLiteralProperty(GENERATE_PURE_SPLITS, Boolean.class);
    }

    @NotNull
    public AndroidModel setGeneratePureSplits(boolean generatePureSplits) {
        this.myDslElement.setNewLiteral(GENERATE_PURE_SPLITS, generatePureSplits);
        return this;
    }

    @NotNull
    public AndroidModel removeGeneratePureSplits() {
        this.myDslElement.removeProperty(GENERATE_PURE_SPLITS);
        return this;
    }

    @NotNull
    public LintOptionsModel lintOptions() {
        LintOptionsDslElement lintOptionsDslElement = this.myDslElement.getPropertyElement("lintOptions", LintOptionsDslElement.class);
        if (lintOptionsDslElement == null) {
            lintOptionsDslElement = new LintOptionsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("lintOptions", lintOptionsDslElement);
        }
        return new LintOptionsModel(lintOptionsDslElement);
    }

    @NotNull
    public PackagingOptionsModel packagingOptions() {
        PackagingOptionsDslElement packagingOptionsDslElement = this.myDslElement.getPropertyElement("packagingOptions", PackagingOptionsDslElement.class);
        if (packagingOptionsDslElement == null) {
            packagingOptionsDslElement = new PackagingOptionsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("packagingOptions", packagingOptionsDslElement);
        }
        return new PackagingOptionsModel(packagingOptionsDslElement);
    }

    @NotNull
    public List<ProductFlavorModel> productFlavors() {
        ProductFlavorsDslElement productFlavors = this.myDslElement.getPropertyElement("productFlavors", ProductFlavorsDslElement.class);
        return productFlavors == null ? ImmutableList.of() : productFlavors.get();
    }

    @NotNull
    public AndroidModel addProductFlavor(@NotNull String flavor) {
        ProductFlavorDslElement flavorElement;
        ProductFlavorsDslElement productFlavors = this.myDslElement.getPropertyElement("productFlavors", ProductFlavorsDslElement.class);
        if (productFlavors == null) {
            productFlavors = new ProductFlavorsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("productFlavors", productFlavors);
        }
        if ((flavorElement = productFlavors.getPropertyElement(flavor, ProductFlavorDslElement.class)) == null) {
            flavorElement = new ProductFlavorDslElement(productFlavors, flavor);
            productFlavors.setNewElement(flavor, flavorElement);
        }
        return this;
    }

    @NotNull
    public AndroidModel removeProductFlavor(@NotNull String flavor) {
        ProductFlavorsDslElement productFlavors = this.myDslElement.getPropertyElement("productFlavors", ProductFlavorsDslElement.class);
        if (productFlavors != null) {
            productFlavors.removeProperty(flavor);
        }
        return this;
    }

    @NotNull
    public List<SigningConfigModel> signingConfigs() {
        SigningConfigsDslElement signingConfigs = this.myDslElement.getPropertyElement("signingConfigs", SigningConfigsDslElement.class);
        return signingConfigs == null ? ImmutableList.of() : signingConfigs.get();
    }

    @NotNull
    public AndroidModel addSigningConfig(@NotNull String config) {
        SigningConfigDslElement configElement;
        SigningConfigsDslElement signingConfigs = this.myDslElement.getPropertyElement("signingConfigs", SigningConfigsDslElement.class);
        if (signingConfigs == null) {
            signingConfigs = new SigningConfigsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("signingConfigs", signingConfigs);
        }
        if ((configElement = signingConfigs.getPropertyElement(config, SigningConfigDslElement.class)) == null) {
            configElement = new SigningConfigDslElement(signingConfigs, config);
            signingConfigs.setNewElement(config, configElement);
        }
        return this;
    }

    @NotNull
    public AndroidModel removeSigningConfig(@NotNull String configName) {
        SigningConfigsDslElement signingConfig = this.myDslElement.getPropertyElement("signingConfigs", SigningConfigsDslElement.class);
        if (signingConfig != null) {
            signingConfig.removeProperty(configName);
        }
        return this;
    }

    @NotNull
    public List<SourceSetModel> sourceSets() {
        SourceSetsDslElement sourceSets = this.myDslElement.getPropertyElement("sourceSets", SourceSetsDslElement.class);
        return sourceSets == null ? ImmutableList.of() : sourceSets.get();
    }

    @NotNull
    public AndroidModel addSourceSet(@NotNull String sourceSet) {
        SourceSetDslElement sourceSetElement;
        SourceSetsDslElement sourceSets = this.myDslElement.getPropertyElement("sourceSets", SourceSetsDslElement.class);
        if (sourceSets == null) {
            sourceSets = new SourceSetsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("sourceSets", sourceSets);
        }
        if ((sourceSetElement = sourceSets.getPropertyElement(sourceSet, SourceSetDslElement.class)) == null) {
            sourceSetElement = new SourceSetDslElement(sourceSets, sourceSet);
            sourceSets.setNewElement(sourceSet, sourceSetElement);
        }
        return this;
    }

    @NotNull
    public AndroidModel removeSourceSet(@NotNull String sourceSet) {
        SourceSetsDslElement sourceSets = this.myDslElement.getPropertyElement("sourceSets", SourceSetsDslElement.class);
        if (sourceSets != null) {
            sourceSets.removeProperty(sourceSet);
        }
        return this;
    }

    @NotNull
    public SplitsModel splits() {
        SplitsDslElement splitsDslElement = this.myDslElement.getPropertyElement("splits", SplitsDslElement.class);
        if (splitsDslElement == null) {
            splitsDslElement = new SplitsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("splits", splitsDslElement);
        }
        return new SplitsModel(splitsDslElement);
    }

    @NotNull
    public TestOptionsModel testOptions() {
        TestOptionsDslElement testOptionsDslElement = this.myDslElement.getPropertyElement("testOptions", TestOptionsDslElement.class);
        if (testOptionsDslElement == null) {
            testOptionsDslElement = new TestOptionsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("testOptions", testOptionsDslElement);
        }
        return new TestOptionsModel(testOptionsDslElement);
    }

    @NotNull
    public GradleNullableValue<Boolean> publishNonDefault() {
        return this.myDslElement.getLiteralProperty(PUBLISH_NON_DEFAULT, Boolean.class);
    }

    @NotNull
    public AndroidModel setPublishNonDefault(boolean publishNonDefault) {
        this.myDslElement.setNewLiteral(PUBLISH_NON_DEFAULT, publishNonDefault);
        return this;
    }

    @NotNull
    public AndroidModel removePublishNonDefault() {
        this.myDslElement.removeProperty(PUBLISH_NON_DEFAULT);
        return this;
    }

    @NotNull
    public GradleNullableValue<String> resourcePrefix() {
        return this.myDslElement.getLiteralProperty(RESOURCE_PREFIX, String.class);
    }

    @NotNull
    public AndroidModel setResourcePrefix(@NotNull String resourcePrefix) {
        this.myDslElement.setNewLiteral(RESOURCE_PREFIX, resourcePrefix);
        return this;
    }

    @NotNull
    public AndroidModel removeResourcePrefix() {
        this.myDslElement.removeProperty(RESOURCE_PREFIX);
        return this;
    }
}

