/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.model.values.GradleNullableValue;
import com.android.tools.idea.gradle.dsl.parser.android.DexOptionsDslElement;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DexOptionsModel
extends GradleDslBlockModel {
    @NonNls
    private static final String ADDITIONAL_PARAMETERS = "additionalParameters";
    @NonNls
    private static final String JAVA_MAX_HEAP_SIZE = "javaMaxHeapSize";
    @NonNls
    private static final String JUMBO_MODE = "jumboMode";
    @NonNls
    private static final String KEEP_RUNTIME_ANNOTATED_CLASSES = "keepRuntimeAnnotatedClasses";
    @NonNls
    private static final String MAX_PROCESS_COUNT = "maxProcessCount";
    @NonNls
    private static final String OPTIMIZE = "optimize";
    @NonNls
    private static final String PRE_DEX_LIBRARIES = "preDexLibraries";
    @NonNls
    private static final String THREAD_COUNT = "threadCount";

    public DexOptionsModel(@NotNull DexOptionsDslElement dslElement) {
        super(dslElement);
    }

    @Nullable
    public List<GradleNotNullValue<String>> additionalParameters() {
        return this.myDslElement.getListProperty(ADDITIONAL_PARAMETERS, String.class);
    }

    @NotNull
    public DexOptionsModel addAdditionalParameter(@NotNull String additionalParameter) {
        this.myDslElement.addToNewLiteralList(ADDITIONAL_PARAMETERS, additionalParameter);
        return this;
    }

    @NotNull
    public DexOptionsModel removeAdditionalParameter(@NotNull String additionalParameter) {
        this.myDslElement.removeFromExpressionList(ADDITIONAL_PARAMETERS, additionalParameter);
        return this;
    }

    @NotNull
    public DexOptionsModel removeAllAdditionalParameters() {
        this.myDslElement.removeProperty(ADDITIONAL_PARAMETERS);
        return this;
    }

    @NotNull
    public DexOptionsModel replaceAdditionalParameter(@NotNull String oldAdditionalParameter, @NotNull String newAdditionalParameter) {
        this.myDslElement.replaceInExpressionList(ADDITIONAL_PARAMETERS, oldAdditionalParameter, newAdditionalParameter);
        return this;
    }

    @NotNull
    public GradleNullableValue<String> javaMaxHeapSize() {
        return this.myDslElement.getLiteralProperty(JAVA_MAX_HEAP_SIZE, String.class);
    }

    @NotNull
    public DexOptionsModel setJavaMaxHeapSize(@NotNull String javaMaxHeapSize) {
        this.myDslElement.setNewLiteral(JAVA_MAX_HEAP_SIZE, javaMaxHeapSize);
        return this;
    }

    @NotNull
    public DexOptionsModel removeJavaMaxHeapSize() {
        this.myDslElement.removeProperty(JAVA_MAX_HEAP_SIZE);
        return this;
    }

    @NotNull
    public GradleNullableValue<Boolean> jumboMode() {
        return this.myDslElement.getLiteralProperty(JUMBO_MODE, Boolean.class);
    }

    @NotNull
    public DexOptionsModel setJumboMode(boolean jumboMode) {
        this.myDslElement.setNewLiteral(JUMBO_MODE, jumboMode);
        return this;
    }

    @NotNull
    public DexOptionsModel removeJumboMode() {
        this.myDslElement.removeProperty(JUMBO_MODE);
        return this;
    }

    @NotNull
    public GradleNullableValue<Boolean> keepRuntimeAnnotatedClasses() {
        return this.myDslElement.getLiteralProperty(KEEP_RUNTIME_ANNOTATED_CLASSES, Boolean.class);
    }

    @NotNull
    public DexOptionsModel setKeepRuntimeAnnotatedClasses(boolean keepRuntimeAnnotatedClasses) {
        this.myDslElement.setNewLiteral(KEEP_RUNTIME_ANNOTATED_CLASSES, keepRuntimeAnnotatedClasses);
        return this;
    }

    @NotNull
    public DexOptionsModel removeKeepRuntimeAnnotatedClasses() {
        this.myDslElement.removeProperty(KEEP_RUNTIME_ANNOTATED_CLASSES);
        return this;
    }

    @NotNull
    public GradleNullableValue<Integer> maxProcessCount() {
        return this.myDslElement.getLiteralProperty(MAX_PROCESS_COUNT, Integer.class);
    }

    @NotNull
    public DexOptionsModel setMaxProcessCount(int maxProcessCount) {
        this.myDslElement.setNewLiteral(MAX_PROCESS_COUNT, maxProcessCount);
        return this;
    }

    @NotNull
    public DexOptionsModel removeMaxProcessCount() {
        this.myDslElement.removeProperty(MAX_PROCESS_COUNT);
        return this;
    }

    @NotNull
    public GradleNullableValue<Boolean> optimize() {
        return this.myDslElement.getLiteralProperty(OPTIMIZE, Boolean.class);
    }

    @NotNull
    public DexOptionsModel setOptimize(boolean optimize) {
        this.myDslElement.setNewLiteral(OPTIMIZE, optimize);
        return this;
    }

    @NotNull
    public DexOptionsModel removeOptimize() {
        this.myDslElement.removeProperty(OPTIMIZE);
        return this;
    }

    @NotNull
    public GradleNullableValue<Boolean> preDexLibraries() {
        return this.myDslElement.getLiteralProperty(PRE_DEX_LIBRARIES, Boolean.class);
    }

    @NotNull
    public DexOptionsModel setPreDexLibraries(boolean preDexLibraries) {
        this.myDslElement.setNewLiteral(PRE_DEX_LIBRARIES, preDexLibraries);
        return this;
    }

    @NotNull
    public DexOptionsModel removePreDexLibraries() {
        this.myDslElement.removeProperty(PRE_DEX_LIBRARIES);
        return this;
    }

    @NotNull
    public GradleNullableValue<Integer> threadCount() {
        return this.myDslElement.getLiteralProperty(THREAD_COUNT, Integer.class);
    }

    @NotNull
    public DexOptionsModel setThreadCount(int threadCount) {
        this.myDslElement.setNewLiteral(THREAD_COUNT, threadCount);
        return this;
    }

    @NotNull
    public DexOptionsModel removeThreadCount() {
        this.myDslElement.removeProperty(THREAD_COUNT);
        return this;
    }
}

