/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.parser.android.PackagingOptionsDslElement;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagingOptionsModel
extends GradleDslBlockModel {
    @NonNls
    private static final String EXCLUDES = "excludes";
    @NonNls
    private static final String MERGES = "merges";
    @NonNls
    private static final String PICK_FIRSTS = "pickFirsts";

    public PackagingOptionsModel(@NotNull PackagingOptionsDslElement dslElement) {
        super(dslElement);
    }

    @Nullable
    public List<GradleNotNullValue<String>> excludes() {
        return this.myDslElement.getListProperty(EXCLUDES, String.class);
    }

    @NotNull
    public PackagingOptionsModel addExclude(@NotNull String exclude) {
        this.myDslElement.addToNewLiteralList(EXCLUDES, exclude);
        return this;
    }

    @NotNull
    public PackagingOptionsModel removeExclude(@NotNull String exclude) {
        this.myDslElement.removeFromExpressionList(EXCLUDES, exclude);
        return this;
    }

    @NotNull
    public PackagingOptionsModel removeAllExclude() {
        this.myDslElement.removeProperty(EXCLUDES);
        return this;
    }

    @NotNull
    public PackagingOptionsModel replaceExclude(@NotNull String oldExclude, @NotNull String newExclude) {
        this.myDslElement.replaceInExpressionList(EXCLUDES, oldExclude, newExclude);
        return this;
    }

    @Nullable
    public List<GradleNotNullValue<String>> merges() {
        return this.myDslElement.getListProperty(MERGES, String.class);
    }

    @NotNull
    public PackagingOptionsModel addMerge(@NotNull String merge) {
        this.myDslElement.addToNewLiteralList(MERGES, merge);
        return this;
    }

    @NotNull
    public PackagingOptionsModel removeMerge(@NotNull String merge) {
        this.myDslElement.removeFromExpressionList(MERGES, merge);
        return this;
    }

    @NotNull
    public PackagingOptionsModel removeAllMerges() {
        this.myDslElement.removeProperty(MERGES);
        return this;
    }

    @NotNull
    public PackagingOptionsModel replaceMerge(@NotNull String oldMerge, @NotNull String newMerge) {
        this.myDslElement.replaceInExpressionList(MERGES, oldMerge, newMerge);
        return this;
    }

    @Nullable
    public List<GradleNotNullValue<String>> pickFirsts() {
        return this.myDslElement.getListProperty(PICK_FIRSTS, String.class);
    }

    @NotNull
    public PackagingOptionsModel addPickFirst(@NotNull String pickFirst) {
        this.myDslElement.addToNewLiteralList(PICK_FIRSTS, pickFirst);
        return this;
    }

    @NotNull
    public PackagingOptionsModel removePickFirst(@NotNull String pickFirst) {
        this.myDslElement.removeFromExpressionList(PICK_FIRSTS, pickFirst);
        return this;
    }

    @NotNull
    public PackagingOptionsModel removeAllPickFirsts() {
        this.myDslElement.removeProperty(PICK_FIRSTS);
        return this;
    }

    @NotNull
    public PackagingOptionsModel replacePickFirst(@NotNull String oldPickFirst, @NotNull String newPickFirst) {
        this.myDslElement.replaceInExpressionList(PICK_FIRSTS, oldPickFirst, newPickFirst);
        return this;
    }
}

