/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.android.sourceSets.SourceDirectoryModel;
import com.android.tools.idea.gradle.dsl.model.android.sourceSets.SourceFileModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNullableValue;
import com.android.tools.idea.gradle.dsl.parser.android.SourceSetDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.sourceSets.SourceDirectoryDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.sourceSets.SourceFileDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SourceSetModel
extends GradleDslBlockModel {
    @NonNls
    private static final String AIDL = "aidl";
    @NonNls
    private static final String ASSETS = "assets";
    @NonNls
    private static final String JAVA = "java";
    @NonNls
    private static final String JNI = "jni";
    @NonNls
    private static final String JNI_LIBS = "jniLibs";
    @NonNls
    private static final String MANIFEST = "manifest";
    @NonNls
    private static final String RENDERSCRIPT = "renderscript";
    @NonNls
    private static final String RES = "res";
    @NonNls
    private static final String RESOURCES = "resources";
    @NonNls
    private static final String ROOT = "root";

    public SourceSetModel(@NotNull SourceSetDslElement dslElement) {
        super(dslElement);
    }

    @NotNull
    public String name() {
        return this.myDslElement.getName();
    }

    @NotNull
    public GradleNullableValue<String> root() {
        GradleDslExpression rootElement = this.myDslElement.getPropertyElement(ROOT, GradleDslExpression.class);
        if (rootElement == null) {
            return new GradleNullableValue<Object>(this.myDslElement, null);
        }
        String value = null;
        if (rootElement instanceof GradleDslMethodCall) {
            GradleDslElement pathArgument;
            List<GradleDslElement> arguments = ((GradleDslMethodCall)rootElement).getArguments();
            if (!arguments.isEmpty() && (pathArgument = arguments.get(0)) instanceof GradleDslExpression) {
                value = ((GradleDslExpression)pathArgument).getValue(String.class);
            }
        } else {
            value = rootElement.getValue(String.class);
        }
        return new GradleNullableValue<String>(rootElement, value);
    }

    @NotNull
    public SourceSetModel setRoot(@NotNull String root) {
        GradleDslElement pathArgument;
        List<GradleDslElement> arguments;
        GradleDslExpression rootElement = this.myDslElement.getPropertyElement(ROOT, GradleDslExpression.class);
        if (rootElement == null) {
            this.myDslElement.setNewLiteral(ROOT, root);
            return this;
        }
        if (rootElement instanceof GradleDslMethodCall && !(arguments = ((GradleDslMethodCall)rootElement).getArguments()).isEmpty() && (pathArgument = arguments.get(0)) instanceof GradleDslExpression) {
            ((GradleDslExpression)pathArgument).setValue(root);
            return this;
        }
        rootElement.setValue(root);
        return this;
    }

    @NotNull
    public SourceSetModel removeRoot() {
        this.myDslElement.removeProperty(ROOT);
        return this;
    }

    @NotNull
    public SourceDirectoryModel aidl() {
        SourceDirectoryDslElement aidl = this.myDslElement.getPropertyElement(AIDL, SourceDirectoryDslElement.class);
        if (aidl == null) {
            aidl = new SourceDirectoryDslElement(this.myDslElement, AIDL);
            this.myDslElement.setNewElement(AIDL, aidl);
        }
        return new SourceDirectoryModel(aidl);
    }

    @NotNull
    public SourceSetModel removeAidl() {
        this.myDslElement.removeProperty(AIDL);
        return this;
    }

    @NotNull
    public SourceDirectoryModel assets() {
        SourceDirectoryDslElement assets = this.myDslElement.getPropertyElement(ASSETS, SourceDirectoryDslElement.class);
        if (assets == null) {
            assets = new SourceDirectoryDslElement(this.myDslElement, ASSETS);
            this.myDslElement.setNewElement(ASSETS, assets);
        }
        return new SourceDirectoryModel(assets);
    }

    @NotNull
    public SourceSetModel removeAssets() {
        this.myDslElement.removeProperty(ASSETS);
        return this;
    }

    @NotNull
    public SourceDirectoryModel java() {
        SourceDirectoryDslElement java = this.myDslElement.getPropertyElement(JAVA, SourceDirectoryDslElement.class);
        if (java == null) {
            java = new SourceDirectoryDslElement(this.myDslElement, JAVA);
            this.myDslElement.setNewElement(JAVA, java);
        }
        return new SourceDirectoryModel(java);
    }

    @NotNull
    public SourceSetModel removeJava() {
        this.myDslElement.removeProperty(JAVA);
        return this;
    }

    @NotNull
    public SourceDirectoryModel jni() {
        SourceDirectoryDslElement jni = this.myDslElement.getPropertyElement(JNI, SourceDirectoryDslElement.class);
        if (jni == null) {
            jni = new SourceDirectoryDslElement(this.myDslElement, JNI);
            this.myDslElement.setNewElement(JNI, jni);
        }
        return new SourceDirectoryModel(jni);
    }

    @NotNull
    public SourceSetModel removeJni() {
        this.myDslElement.removeProperty(JNI);
        return this;
    }

    @NotNull
    public SourceDirectoryModel jniLibs() {
        SourceDirectoryDslElement jniLibs = this.myDslElement.getPropertyElement(JNI_LIBS, SourceDirectoryDslElement.class);
        if (jniLibs == null) {
            jniLibs = new SourceDirectoryDslElement(this.myDslElement, JNI_LIBS);
            this.myDslElement.setNewElement(JNI_LIBS, jniLibs);
        }
        return new SourceDirectoryModel(jniLibs);
    }

    @NotNull
    public SourceSetModel removeJniLibs() {
        this.myDslElement.removeProperty(JNI_LIBS);
        return this;
    }

    @NotNull
    public SourceFileModel manifest() {
        SourceFileDslElement manifest = this.myDslElement.getPropertyElement(MANIFEST, SourceFileDslElement.class);
        if (manifest == null) {
            manifest = new SourceFileDslElement(this.myDslElement, MANIFEST);
            this.myDslElement.setNewElement(MANIFEST, manifest);
        }
        return new SourceFileModel(manifest);
    }

    @NotNull
    public SourceSetModel removeManifest() {
        this.myDslElement.removeProperty(MANIFEST);
        return this;
    }

    @NotNull
    public SourceDirectoryModel renderscript() {
        SourceDirectoryDslElement renderscript = this.myDslElement.getPropertyElement(RENDERSCRIPT, SourceDirectoryDslElement.class);
        if (renderscript == null) {
            renderscript = new SourceDirectoryDslElement(this.myDslElement, RENDERSCRIPT);
            this.myDslElement.setNewElement(RENDERSCRIPT, renderscript);
        }
        return new SourceDirectoryModel(renderscript);
    }

    @NotNull
    public SourceSetModel removeRenderscript() {
        this.myDslElement.removeProperty(RENDERSCRIPT);
        return this;
    }

    @NotNull
    public SourceDirectoryModel res() {
        SourceDirectoryDslElement res = this.myDslElement.getPropertyElement(RES, SourceDirectoryDslElement.class);
        if (res == null) {
            res = new SourceDirectoryDslElement(this.myDslElement, RES);
            this.myDslElement.setNewElement(RES, res);
        }
        return new SourceDirectoryModel(res);
    }

    @NotNull
    public SourceSetModel removeRes() {
        this.myDslElement.removeProperty(RES);
        return this;
    }

    @NotNull
    public SourceDirectoryModel resources() {
        SourceDirectoryDslElement resources = this.myDslElement.getPropertyElement(RESOURCES, SourceDirectoryDslElement.class);
        if (resources == null) {
            resources = new SourceDirectoryDslElement(this.myDslElement, RESOURCES);
            this.myDslElement.setNewElement(RESOURCES, resources);
        }
        return new SourceDirectoryModel(resources);
    }

    @NotNull
    SourceSetModel removeResources() {
        this.myDslElement.removeProperty(RESOURCES);
        return this;
    }
}

