/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android.sourceSets;

import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.parser.android.sourceSets.SourceDirectoryDslElement;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourceDirectoryModel
extends GradleDslBlockModel {
    @NonNls
    private static final String EXCLUDE = "exclude";
    @NonNls
    private static final String INCLUDE = "include";
    @NonNls
    private static final String SRC_DIRS = "srcDirs";

    public SourceDirectoryModel(@NotNull SourceDirectoryDslElement dslElement) {
        super(dslElement);
    }

    @NotNull
    public String name() {
        return this.myDslElement.getName();
    }

    @Nullable
    public List<GradleNotNullValue<String>> excludes() {
        return this.myDslElement.getListProperty(EXCLUDE, String.class);
    }

    @NotNull
    public SourceDirectoryModel addExclude(@NotNull String exclude) {
        this.myDslElement.addToNewLiteralList(EXCLUDE, exclude);
        return this;
    }

    @NotNull
    public SourceDirectoryModel removeExclude(@NotNull String exclude) {
        this.myDslElement.removeFromExpressionList(EXCLUDE, exclude);
        return this;
    }

    @NotNull
    public SourceDirectoryModel removeAllExcludes() {
        this.myDslElement.removeProperty(EXCLUDE);
        return this;
    }

    @NotNull
    public SourceDirectoryModel replaceExclude(@NotNull String oldExclude, @NotNull String newExclude) {
        this.myDslElement.replaceInExpressionList(EXCLUDE, oldExclude, newExclude);
        return this;
    }

    @Nullable
    public List<GradleNotNullValue<String>> includes() {
        return this.myDslElement.getListProperty(INCLUDE, String.class);
    }

    @NotNull
    public SourceDirectoryModel addInclude(@NotNull String include) {
        this.myDslElement.addToNewLiteralList(INCLUDE, include);
        return this;
    }

    @NotNull
    public SourceDirectoryModel removeInclude(@NotNull String include) {
        this.myDslElement.removeFromExpressionList(INCLUDE, include);
        return this;
    }

    @NotNull
    public SourceDirectoryModel removeAllIncludes() {
        this.myDslElement.removeProperty(INCLUDE);
        return this;
    }

    @NotNull
    public SourceDirectoryModel replaceInclude(@NotNull String oldInclude, @NotNull String newInclude) {
        this.myDslElement.replaceInExpressionList(INCLUDE, oldInclude, newInclude);
        return this;
    }

    @Nullable
    public List<GradleNotNullValue<String>> srcDirs() {
        return this.myDslElement.getListProperty(SRC_DIRS, String.class);
    }

    @NotNull
    public SourceDirectoryModel addSrcDir(@NotNull String srcDir) {
        this.myDslElement.addToNewLiteralList(SRC_DIRS, srcDir);
        return this;
    }

    @NotNull
    public SourceDirectoryModel removeSrcDir(@NotNull String srcDir) {
        this.myDslElement.removeFromExpressionList(SRC_DIRS, srcDir);
        return this;
    }

    @NotNull
    public SourceDirectoryModel removeAllSrcDirs() {
        this.myDslElement.removeProperty(SRC_DIRS);
        return this;
    }

    @NotNull
    public SourceDirectoryModel replaceSrcDir(@NotNull String oldSrcDir, @NotNull String newSrcDir) {
        this.myDslElement.replaceInExpressionList(SRC_DIRS, oldSrcDir, newSrcDir);
        return this;
    }
}

