/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.model.dependencies.ExcludedDependencyModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNullableValue;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependencyConfigurationDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DependencyConfigurationModel {
    @NonNls
    private static final String EXCLUDE = "exclude";
    @NonNls
    private static final String FORCE = "force";
    @NonNls
    private static final String TRANSITIVE = "transitive";
    @NotNull
    DependencyConfigurationDslElement myConfigurationElement;

    public DependencyConfigurationModel(@NotNull DependencyConfigurationDslElement configurationElement) {
        this.myConfigurationElement = configurationElement;
    }

    @NotNull
    public List<ExcludedDependencyModel> excludes() {
        GradleDslElementList elementList = this.myConfigurationElement.getPropertyElement(EXCLUDE, GradleDslElementList.class);
        if (elementList == null) {
            return ImmutableList.of();
        }
        ArrayList<ExcludedDependencyModel> excludedDependencies = new ArrayList<ExcludedDependencyModel>();
        for (GradleDslExpressionMap excludeElement : elementList.getElements(GradleDslExpressionMap.class)) {
            excludedDependencies.add(new ExcludedDependencyModel(excludeElement));
        }
        return excludedDependencies;
    }

    @NotNull
    public GradleNullableValue<Boolean> force() {
        return this.myConfigurationElement.getLiteralProperty(FORCE, Boolean.class);
    }

    @NotNull
    public GradleNullableValue<Boolean> transitive() {
        return this.myConfigurationElement.getLiteralProperty(TRANSITIVE, Boolean.class);
    }
}

