/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FileDependencyModel
extends DependencyModel {
    @NonNls
    private static final String FILES = "files";
    @NotNull
    private String myConfigurationName;
    @NotNull
    private final GradleDslExpression myFileDslExpression;

    static Collection<? extends FileDependencyModel> create(@NotNull String configurationName, @NotNull GradleDslMethodCall methodCall) {
        ArrayList<FileDependencyModel> result = new ArrayList<FileDependencyModel>();
        if (FILES.equals(methodCall.getName())) {
            List<GradleDslElement> arguments = methodCall.getArguments();
            for (GradleDslElement argument : arguments) {
                if (!(argument instanceof GradleDslExpression)) continue;
                result.add(new FileDependencyModel(configurationName, (GradleDslExpression)argument));
            }
        }
        return result;
    }

    static void createAndAddToList(@NotNull GradleDslElementList list, @NotNull String configurationName, @NotNull String file) {
        String methodName = FILES;
        GradleDslMethodCall methodCall = new GradleDslMethodCall((GradleDslElement)list, methodName, configurationName);
        GradleDslLiteral fileDslLiteral = new GradleDslLiteral(methodCall, methodName);
        fileDslLiteral.setValue(file);
        methodCall.addNewArgument(fileDslLiteral);
        list.addNewElement(methodCall);
    }

    private FileDependencyModel(@NotNull String configurationName, @NotNull GradleDslExpression fileDslExpression) {
        this.myConfigurationName = configurationName;
        this.myFileDslExpression = fileDslExpression;
    }

    @Override
    @NotNull
    protected GradleDslElement getDslElement() {
        return this.myFileDslExpression;
    }

    @Override
    @NotNull
    public String configurationName() {
        return this.myConfigurationName;
    }

    @NotNull
    public GradleNotNullValue<String> file() {
        String file = this.myFileDslExpression.getValue(String.class);
        assert (file != null);
        return new GradleNotNullValue<String>(this.myFileDslExpression, file);
    }

    public void setFile(@NotNull String file) {
        this.myFileDslExpression.setValue(file);
    }
}

