/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTreeDependencyModel
extends DependencyModel {
    private static final Logger LOG = Logger.getInstance(FileTreeDependencyModel.class);
    @NonNls
    private static final String FILE_TREE = "fileTree";
    @NonNls
    private static final String DIR = "dir";
    @NonNls
    private static final String INCLUDE = "include";
    @NonNls
    private static final String EXCLUDE = "exclude";
    @NotNull
    private String myConfigurationName;
    @NotNull
    private final GradleDslMethodCall myDslElement;
    @NotNull
    private final GradleDslExpression myDir;
    @Nullable
    private final GradleDslElement myIncludeElement;
    @Nullable
    private final GradleDslElement myExcludeElement;

    static Collection<? extends FileTreeDependencyModel> create(@NotNull String configurationName, @NotNull GradleDslMethodCall methodCall) {
        ArrayList result = Lists.newArrayList();
        if (FILE_TREE.equals(methodCall.getName())) {
            List<GradleDslElement> arguments = methodCall.getArguments();
            for (GradleDslElement argument : arguments) {
                if (argument instanceof GradleDslExpression) {
                    result.add(new FileTreeDependencyModel(configurationName, methodCall, (GradleDslExpression)argument, null, null));
                    continue;
                }
                if (!(argument instanceof GradleDslExpressionMap)) continue;
                GradleDslExpressionMap dslMap = (GradleDslExpressionMap)argument;
                GradleDslExpression dirElement = dslMap.getPropertyElement(DIR, GradleDslExpression.class);
                if (dirElement == null) {
                    assert (methodCall.getPsiElement() != null);
                    String msg = String.format("'%1$s' is not a valid file tree dependency", methodCall.getPsiElement().getText());
                    LOG.warn(msg);
                    continue;
                }
                GradleDslElement includeElement = dslMap.getPropertyElement(INCLUDE);
                GradleDslElement excludeElement = dslMap.getPropertyElement(EXCLUDE);
                result.add(new FileTreeDependencyModel(configurationName, methodCall, dirElement, includeElement, excludeElement));
            }
        }
        return result;
    }

    static void createAndAddToList(@NotNull GradleDslElementList list, @NotNull String configurationName, @NotNull String dir, @Nullable List<String> includes, @Nullable List<String> excludes) {
        String methodName = FILE_TREE;
        GradleDslMethodCall methodCall = new GradleDslMethodCall((GradleDslElement)list, methodName, configurationName);
        if ((includes == null || includes.isEmpty()) && (excludes == null || excludes.isEmpty())) {
            GradleDslLiteral directory = new GradleDslLiteral(methodCall, methodName);
            directory.setValue(dir);
            methodCall.addNewArgument(directory);
        } else {
            GradleDslExpressionMap mapArguments = new GradleDslExpressionMap(methodCall, methodName);
            mapArguments.setNewLiteral(DIR, dir);
            if (includes != null && !includes.isEmpty()) {
                if (includes.size() == 1) {
                    mapArguments.setNewLiteral(INCLUDE, includes.get(0));
                } else {
                    for (String include : includes) {
                        mapArguments.addToNewLiteralList(INCLUDE, include);
                    }
                }
            }
            if (excludes != null && !excludes.isEmpty()) {
                if (excludes.size() == 1) {
                    mapArguments.setNewLiteral(EXCLUDE, excludes.get(0));
                } else {
                    for (String exclude : excludes) {
                        mapArguments.addToNewLiteralList(EXCLUDE, exclude);
                    }
                }
            }
            methodCall.addNewArgument(mapArguments);
        }
        list.addNewElement(methodCall);
    }

    private FileTreeDependencyModel(@NotNull String configurationName, @NotNull GradleDslMethodCall dslElement, @NotNull GradleDslExpression dir, @Nullable GradleDslElement includeElement, @Nullable GradleDslElement excludeElement) {
        this.myConfigurationName = configurationName;
        this.myDslElement = dslElement;
        this.myDir = dir;
        this.myIncludeElement = includeElement;
        this.myExcludeElement = excludeElement;
    }

    @Override
    @NotNull
    protected GradleDslElement getDslElement() {
        return this.myDslElement;
    }

    @Override
    @NotNull
    public String configurationName() {
        return this.myConfigurationName;
    }

    @NotNull
    public GradleNotNullValue<String> dir() {
        String dir = this.myDir.getValue(String.class);
        assert (dir != null);
        return new GradleNotNullValue<String>(this.myDir, dir);
    }

    public void setDir(@NotNull String dir) {
        this.myDir.setValue(dir);
    }

    @NotNull
    public List<GradleNotNullValue<String>> includes() {
        return FileTreeDependencyModel.getStringValues(this.myIncludeElement);
    }

    @NotNull
    public List<GradleNotNullValue<String>> excludes() {
        return FileTreeDependencyModel.getStringValues(this.myExcludeElement);
    }

    @NotNull
    private static List<GradleNotNullValue<String>> getStringValues(@Nullable GradleDslElement expressionOrList) {
        String value;
        if (expressionOrList instanceof GradleDslExpressionList) {
            return ((GradleDslExpressionList)expressionOrList).getValues(String.class);
        }
        if (expressionOrList instanceof GradleDslExpression && (value = ((GradleDslExpression)expressionOrList).getValue(String.class)) != null) {
            return Collections.singletonList(new GradleNotNullValue<String>(expressionOrList, value));
        }
        return Collections.emptyList();
    }
}

