/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.repositories;

import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.repositories.FlatDirRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.GoogleDefaultRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.JCenterDefaultRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.JCenterRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.MavenCentralRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.MavenRepositoryModel;
import com.android.tools.idea.gradle.dsl.model.repositories.RepositoryModel;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.FlatDirRepositoryDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.MavenRepositoryDslElement;
import com.android.tools.idea.gradle.dsl.parser.repositories.RepositoriesDslElement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RepositoriesModel
extends GradleDslBlockModel {
    public RepositoriesModel(@NotNull RepositoriesDslElement dslElement) {
        super(dslElement);
    }

    @NotNull
    public List<RepositoryModel> repositories() {
        GradleDslElementList repositoriesElementList = this.myDslElement.getPropertyElement("repositories", GradleDslElementList.class);
        if (repositoriesElementList == null) {
            return ImmutableList.of();
        }
        ArrayList result = Lists.newArrayList();
        for (GradleDslElement element : repositoriesElementList.getElements()) {
            if (element instanceof GradleDslMethodCall) {
                if ("mavenCentral".equals(element.getName())) {
                    result.add(new MavenCentralRepositoryModel(null));
                    continue;
                }
                if ("jcenter".equals(element.getName())) {
                    result.add(new JCenterDefaultRepositoryModel());
                    continue;
                }
                if (!"google".equals(element.getName())) continue;
                result.add(new GoogleDefaultRepositoryModel());
                continue;
            }
            if (element instanceof MavenRepositoryDslElement) {
                if ("maven".equals(element.getName())) {
                    result.add(new MavenRepositoryModel((MavenRepositoryDslElement)element));
                    continue;
                }
                if (!"jcenter".equals(element.getName())) continue;
                result.add(new JCenterRepositoryModel((MavenRepositoryDslElement)element));
                continue;
            }
            if (element instanceof FlatDirRepositoryDslElement) {
                result.add(new FlatDirRepositoryModel((FlatDirRepositoryDslElement)element));
                continue;
            }
            if (!(element instanceof GradleDslExpressionMap)) continue;
            if ("mavenCentral".equals(element.getName())) {
                result.add(new MavenCentralRepositoryModel((GradleDslExpressionMap)element));
                continue;
            }
            if (!"flatDir".equals(element.getName())) continue;
            result.add(new FlatDirRepositoryModel((GradlePropertiesDslElement)element));
        }
        return result;
    }

    public void addRepositoryByMethodName(@NotNull String methodName) {
        GradleDslElementList repositoriesElementList = this.getRepositoryElementList();
        if (this.containsMethodCall(methodName)) {
            return;
        }
        repositoriesElementList.addNewElement(new GradleDslMethodCall((GradleDslElement)repositoriesElementList, methodName, null));
    }

    public boolean containsMethodCall(@NotNull String methodName) {
        GradleDslElementList list = this.getRepositoryElementList();
        List<GradleDslMethodCall> elements = list.getElements(GradleDslMethodCall.class);
        for (GradleDslMethodCall element : elements) {
            if (!methodName.equals(element.getName())) continue;
            return true;
        }
        return false;
    }

    public void addMavenRepositoryByUrl(@NotNull String url, @NotNull String name) {
        GradleDslElementList repositoriesElementList = this.getRepositoryElementList();
        if (this.containsMavenRepositoryByUrl(url)) {
            return;
        }
        MavenRepositoryDslElement newElement = new MavenRepositoryDslElement(repositoriesElementList, "maven");
        newElement.setNewLiteral("url", url);
        newElement.setNewLiteral("name", name);
        repositoriesElementList.addNewElement(newElement);
    }

    public boolean containsMavenRepositoryByUrl(@NotNull String repositoryUrl) {
        GradleDslElementList list = this.getRepositoryElementList();
        List<MavenRepositoryDslElement> elements = list.getElements(MavenRepositoryDslElement.class);
        for (MavenRepositoryDslElement element : elements) {
            String urlElement = (String)element.getLiteralProperty("url", String.class).value();
            if (!repositoryUrl.equals(urlElement)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private GradleDslElementList getRepositoryElementList() {
        GradleDslElementList repositoriesElementList = this.myDslElement.getPropertyElement("repositories", GradleDslElementList.class);
        if (repositoriesElementList == null) {
            repositoriesElementList = new GradleDslElementList(this.myDslElement, "repositories");
            this.myDslElement.addParsedElement("repositories", repositoriesElementList);
        }
        return repositoriesElementList;
    }
}

