/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.util;

import com.android.tools.idea.gradle.dsl.model.repositories.RepositoriesModel;
import com.android.tools.idea.gradle.util.GradleVersions;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;

public class GoogleMavenRepository {
    public static boolean hasGoogleMavenRepository(@NotNull RepositoriesModel repositoriesModel) {
        GroovyPsiElement psiElement = repositoriesModel.getPsiElement();
        if (psiElement == null) {
            return false;
        }
        Project project = repositoriesModel.getPsiElement().getProject();
        if (GradleVersions.getInstance().isGradle4OrNewer(project) && repositoriesModel.containsMethodCall("google")) {
            return true;
        }
        return repositoriesModel.containsMavenRepositoryByUrl("https://maven.google.com/");
    }

    public static void addGoogleRepository(@NotNull RepositoriesModel repositoriesModel, @NotNull Project project) {
        if (GradleVersions.getInstance().isGradle4OrNewer(project)) {
            repositoriesModel.addRepositoryByMethodName("google");
        } else {
            repositoriesModel.addMavenRepositoryByUrl("https://maven.google.com/", "Google");
        }
    }
}

