/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.values;

import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.parser.GradleResolvedVariable;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;

public abstract class GradleValue<T> {
    @Nullable
    private final GradleDslElement myDslElement;
    @Nullable
    private final T myValue;

    protected GradleValue(@Nullable GradleDslElement dslElement, @Nullable T value) {
        this.myDslElement = dslElement;
        this.myValue = value;
    }

    @Nullable
    public T value() {
        return this.myValue;
    }

    @Nullable
    public GroovyPsiElement getPsiElement() {
        if (this.myDslElement == null) {
            return null;
        }
        return this.myDslElement instanceof GradleDslExpression ? ((GradleDslExpression)this.myDslElement).getExpression() : this.myDslElement.getPsiElement();
    }

    @Nullable
    public VirtualFile getFile() {
        return this.myDslElement != null ? this.myDslElement.getDslFile().getFile() : null;
    }

    @Nullable
    public String getPropertyName() {
        return this.myDslElement != null ? this.myDslElement.getQualifiedName() : null;
    }

    @Nullable
    public String getDslText() {
        GroovyPsiElement psiElement = this.getPsiElement();
        return psiElement != null ? psiElement.getText() : null;
    }

    @NotNull
    public Map<String, GradleNotNullValue<Object>> getResolvedVariables() {
        if (this.myDslElement == null) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (GradleResolvedVariable variable : this.myDslElement.getResolvedVariables()) {
            String variableName = variable.getVariableName();
            Object resolvedValue = variable.getValue();
            GradleDslElement element = variable.getElement();
            builder.put((Object)variableName, new GradleNotNullValue<Object>(element, resolvedValue));
        }
        return builder.build();
    }

    @NotNull
    public static <E> List<E> getValues(@Nullable List<? extends GradleValue<E>> gradleValues) {
        if (gradleValues == null) {
            return ImmutableList.of();
        }
        ArrayList<E> values = new ArrayList<E>(gradleValues.size());
        for (GradleValue<E> gradleValue : gradleValues) {
            E value = gradleValue.value();
            if (value == null) continue;
            values.add(value);
        }
        return values;
    }

    @NotNull
    public static <V> Map<String, V> getValues(@Nullable Map<String, ? extends GradleValue<V>> gradleValues) {
        if (gradleValues == null) {
            return ImmutableMap.of();
        }
        LinkedHashMap values = new LinkedHashMap();
        for (Map.Entry<String, GradleValue<V>> gradleValueEntry : gradleValues.entrySet()) {
            V value = gradleValueEntry.getValue().value();
            if (value == null) continue;
            values.put(gradleValueEntry.getKey(), value);
        }
        return values;
    }
}

