/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.dependencies;

import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslBlockElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependenciesDslElement
extends GradleDslBlockElement {
    @NonNls
    public static final String DEPENDENCIES_BLOCK_NAME = "dependencies";

    public DependenciesDslElement(@Nullable GradleDslElement parent) {
        super(parent, DEPENDENCIES_BLOCK_NAME);
    }

    @Override
    public void addParsedElement(@NotNull String configurationName, @NotNull GradleDslElement dependency) {
        if (dependency instanceof GradleDslExpression || dependency instanceof GradleDslExpressionMap) {
            GradleDslElementList elementList = this.getOrCreateParsedElement(configurationName);
            elementList.addParsedElement(dependency);
        } else if (dependency instanceof GradleDslExpressionList) {
            GradleDslElementList elementList = this.getOrCreateParsedElement(configurationName);
            for (GradleDslExpression expression : ((GradleDslExpressionList)dependency).getExpressions()) {
                GradleDslClosure dependencyClosureElement = dependency.getClosureElement();
                if (expression.getClosureElement() == null && dependencyClosureElement != null) {
                    expression.setParsedClosureElement(dependencyClosureElement);
                }
                elementList.addParsedElement(expression);
            }
        }
    }

    @NotNull
    private GradleDslElementList getOrCreateParsedElement(@NotNull String configurationName) {
        GradleDslElementList elementList = this.getPropertyElement(configurationName, GradleDslElementList.class);
        if (elementList == null) {
            elementList = new GradleDslElementList(this, configurationName);
            super.addParsedElement(configurationName, elementList);
        }
        return elementList;
    }
}

