/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.model.values.GradleNotNullValue;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public final class GradleDslExpressionList
extends GradleDslElement {
    @NotNull
    private final List<GradleDslExpression> myExpressions = Lists.newArrayList();
    @NotNull
    private final List<GradleDslExpression> myToBeAddedExpressions = Lists.newArrayList();
    @NotNull
    private final List<GradleDslExpression> myToBeRemovedExpressions = Lists.newArrayList();
    private final boolean myAppendToArgumentListWithOneElement;

    public GradleDslExpressionList(@Nullable GradleDslElement parent, @NotNull String name) {
        super(parent, null, name);
        this.myAppendToArgumentListWithOneElement = false;
    }

    public GradleDslExpressionList(@NotNull GradleDslElement parent, @NotNull GroovyPsiElement psiElement, @NotNull String name) {
        this(parent, psiElement, name, false);
    }

    public GradleDslExpressionList(@NotNull GradleDslElement parent, @NotNull GroovyPsiElement psiElement, @NotNull String name, boolean appendToArgumentListWithOneElement) {
        super(parent, psiElement, name);
        this.myAppendToArgumentListWithOneElement = appendToArgumentListWithOneElement;
    }

    public void addParsedExpression(@NotNull GradleDslExpression expression) {
        expression.myParent = this;
        this.myExpressions.add(expression);
    }

    public void addNewExpression(@NotNull GradleDslExpression expression) {
        expression.myParent = this;
        this.myToBeAddedExpressions.add(expression);
        this.setModified(true);
    }

    void addNewLiteral(@NotNull Object value) {
        GradleDslLiteral literal = new GradleDslLiteral(this, this.myName);
        literal.setValue(value);
        this.myToBeAddedExpressions.add(literal);
    }

    void removeExpression(@NotNull Object value) {
        for (GradleDslExpression expression : this.getExpressions()) {
            if (!value.equals(expression.getValue())) continue;
            this.myToBeRemovedExpressions.add(expression);
            this.setModified(true);
            return;
        }
    }

    void replaceExpression(@NotNull Object oldValue, @NotNull Object newValue) {
        for (GradleDslExpression expression : this.getExpressions()) {
            if (!oldValue.equals(expression.getValue())) continue;
            expression.setValue(newValue);
            return;
        }
    }

    @NotNull
    public List<GradleDslExpression> getExpressions() {
        if (this.myToBeAddedExpressions.isEmpty() && this.myToBeRemovedExpressions.isEmpty()) {
            return ImmutableList.copyOf(this.myExpressions);
        }
        ArrayList result = Lists.newArrayList();
        result.addAll(this.myExpressions);
        result.addAll(this.myToBeAddedExpressions);
        for (GradleDslExpression expression : this.myToBeRemovedExpressions) {
            result.remove(expression);
        }
        return result;
    }

    @NotNull
    public <E> List<GradleNotNullValue<E>> getValues(Class<E> clazz) {
        ArrayList result = Lists.newArrayList();
        for (GradleDslExpression expression : this.getExpressions()) {
            GradleDslExpressionList referenceList;
            if (expression instanceof GradleDslReference && (referenceList = expression.getValue(GradleDslExpressionList.class)) != null) {
                result.addAll(referenceList.getValues(clazz));
                continue;
            }
            E value = expression.getValue(clazz);
            if (value == null) continue;
            result.add(new GradleNotNullValue<E>(expression, value));
        }
        return result;
    }

    @Override
    @Nullable
    public GroovyPsiElement create() {
        GroovyPsiElement psiElement = this.getPsiElement();
        if (psiElement == null) {
            if (this.myParent instanceof GradleDslExpressionMap) {
                return this.createNamedArgumentList();
            }
            psiElement = super.create();
        }
        if (psiElement == null) {
            return null;
        }
        if (psiElement instanceof GrListOrMap) {
            return psiElement;
        }
        if (psiElement instanceof GrArgumentList) {
            if (!this.myToBeAddedExpressions.isEmpty() && ((GrArgumentList)psiElement).getAllArguments().length == 1 && !this.myAppendToArgumentListWithOneElement) {
                this.setPsiElement(null);
                psiElement = super.create();
            } else {
                return psiElement;
            }
        }
        if (psiElement instanceof GrApplicationStatement) {
            GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject());
            GrArgumentList argumentList = factory.createArgumentListFromText("xyz");
            argumentList.getFirstChild().delete();
            PsiElement added = psiElement.addAfter((PsiElement)argumentList, psiElement.getLastChild());
            if (added instanceof GrArgumentList) {
                GrArgumentList addedArgumentList = (GrArgumentList)added;
                this.setPsiElement((GroovyPsiElement)addedArgumentList);
                return addedArgumentList;
            }
        }
        return null;
    }

    @Nullable
    private GroovyPsiElement createNamedArgumentList() {
        assert (this.myParent instanceof GradleDslExpressionMap);
        GroovyPsiElement parentPsiElement = this.myParent.create();
        if (parentPsiElement == null) {
            return null;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)parentPsiElement.getProject());
        GrExpression expressionFromText = factory.createExpressionFromText((CharSequence)"[]");
        if (expressionFromText instanceof GrListOrMap) {
            GrListOrMap list = (GrListOrMap)expressionFromText;
            for (GradleDslExpression expression : this.myToBeAddedExpressions) {
                expression.setPsiElement((GroovyPsiElement)list);
                expression.applyChanges();
                this.myExpressions.add(expression);
            }
            this.myToBeAddedExpressions.clear();
        }
        GrNamedArgument namedArgument = factory.createNamedArgument(this.myName, expressionFromText);
        Object added = parentPsiElement instanceof GrArgumentList ? ((GrArgumentList)parentPsiElement).addNamedArgument(namedArgument) : parentPsiElement.addAfter((PsiElement)namedArgument, parentPsiElement.getLastChild());
        if (added instanceof GrNamedArgument) {
            GrNamedArgument addedNameArgument = added;
            this.setPsiElement((GroovyPsiElement)addedNameArgument.getExpression());
            return this.getPsiElement();
        }
        return null;
    }

    @Override
    protected void apply() {
        GroovyPsiElement psiElement = this.create();
        if (psiElement != null) {
            for (GradleDslExpression expression : this.myToBeAddedExpressions) {
                expression.setPsiElement(psiElement);
                expression.applyChanges();
                this.myExpressions.add(expression);
            }
        }
        this.myToBeAddedExpressions.clear();
        for (GradleDslExpression expression : this.myToBeRemovedExpressions) {
            if (!this.myExpressions.remove(expression)) continue;
            expression.delete();
        }
        this.myToBeRemovedExpressions.clear();
        for (GradleDslExpression expression : this.myExpressions) {
            if (!expression.isModified()) continue;
            expression.applyChanges();
        }
    }

    @Override
    protected void reset() {
        this.myToBeAddedExpressions.clear();
        this.myToBeRemovedExpressions.clear();
        for (GradleDslExpression expression : this.myExpressions) {
            if (!expression.isModified()) continue;
            expression.resetState();
        }
    }

    @Override
    @NotNull
    protected Collection<GradleDslElement> getChildren() {
        List<GradleDslExpression> expressions = this.getExpressions();
        ArrayList<GradleDslElement> children = new ArrayList<GradleDslElement>(expressions.size());
        for (GradleDslExpression expression : expressions) {
            children.add(expression);
        }
        return children;
    }
}

