/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public final class GradleDslMethodCall
extends GradleDslExpression {
    @NotNull
    private final List<GradleDslElement> myArguments = Lists.newArrayList();
    @NotNull
    private final List<GradleDslElement> myToBeRemovedArguments = Lists.newArrayList();
    @Nullable
    private String myStatementName;
    private GradleDslElement myToBeAddedArgument;

    public GradleDslMethodCall(@NotNull GradleDslElement parent, @NotNull String methodName, @Nullable String statementName) {
        super(parent, null, methodName, null);
        this.myStatementName = statementName;
    }

    public GradleDslMethodCall(@NotNull GradleDslElement parent, @NotNull GrMethodCallExpression methodCall, @NotNull String name) {
        super(parent, (GroovyPsiElement)methodCall, name, (GrExpression)methodCall);
    }

    public void addParsedExpression(@NotNull GradleDslExpression expression) {
        expression.myParent = this;
        this.myArguments.add(expression);
    }

    public void addParsedExpressionMap(@NotNull GradleDslExpressionMap expressionMap) {
        expressionMap.myParent = this;
        this.myArguments.add(expressionMap);
    }

    public void addNewArgument(@NotNull GradleDslExpression argument) {
        this.addNewArgumentInternal(argument);
    }

    public void addNewArgument(@NotNull GradleDslExpressionMap mapArgument) {
        this.addNewArgumentInternal(mapArgument);
    }

    private void addNewArgumentInternal(@NotNull GradleDslElement argument) {
        assert (argument instanceof GradleDslExpression || argument instanceof GradleDslExpressionMap);
        if (this.getArguments().isEmpty()) {
            this.myToBeAddedArgument = argument;
            this.setModified(true);
        }
    }

    @NotNull
    public List<GradleDslElement> getArguments() {
        if (this.myToBeRemovedArguments.isEmpty() && this.myToBeAddedArgument == null) {
            return ImmutableList.copyOf(this.myArguments);
        }
        ArrayList result = Lists.newArrayList();
        for (GradleDslElement argument : this.myArguments) {
            if (argument instanceof GradleDslReference) {
                GradleDslExpressionList listValue = ((GradleDslReference)argument).getValue(GradleDslExpressionList.class);
                if (listValue != null) {
                    result.addAll(listValue.getExpressions());
                    continue;
                }
                GradleDslExpressionMap mapValue = ((GradleDslReference)argument).getValue(GradleDslExpressionMap.class);
                if (mapValue != null) {
                    result.add(mapValue);
                    continue;
                }
            }
            result.add(argument);
        }
        if (this.myToBeAddedArgument != null) {
            result.add(this.myToBeAddedArgument);
        }
        for (GradleDslElement argument : this.myToBeRemovedArguments) {
            result.remove(argument);
        }
        return result;
    }

    @Override
    @NotNull
    protected Collection<GradleDslElement> getChildren() {
        return this.getArguments();
    }

    @Override
    @Nullable
    public Object getValue() {
        GroovyPsiElement psiElement = this.getPsiElement();
        return psiElement != null ? psiElement.getText() : null;
    }

    @Override
    @Nullable
    public <T> T getValue(@NotNull Class<T> clazz) {
        if (clazz.isAssignableFrom(File.class)) {
            return clazz.cast(this.getFileValue());
        }
        Object value = this.getValue();
        if (clazz.isInstance(value)) {
            return clazz.cast(value);
        }
        return null;
    }

    @Nullable
    private File getFileValue() {
        if (!this.myName.equals("file")) {
            return null;
        }
        List<GradleDslElement> arguments = this.getArguments();
        if (arguments.isEmpty()) {
            return null;
        }
        GradleDslElement pathArgument = arguments.get(0);
        if (!(pathArgument instanceof GradleDslExpression)) {
            return null;
        }
        String path = ((GradleDslExpression)pathArgument).getValue(String.class);
        if (path == null) {
            return null;
        }
        return new File(path);
    }

    @Override
    public void setValue(@NotNull Object value) {
        if (value instanceof File) {
            this.setFileValue((File)value);
        }
    }

    private void setFileValue(@NotNull File file) {
        if (!this.myName.equals("file")) {
            return;
        }
        List<GradleDslElement> arguments = this.getArguments();
        if (arguments.isEmpty()) {
            GradleDslLiteral argument = new GradleDslLiteral(this, this.myName);
            argument.setValue(file.getPath());
            this.myToBeAddedArgument = argument;
            return;
        }
        GradleDslElement pathArgument = arguments.get(0);
        if (!(pathArgument instanceof GradleDslExpression)) {
            return;
        }
        ((GradleDslExpression)pathArgument).setValue(file.getPath());
    }

    public void remove(GradleDslElement argument) {
        if (this.myArguments.contains(argument)) {
            this.myToBeRemovedArguments.add(argument);
            this.setModified(true);
        }
    }

    @Override
    protected void apply() {
        for (GradleDslElement argument : this.myToBeRemovedArguments) {
            if (!this.myArguments.remove(argument)) continue;
            argument.delete();
        }
        GroovyPsiElement psiElement = this.getPsiElement();
        if (psiElement instanceof GrMethodCallExpression) {
            GrMethodCallExpression methodCall = (GrMethodCallExpression)psiElement;
            if (this.myToBeAddedArgument != null) {
                this.myToBeAddedArgument.setPsiElement((GroovyPsiElement)methodCall.getArgumentList());
                this.myToBeAddedArgument.applyChanges();
                this.myArguments.add(this.myToBeAddedArgument);
            }
        }
        for (GradleDslElement argument : this.myArguments) {
            if (!argument.isModified()) continue;
            argument.applyChanges();
        }
    }

    @Override
    protected void reset() {
        this.myToBeAddedArgument = null;
        this.myToBeRemovedArguments.clear();
        for (GradleDslElement argument : this.myArguments) {
            if (!argument.isModified()) continue;
            argument.resetState();
        }
    }

    @Override
    @Nullable
    public GroovyPsiElement create() {
        GrExpression[] expressionArguments;
        String statementText;
        GroovyPsiElement psiElement = this.getPsiElement();
        if (psiElement != null) {
            return psiElement;
        }
        if (this.myParent == null) {
            return null;
        }
        GroovyPsiElement parentPsiElement = this.myParent.create();
        if (parentPsiElement == null) {
            return null;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)parentPsiElement.getProject());
        GrStatement statement = factory.createStatementFromText((CharSequence)(statementText = (this.myStatementName != null ? this.myStatementName + " " : "") + this.myName + "()"));
        PsiElement addedElement = parentPsiElement.addBefore((PsiElement)statement, parentPsiElement.getLastChild());
        if (addedElement instanceof GrApplicationStatement && (expressionArguments = ((GrApplicationStatement)addedElement).getArgumentList().getExpressionArguments()).length == 1 && expressionArguments[0] instanceof GrMethodCallExpression) {
            this.setPsiElement((GroovyPsiElement)expressionArguments[0]);
            return this.getPsiElement();
        }
        if (addedElement instanceof GrMethodCallExpression) {
            this.setPsiElement((GroovyPsiElement)((GrMethodCallExpression)addedElement));
            return this.getPsiElement();
        }
        return null;
    }
}

