/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.eclipse;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.eclipse.EclipseProject;
import com.android.tools.idea.gradle.eclipse.ImportModule;
import com.android.tools.idea.gradle.eclipse.ImportSummary;
import com.android.tools.idea.gradle.npw.project.GradleBuildSettings;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.util.PropertiesFiles;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.utils.PositionXmlParser;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.primitives.Bytes;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GradleImport {
    public static final String NL = System.lineSeparator();
    public static final int CURRENT_COMPILE_VERSION = 26;
    public static final String ANDROID_GRADLE_PLUGIN = "com.android.tools.build:gradle:" + AndroidPluginGeneration.ORIGINAL.getLatestKnownVersion();
    public static final String MAVEN_URL_PROPERTY = "android.mavenRepoUrl";
    public static final String ECLIPSE_DOT_CLASSPATH = ".classpath";
    public static final String ECLIPSE_DOT_PROJECT = ".project";
    public static final String IMPORT_SUMMARY_TXT = "import-summary.txt";
    public static final String MAVEN_REPOSITORY;
    private static final String WORKSPACE_PROPERTY = "android.eclipseWorkspace";
    private final List<String> myWarnings = Lists.newArrayList();
    private final List<String> myErrors = Lists.newArrayList();
    private List<? extends ImportModule> myRootModules;
    private Set<ImportModule> myModules;
    private ImportSummary mySummary;
    private File myWorkspaceLocation;
    private File myGradleWrapperLocation;
    private File mySdkLocation;
    private File myNdkLocation;
    private Set<String> myHandledJars = Sets.newHashSet();
    private Map<String, File> myWorkspaceProjects;
    private boolean myGradleNameStyle = true;
    private boolean myReplaceJars = true;
    private boolean myReplaceLibs = true;
    private boolean myImportIntoExisting;
    private Map<String, File> myPathMap = Maps.newTreeMap();
    private Map<File, String> mySelectedModules;
    private boolean myDefaultEncodingInitialized;
    private Charset myDefaultEncoding;
    private Map<File, EclipseProject> myProjectMap = Maps.newHashMap();

    public GradleImport() {
        String workspace = System.getProperty(WORKSPACE_PROPERTY);
        if (workspace != null) {
            this.myWorkspaceLocation = new File(workspace);
        }
    }

    public static boolean isEclipseProjectDir(File file) {
        return file != null && file.isDirectory() && new File(file, ECLIPSE_DOT_CLASSPATH).exists() && new File(file, ECLIPSE_DOT_PROJECT).exists();
    }

    public static boolean isAdtProjectDir(File file) {
        return new File(file, "AndroidManifest.xml").exists() && (GradleImport.isEclipseProjectDir(file) || new File(file, "res").exists() && (new File(file, "src").exists() || new File(file, "jni").exists()));
    }

    private static File getDirFromLocalProperties(File projectDir, String property) {
        File localProperties = new File(projectDir, "local.properties");
        if (localProperties.exists()) {
            try {
                String sdk;
                Properties properties = PropertiesFiles.getProperties(localProperties);
                if (properties != null && (sdk = properties.getProperty(property)) != null) {
                    File dir = new File(sdk);
                    if (dir.exists()) {
                        return dir;
                    }
                    dir = new File(sdk.replace('/', File.separatorChar));
                    if (dir.exists()) {
                        return dir;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isEclipseWorkspaceDir(File file) {
        return file.isDirectory() && new File(file, ".metadata" + File.separator + "version.ini").exists();
    }

    private static String generateProguardFileList(List<File> localRules, List<File> sdkRules) {
        assert (!localRules.isEmpty() || !sdkRules.isEmpty());
        StringBuilder sb = new StringBuilder();
        for (File rule : sdkRules) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("getDefaultProguardFile('");
            sb.append(GradleImport.escapeGroovyStringLiteral(rule.getName()));
            sb.append("')");
        }
        for (File rule : localRules) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("'");
            sb.append(GradleImport.escapeGroovyStringLiteral(rule.getName()));
            sb.append("'");
        }
        return sb.toString();
    }

    private static void appendDependencies(StringBuilder sb, ImportModule module) throws IOException {
        if (!(module.getDirectDependencies().isEmpty() && module.getDependencies().isEmpty() && module.getJarDependencies().isEmpty() && module.getTestDependencies().isEmpty() && module.getTestJarDependencies().isEmpty())) {
            String path;
            sb.append(NL);
            sb.append("dependencies {").append(NL);
            for (ImportModule lib : module.getDirectDependencies()) {
                if (lib.isReplacedWithDependency()) continue;
                sb.append("    compile project('").append(lib.getModuleReference()).append("')").append(NL);
            }
            for (GradleCoordinate dependency : module.getDependencies()) {
                sb.append("    compile '").append(dependency.toString()).append("'").append(NL);
            }
            for (File jar : module.getJarDependencies()) {
                path = jar.getPath().replace(File.separatorChar, '/');
                sb.append("    compile files('").append(GradleImport.escapeGroovyStringLiteral(path)).append("')").append(NL);
            }
            for (GradleCoordinate dependency : module.getTestDependencies()) {
                sb.append("    androidTestCompile '").append(dependency.toString()).append("'").append(NL);
            }
            for (File jar : module.getTestJarDependencies()) {
                path = jar.getPath().replace(File.separatorChar, '/');
                sb.append("    androidTestCompile files('").append(GradleImport.escapeGroovyStringLiteral(path)).append("')").append(NL);
            }
            sb.append("}").append(NL);
        }
    }

    @NotNull
    public static String escapeGroovyStringLiteral(@NotNull String s) {
        StringBuilder sb = new StringBuilder(s.length() + 5);
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '\'') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static String formatMessage(String project, File file, String message) {
        StringBuilder sb = new StringBuilder();
        if (project != null) {
            sb.append("Project ").append(project).append(":");
        }
        if (file != null) {
            sb.append(file.getPath());
            sb.append(":\n");
        }
        sb.append(message);
        return sb.toString();
    }

    static boolean isIgnoredFile(File file) {
        String name = file.getName();
        return name.equals(".svn") || name.equals(".git") || name.equals(".hg") || name.equals(".DS_Store") || name.endsWith("~") && name.length() > 1;
    }

    private static void copyTextFileWithEncoding(File source, File dest, Charset sourceEncoding) throws IOException {
        if (!Charsets.UTF_8.equals(sourceEncoding)) {
            String text = Files.toString((File)source, (Charset)sourceEncoding);
            Files.write((CharSequence)text, (File)dest, (Charset)Charsets.UTF_8);
        } else {
            Files.copy((File)source, (File)dest);
        }
    }

    public static boolean isTextFile(File file) {
        String name = file.getName();
        return name.endsWith(".java") || name.endsWith(".xml") || name.endsWith(".aidl") || name.endsWith(".fs") || name.endsWith(".rs") || name.endsWith(".rsh") || name.endsWith(".rsh") || name.endsWith(".txt") || name.endsWith(".gradle") || name.endsWith(".properties") || name.endsWith(".cfg") || name.endsWith(".pro") || name.endsWith(".h") || name.endsWith(".c") || name.endsWith(".cpp");
    }

    public static File computeRelativePath(File canonicalBase, File file) throws IOException {
        File canonical = file.getCanonicalFile();
        String canonicalPath = canonical.getPath();
        if (canonicalPath.startsWith(canonicalBase.getPath())) {
            int length = canonicalBase.getPath().length();
            if (canonicalPath.length() == length) {
                return new File(".");
            }
            if (canonicalPath.charAt(length) == File.separatorChar) {
                return new File(canonicalPath.substring(length + 1));
            }
            return new File(canonicalPath.substring(length));
        }
        return null;
    }

    public void importProjects(List<File> projectDirs) throws IOException {
        this.mySummary = new ImportSummary(this);
        this.myProjectMap.clear();
        this.myHandledJars.clear();
        this.myWarnings.clear();
        this.myErrors.clear();
        this.myWorkspaceProjects = null;
        this.myRootModules = Collections.emptyList();
        this.myModules = Sets.newHashSet();
        for (File file : projectDirs) {
            if (file.isFile()) {
                assert (!file.isDirectory());
                file = file.getParentFile();
            }
            this.guessWorkspace(file);
            if (GradleImport.isAdtProjectDir(file)) {
                this.guessSdk(file);
                this.guessNdk(file);
                try {
                    EclipseProject.getProject(this, file);
                    continue;
                }
                catch (ImportException importException) {
                    return;
                }
                catch (Exception exception) {
                    this.reportError(null, file, exception.toString(), false);
                    return;
                }
            }
            this.reportError(null, file, "Not a recognized project: " + file, false);
            return;
        }
        HashSet projects = Sets.newHashSet(this.myProjectMap.values());
        this.myRootModules = EclipseProject.performImport(this, projects);
        for (ImportModule importModule : this.myRootModules) {
            this.myModules.add(importModule);
            this.myModules.addAll(importModule.getAllDependencies());
        }
    }

    public GradleImport setGradleWrapperLocation(File gradleWrapper) {
        this.myGradleWrapperLocation = gradleWrapper;
        return this;
    }

    public File getSdkLocation() {
        return this.mySdkLocation;
    }

    public GradleImport setSdkLocation(File sdkLocation) {
        this.mySdkLocation = sdkLocation;
        return this;
    }

    public File getNdkLocation() {
        return this.myNdkLocation;
    }

    public GradleImport setNdkLocation(File ndkLocation) {
        this.myNdkLocation = ndkLocation;
        return this;
    }

    public File getEclipseWorkspace() {
        return this.myWorkspaceLocation;
    }

    public GradleImport setEclipseWorkspace(File workspace) {
        this.myWorkspaceLocation = workspace;
        assert (this.myWorkspaceLocation.exists()) : workspace.getPath();
        this.myWorkspaceProjects = null;
        return this;
    }

    public boolean isReplaceJars() {
        return this.myReplaceJars;
    }

    public GradleImport setReplaceJars(boolean replaceJars) {
        this.myReplaceJars = replaceJars;
        return this;
    }

    public boolean isReplaceLibs() {
        return this.myReplaceLibs;
    }

    public GradleImport setReplaceLibs(boolean replaceLibs) {
        this.myReplaceLibs = replaceLibs;
        return this;
    }

    public boolean isImportIntoExisting() {
        return this.myImportIntoExisting;
    }

    public void setImportIntoExisting(boolean importIntoExisting) {
        this.myImportIntoExisting = importIntoExisting;
    }

    public boolean isGradleNameStyle() {
        return this.myGradleNameStyle;
    }

    public GradleImport setGradleNameStyle(boolean lowerCase) {
        this.myGradleNameStyle = lowerCase;
        return this;
    }

    private void guessWorkspace(File projectDir) {
        if (this.myWorkspaceLocation == null) {
            for (File dir = projectDir.getParentFile(); dir != null; dir = dir.getParentFile()) {
                if (!GradleImport.isEclipseWorkspaceDir(dir)) continue;
                this.setEclipseWorkspace(dir);
                break;
            }
        }
    }

    private void guessSdk(File projectDir) {
        if (this.mySdkLocation == null) {
            this.mySdkLocation = GradleImport.getDirFromLocalProperties(projectDir, "sdk.dir");
            if (this.mySdkLocation == null && this.myWorkspaceLocation != null) {
                this.mySdkLocation = this.getDirFromWorkspaceSetting(this.getAdtSettingsFile(), "com.android.ide.eclipse.adt.sdk");
            }
        }
    }

    private void guessNdk(File projectDir) {
        if (this.myNdkLocation == null) {
            this.myNdkLocation = GradleImport.getDirFromLocalProperties(projectDir, "ndk.dir");
            if (this.myNdkLocation == null && this.myWorkspaceLocation != null) {
                this.myNdkLocation = this.getDirFromWorkspaceSetting(this.getNdkSettingsFile(), "ndkLocation");
            }
        }
    }

    private Charset getEncodingFromWorkspaceSetting() {
        if (this.myWorkspaceLocation != null && !this.myDefaultEncodingInitialized) {
            this.myDefaultEncodingInitialized = true;
            File settings = this.getEncodingSettingsFile();
            if (settings.exists()) {
                try {
                    String encodingName;
                    Properties properties = PropertiesFiles.getProperties(settings);
                    if (properties != null && (encodingName = properties.getProperty("encoding")) != null) {
                        try {
                            this.myDefaultEncoding = Charset.forName(encodingName);
                        }
                        catch (UnsupportedCharsetException uce) {
                            this.reportWarning((ImportModule)null, settings, "Unknown charset " + encodingName);
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return this.myDefaultEncoding;
    }

    private File getDirFromWorkspaceSetting(File settings, String property) {
        if (this.myWorkspaceLocation != null && settings.exists()) {
            try {
                Properties properties = PropertiesFiles.getProperties(settings);
                if (properties != null) {
                    String path = properties.getProperty(property);
                    if (path == null) {
                        return null;
                    }
                    File dir = new File(path);
                    if (dir.exists()) {
                        return dir;
                    }
                    dir = new File(path.replace('/', File.separatorChar));
                    if (dir.exists()) {
                        return dir;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public File resolveWorkspacePath(EclipseProject fromProject, String path, boolean record) {
        if (path.isEmpty()) {
            return null;
        }
        for (Map.Entry<String, File> entry : this.myPathMap.entrySet()) {
            File resolved;
            String workspacePath = entry.getKey();
            File file = entry.getValue();
            if (file == null || !path.startsWith(workspacePath)) continue;
            if (path.equals(workspacePath)) {
                return file;
            }
            if ((path = path.substring(workspacePath.length())).charAt(0) == '/' || path.charAt(0) == File.separatorChar) {
                path = path.substring(1);
            }
            if (!(resolved = new File(file, path.replace('/', File.separatorChar))).exists()) continue;
            return resolved;
        }
        if (fromProject != null && this.myWorkspaceLocation == null) {
            this.guessWorkspace(fromProject.getDir());
        }
        if (this.myWorkspaceLocation != null) {
            File project;
            char first = path.charAt(0);
            if (first != '/') {
                return null;
            }
            File f = new File(this.myWorkspaceLocation, path.substring(1).replace('/', File.separatorChar));
            if (f.exists()) {
                this.myPathMap.put(path, f);
                return f;
            }
            if (this.myWorkspaceProjects == null) {
                this.myWorkspaceProjects = Maps.newHashMap();
                File projectDir = new File(this.myWorkspaceLocation, ".metadata" + File.separator + ".plugins" + File.separator + "org.eclipse.core.resources" + File.separator + ".projects");
                File[] projects = projectDir.exists() ? projectDir.listFiles() : null;
                byte[] target = "URI//file:".getBytes(Charsets.US_ASCII);
                if (projects != null) {
                    for (File project2 : projects) {
                        File location = new File(project2, ".location");
                        if (!location.exists()) continue;
                        try {
                            int end;
                            byte[] bytes = Files.toByteArray((File)location);
                            int start = Bytes.indexOf((byte[])bytes, (byte[])target);
                            if (start == -1) continue;
                            for (end = start + target.length; end < bytes.length && bytes[end] != 0; ++end) {
                            }
                            try {
                                int length = end - start;
                                String s = new String(bytes, start, length, Charsets.UTF_8);
                                s = s.substring(5);
                                File file = SdkUtils.urlToFile((String)s);
                                if (!file.exists()) continue;
                                String name = project2.getName();
                                this.myWorkspaceProjects.put('/' + name, file);
                            }
                            catch (Throwable throwable) {}
                        }
                        catch (IOException e) {
                            this.reportWarning((ImportModule)null, location, "Can't read .location file");
                        }
                    }
                }
            }
            if ((project = this.myWorkspaceProjects.get(path)) != null) {
                this.myPathMap.put(path, project);
                return project;
            }
            for (Map.Entry<String, File> entry : this.myWorkspaceProjects.entrySet()) {
                File resolved;
                String workspacePath = entry.getKey();
                File file = entry.getValue();
                if (file == null || !path.startsWith(workspacePath)) continue;
                if (path.equals(workspacePath)) {
                    return file;
                }
                if ((path = path.substring(workspacePath.length())).charAt(0) == '/' || path.charAt(0) == File.separatorChar) {
                    path = path.substring(1);
                }
                if (!(resolved = new File(file, path.replace('/', File.separatorChar))).exists()) continue;
                return resolved;
            }
            if (record) {
                this.myPathMap.put(path, null);
            }
        } else if (record) {
            this.myPathMap.put(path, null);
        }
        return null;
    }

    public void exportProject(File destDir, boolean allowNonEmpty) throws IOException {
        this.mySummary.setDestDir(destDir);
        if (!this.isImportIntoExisting()) {
            this.createDestDir(destDir, allowNonEmpty);
            this.createProjectBuildGradle(new File(destDir, "build.gradle"));
            this.exportGradleWrapper(destDir);
            this.exportLocalProperties(destDir);
        }
        this.exportSettingsGradle(new File(destDir, "settings.gradle"), this.isImportIntoExisting());
        for (ImportModule importModule : this.getModulesToImport()) {
            this.exportModule(new File(destDir, importModule.getModuleName()), importModule);
        }
        this.mySummary.write(new File(destDir, IMPORT_SUMMARY_TXT));
    }

    private Iterable<? extends ImportModule> getModulesToImport() {
        if (this.mySelectedModules == null) {
            return this.myRootModules;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ImportModule importModule : this.myRootModules) {
            File dir = importModule.getDir();
            if (!this.mySelectedModules.containsKey(dir)) continue;
            String name = this.mySelectedModules.get(dir);
            if (name != null) {
                importModule.setModuleName(name);
            }
            builder.add((Object)importModule);
        }
        return builder.build();
    }

    @Deprecated
    public void setModulesToImport(Map<String, File> modules) {
        this.mySelectedModules = Maps.newHashMap();
        for (File module : modules.values()) {
            this.mySelectedModules.put(module, null);
        }
    }

    public List<File> exportIntoProject(File projectDir, boolean updateSettings, boolean writeSummary, Map<File, File> destDirMap) throws IOException {
        this.mySummary.setDestDir(projectDir);
        ArrayList imported = Lists.newArrayListWithExpectedSize((int)this.myRootModules.size());
        for (ImportModule importModule : this.getModulesToImport()) {
            File moduleDir = null;
            if (destDirMap != null) {
                moduleDir = destDirMap.get(importModule.getDir());
            }
            if (moduleDir == null && (moduleDir = new File(projectDir, importModule.getModuleName())).exists()) {
                importModule.pickUniqueName(projectDir);
                moduleDir = new File(projectDir, importModule.getModuleName());
                assert (!moduleDir.exists());
            }
            this.exportModule(moduleDir, importModule);
            imported.add(moduleDir);
        }
        if (updateSettings) {
            this.exportSettingsGradle(new File(projectDir, "settings.gradle"), true);
        }
        if (writeSummary) {
            this.mySummary.write(new File(projectDir, IMPORT_SUMMARY_TXT));
        }
        return imported;
    }

    private void exportGradleWrapper(File destDir) throws IOException {
        if (this.myGradleWrapperLocation != null && this.myGradleWrapperLocation.exists()) {
            File gradlewDest = new File(destDir, "gradlew");
            this.copyDir(new File(this.myGradleWrapperLocation, "gradlew"), gradlewDest, null, false, null);
            boolean madeExecutable = gradlewDest.setExecutable(true);
            if (!madeExecutable) {
                this.reportWarning((ImportModule)null, gradlewDest, "Could not make gradle wrapper script executable");
            }
            this.copyDir(new File(this.myGradleWrapperLocation, "gradlew.bat"), new File(destDir, "gradlew.bat"), null, false, null);
            this.copyDir(new File(this.myGradleWrapperLocation, "gradle"), new File(destDir, "gradle"), null, false, null);
        }
    }

    private void exportLocalProperties(File destDir) throws IOException {
        boolean needsNdk = this.needsNdk();
        if (this.myNdkLocation != null && needsNdk || this.mySdkLocation != null) {
            Properties properties = new Properties();
            if (this.mySdkLocation != null) {
                properties.setProperty("sdk.dir", this.mySdkLocation.getPath());
            }
            if (this.myNdkLocation != null && needsNdk) {
                properties.setProperty("ndk.dir", this.myNdkLocation.getPath());
            }
            File path = new File(destDir, "local.properties");
            String comments = "# This file must *NOT* be checked into Version Control Systems,\n# as it contains information specific to your local configuration.\n\n# Location of the SDK. This is only used by Gradle.\n";
            PropertiesFiles.savePropertiesToFile(properties, path, comments);
        }
    }

    public boolean needsNdk() {
        for (ImportModule module : this.myModules) {
            if (!module.isNdkProject()) continue;
            return true;
        }
        return false;
    }

    private void exportModule(File destDir, ImportModule module) throws IOException {
        this.mkdirs(destDir);
        this.createModuleBuildGradle(new File(destDir, "build.gradle"), module);
        module.copyInto(destDir);
    }

    public void mkdirs(File destDir) throws IOException {
        boolean ok;
        if (!destDir.exists() && !(ok = destDir.mkdirs())) {
            this.reportError(null, destDir, "Could not make directory " + destDir);
        }
    }

    private void createModuleBuildGradle(File file, ImportModule module) throws IOException {
        StringBuilder sb = new StringBuilder(500);
        if (module.isApp() || module.isAndroidLibrary()) {
            String languageLevel;
            if (module.isApp()) {
                sb.append("apply plugin: 'com.android.application'").append(NL);
            } else {
                assert (module.isAndroidLibrary());
                sb.append("apply plugin: 'com.android.library'").append(NL);
            }
            sb.append(NL);
            sb.append("android {").append(NL);
            AndroidVersion compileSdkVersion = module.getCompileSdkVersion();
            AndroidVersion minSdkVersion = module.getMinSdkVersion();
            AndroidVersion targetSdkVersion = module.getTargetSdkVersion();
            String compileSdkVersionString = compileSdkVersion.isPreview() ? '\'' + AndroidTargetHash.getPlatformHashString((AndroidVersion)compileSdkVersion) + '\'' : Integer.toString(compileSdkVersion.getApiLevel());
            String addOn = module.getAddOn();
            if (addOn != null) {
                compileSdkVersionString = '\'' + addOn + '\'';
            }
            String minSdkVersionString = minSdkVersion.isPreview() ? '\'' + module.getMinSdkVersion().getCodename() + '\'' : Integer.toString(module.getMinSdkVersion().getApiLevel());
            String targetSdkVersionString = targetSdkVersion.isPreview() ? '\'' + module.getTargetSdkVersion().getCodename() + '\'' : Integer.toString(module.getTargetSdkVersion().getApiLevel());
            sb.append("    compileSdkVersion ").append(compileSdkVersionString).append(NL);
            sb.append("    buildToolsVersion \"").append(this.getBuildToolsVersion()).append("\"").append(NL);
            sb.append(NL);
            sb.append("    defaultConfig {").append(NL);
            if (module.getPackage() != null && module.isApp()) {
                sb.append("        applicationId \"").append(module.getPackage()).append('\"').append(NL);
            }
            if (minSdkVersion.getApiLevel() > 1) {
                sb.append("        minSdkVersion ").append(minSdkVersionString).append(NL);
            }
            if (targetSdkVersion.getApiLevel() > 1 && compileSdkVersion.getApiLevel() > 3) {
                sb.append("        targetSdkVersion ").append(targetSdkVersionString).append(NL);
            }
            if (!(languageLevel = module.getLanguageLevel()).equals("1.6")) {
                sb.append("        compileOptions {").append(NL);
                String level = languageLevel.replace('.', '_');
                sb.append("            sourceCompatibility JavaVersion.VERSION_").append(level).append(NL);
                sb.append("            targetCompatibility JavaVersion.VERSION_").append(level).append(NL);
                sb.append("        }").append(NL);
            }
            if (module.isNdkProject() && module.getNativeModuleName() != null) {
                sb.append(NL);
                sb.append("        ndk {").append(NL);
                sb.append("            moduleName \"").append(module.getNativeModuleName()).append("\"").append(NL);
                sb.append("        }").append(NL);
            }
            if (module.getInstrumentationDir() != null) {
                sb.append(NL);
                File manifestFile = new File(module.getInstrumentationDir(), "AndroidManifest.xml");
                assert (manifestFile.exists()) : manifestFile;
                Document manifest = this.getXmlDocument(manifestFile, true);
                if (manifest != null && manifest.getDocumentElement() != null) {
                    NodeList list;
                    String pkg = manifest.getDocumentElement().getAttribute("package");
                    if (pkg != null && !pkg.isEmpty()) {
                        sb.append("        testApplicationId \"").append(pkg).append("\"").append(NL);
                    }
                    if ((list = manifest.getElementsByTagName("instrumentation")).getLength() > 0) {
                        Attr attr;
                        Element tag = (Element)list.item(0);
                        String runner = tag.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                        if (runner != null && !runner.isEmpty()) {
                            sb.append("        testInstrumentationRunner \"").append(runner).append("\"").append(NL);
                        }
                        if ((attr = tag.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "functionalTest")) != null) {
                            sb.append("        testFunctionalTest ").append(attr.getValue()).append(NL);
                        }
                        if ((attr = tag.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "handleProfiling")) != null) {
                            sb.append("        testHandlingProfiling ").append(attr.getValue()).append(NL);
                        }
                    }
                }
            }
            sb.append("    }").append(NL);
            sb.append(NL);
            List<File> localRules = module.getLocalProguardFiles();
            List<File> sdkRules = module.getSdkProguardFiles();
            if (!localRules.isEmpty() || !sdkRules.isEmpty()) {
                sb.append("    buildTypes {").append(NL);
                sb.append("        release {").append(NL);
                sb.append("            minifyEnabled true").append(NL);
                sb.append("            proguardFiles ");
                sb.append(GradleImport.generateProguardFileList(localRules, sdkRules)).append(NL);
                sb.append("        }").append(NL);
                sb.append("    }").append(NL);
            } else {
                sb.append("    buildTypes {").append(NL);
                sb.append("        release {").append(NL);
                sb.append("            minifyEnabled false").append(NL);
                sb.append("            proguardFiles getDefaultProguardFile('proguard-android.txt'), 'proguard-rules.txt'").append(NL);
                sb.append("        }").append(NL);
                sb.append("    }").append(NL);
            }
            sb.append("}").append(NL);
            GradleImport.appendDependencies(sb, module);
        } else if (module.isJavaLibrary()) {
            sb.append("apply plugin: 'java'").append(NL);
            String languageLevel = module.getLanguageLevel();
            if (!languageLevel.equals("1.6")) {
                sb.append(NL);
                sb.append("sourceCompatibility = \"");
                sb.append(languageLevel);
                sb.append("\"").append(NL);
                sb.append("targetCompatibility = \"");
                sb.append(languageLevel);
                sb.append("\"").append(NL);
            }
            GradleImport.appendDependencies(sb, module);
        } else assert (false) : module;
        Files.write((CharSequence)sb.toString(), (File)file, (Charset)Charsets.UTF_8);
    }

    String getBuildToolsVersion() {
        AndroidSdkHandler sdkHandler = AndroidSdkHandler.getInstance((File)this.mySdkLocation);
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
        return GradleBuildSettings.getRecommendedBuildToolsRevision(sdkHandler, (ProgressIndicator)progress).toString();
    }

    private void createProjectBuildGradle(File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("// Top-level build file where you can add configuration options common to all sub-projects/modules.").append(NL);
        sb.append("buildscript {").append(NL);
        sb.append("    repositories {").append(NL);
        sb.append("        ").append(MAVEN_REPOSITORY).append(NL);
        sb.append("    }").append(NL);
        sb.append("    dependencies {").append(NL);
        sb.append("        classpath '" + ANDROID_GRADLE_PLUGIN + "'").append(NL);
        sb.append("    }").append(NL);
        sb.append("}").append(NL);
        sb.append(NL);
        sb.append("allprojects {").append(NL);
        sb.append("    repositories {").append(NL);
        sb.append("        ").append(MAVEN_REPOSITORY).append(NL);
        sb.append("    }").append(NL);
        sb.append("}").append(NL);
        Files.write((CharSequence)sb.toString(), (File)file, (Charset)Charsets.UTF_8);
    }

    private void exportSettingsGradle(File file, boolean append) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (append) {
            if (!file.exists()) {
                append = false;
            } else {
                String existing = Files.toString((File)file, (Charset)Charsets.UTF_8);
                if (!existing.endsWith(NL)) {
                    sb.append(NL);
                }
            }
        }
        for (ImportModule importModule : this.getModulesToImport()) {
            sb.append("include '");
            sb.append(importModule.getModuleReference());
            sb.append("'");
            sb.append(NL);
        }
        String code = sb.toString();
        if (append) {
            Files.append((CharSequence)code, (File)file, (Charset)Charsets.UTF_8);
        } else {
            Files.write((CharSequence)code, (File)file, (Charset)Charsets.UTF_8);
        }
    }

    private void createDestDir(File destDir, boolean allowNonEmpty) throws IOException {
        if (destDir.exists()) {
            File[] files;
            if (!allowNonEmpty && (files = destDir.listFiles()) != null && files.length > 0) {
                throw new IOException("Destination directory " + destDir + " should be empty");
            }
        } else {
            this.mkdirs(destDir);
        }
    }

    public List<String> getWarnings() {
        return this.myWarnings;
    }

    public List<String> getErrors() {
        return this.myErrors;
    }

    public Map<String, File> getDetectedModuleLocations() {
        TreeMap<String, File> modules = new TreeMap<String, File>();
        for (ImportModule module : this.myModules) {
            modules.put(module.getModuleName(), module.getCanonicalModuleDir());
        }
        return modules;
    }

    public void setImportModuleNames(Map<File, String> moduleLocationToName) {
        this.mySelectedModules = ImmutableMap.copyOf(moduleLocationToName);
    }

    @NotNull
    public Set<String> getProjectDependencies(String projectName) {
        ImportModule module = null;
        for (ImportModule m : this.myModules) {
            if (!Objects.equal((Object)m.getModuleName(), (Object)projectName)) continue;
            module = m;
            break;
        }
        if (module == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder deps = ImmutableSet.builder();
        for (ImportModule importModule : module.getAllDependencies()) {
            deps.add((Object)importModule.getModuleName());
        }
        return deps.build();
    }

    public void reportError(EclipseProject project, File file, String message) {
        this.reportError(project, file, message, true);
    }

    public void reportError(EclipseProject project, File file, String message, boolean abort) {
        String text = GradleImport.formatMessage(project != null ? project.getName() : null, file, message);
        this.myErrors.add(text);
        if (abort) {
            throw new ImportException(text);
        }
    }

    public void reportWarning(ImportModule module, File file, String message) {
        String moduleName = module != null ? module.getOriginalName() : null;
        this.myWarnings.add(GradleImport.formatMessage(moduleName, file, message));
    }

    public void reportWarning(EclipseProject project, File file, String message) {
        String moduleName = project != null ? project.getName() : null;
        this.myWarnings.add(GradleImport.formatMessage(moduleName, file, message));
    }

    File resolvePathVariable(EclipseProject fromProject, String name, boolean record) throws IOException {
        File file = this.myPathMap.get(name);
        if (file != null) {
            return file;
        }
        if (fromProject != null && this.myWorkspaceLocation == null) {
            this.guessWorkspace(fromProject.getDir());
        }
        String value = null;
        Properties properties = this.getJdtSettingsProperties(false);
        if (properties != null) {
            value = properties.getProperty("org.eclipse.jdt.core.classpathVariable." + name);
        }
        if (value == null && (properties = this.getPathSettingsProperties(false)) != null) {
            value = properties.getProperty("pathvariable." + name);
        }
        if (value == null) {
            if (record) {
                this.myPathMap.put(name, null);
            }
            return null;
        }
        file = new File(value.replace('/', File.separatorChar));
        return file;
    }

    private Properties getJdtSettingsProperties(boolean mustExist) throws IOException {
        File settings = this.getJdtSettingsFile();
        if (!settings.exists()) {
            if (mustExist) {
                this.reportError(null, settings, "Settings file does not exist");
            }
            return null;
        }
        return PropertiesFiles.getProperties(settings);
    }

    private File getRuntimeSettingsDir() {
        return new File(this.getWorkspaceLocation(), ".metadata" + File.separator + ".plugins" + File.separator + "org.eclipse.core.runtime" + File.separator + ".settings");
    }

    private File getJdtSettingsFile() {
        return new File(this.getRuntimeSettingsDir(), "org.eclipse.jdt.core.prefs");
    }

    private File getPathSettingsFile() {
        return new File(this.getRuntimeSettingsDir(), "org.eclipse.core.resources.prefs");
    }

    private File getEncodingSettingsFile() {
        return this.getPathSettingsFile();
    }

    private File getNdkSettingsFile() {
        return new File(this.getRuntimeSettingsDir(), "com.android.ide.eclipse.ndk.prefs");
    }

    private File getAdtSettingsFile() {
        return new File(this.getRuntimeSettingsDir(), "com.android.ide.eclipse.adt.prefs");
    }

    private Properties getPathSettingsProperties(boolean mustExist) throws IOException {
        File settings = this.getPathSettingsFile();
        if (!settings.exists()) {
            if (mustExist) {
                this.reportError(null, settings, "Settings file does not exist");
            }
            return null;
        }
        return PropertiesFiles.getProperties(settings);
    }

    private File getWorkspaceLocation() {
        return this.myWorkspaceLocation;
    }

    Document getXmlDocument(File file, boolean namespaceAware) throws IOException {
        String xml = Files.toString((File)file, (Charset)Charsets.UTF_8);
        try {
            return XmlUtils.parseDocument((String)xml, (boolean)namespaceAware);
        }
        catch (Exception e) {
            this.reportError(null, file, "Invalid XML file: " + file.getPath() + ":\n" + e.getMessage());
            return null;
        }
    }

    Map<File, EclipseProject> getProjectMap() {
        return this.myProjectMap;
    }

    public ImportSummary getSummary() {
        return this.mySummary;
    }

    void registerProject(EclipseProject project) {
        this.myProjectMap.put(project.getDir(), project);
        this.myProjectMap.put(project.getDir().getAbsoluteFile(), project);
        this.myProjectMap.put(project.getCanonicalDir(), project);
    }

    int getModuleCount() {
        int moduleCount = 0;
        for (ImportModule module : this.myModules) {
            if (module.isReplacedWithDependency()) continue;
            ++moduleCount;
        }
        return moduleCount;
    }

    public Map<String, File> getPathMap() {
        return this.myPathMap;
    }

    public void copyDir(File source, File dest, CopyHandler handler, boolean updateEncoding, ImportModule sourceModule) throws IOException {
        if (handler != null && handler.handle(source, dest, updateEncoding, sourceModule)) {
            return;
        }
        if (source.isDirectory()) {
            File[] copied;
            if (GradleImport.isIgnoredFile(source)) {
                return;
            }
            this.mkdirs(dest);
            File[] files = source.listFiles();
            if (files != null) {
                for (File child : files) {
                    this.copyDir(child, new File(dest, child.getName()), handler, updateEncoding, sourceModule);
                }
            }
            if ((copied = dest.listFiles()) != null && copied.length == 0) {
                dest.delete();
            }
        } else if (updateEncoding && GradleImport.isTextFile(source) && !source.getPath().endsWith(".properties")) {
            this.copyTextFile(sourceModule, source, dest);
        } else {
            Files.copy((File)source, (File)dest);
        }
    }

    public void copyTextFile(ImportModule module, File source, File dest) throws IOException {
        assert (GradleImport.isTextFile(source)) : source;
        Charset encoding = null;
        if (module != null) {
            encoding = module.getFileEncoding(source);
            if (encoding != null) {
                GradleImport.copyTextFileWithEncoding(source, dest, encoding);
                return;
            }
            encoding = module.getProjectEncoding(source);
        }
        if (encoding == null) {
            encoding = this.getEncodingFromWorkspaceSetting();
        }
        if (SdkUtils.endsWithIgnoreCase((String)source.getPath(), (String)".xml")) {
            int prologueEnd;
            String defaultCharset = encoding != null ? encoding.name() : "UTF-8";
            String xml = PositionXmlParser.getXmlString((byte[])Files.toByteArray((File)source), (String)defaultCharset);
            if (xml.startsWith("<?xml") && (prologueEnd = xml.indexOf("?>")) != -1) {
                xml = "<?xml version=\"1.0\" encoding=\"utf-8\"?>" + xml.substring(prologueEnd + 2);
            }
            Files.write((CharSequence)xml, (File)dest, (Charset)Charsets.UTF_8);
        } else if (encoding != null) {
            GradleImport.copyTextFileWithEncoding(source, dest, encoding);
        } else {
            Files.copy((File)source, (File)dest);
        }
    }

    void markJarHandled(File file) {
        this.myHandledJars.add(file.getName());
    }

    boolean isJarHandled(File file) {
        return this.myHandledJars.contains(file.getName());
    }

    private boolean haveLocalRepository(SdkMavenRepository repository) {
        if (repository.isInstalled(AndroidSdkHandler.getInstance((File)this.mySdkLocation))) {
            return true;
        }
        return repository.isInstalled(this.mySdkLocation, FileOpUtils.create());
    }

    public boolean needSupportRepository() {
        return this.haveArtifact("com.android.support");
    }

    public boolean needGoogleRepository() {
        return this.haveArtifact("com.google.android.gms");
    }

    private boolean haveArtifact(String groupId) {
        for (ImportModule importModule : this.getModulesToImport()) {
            for (GradleCoordinate dependency : importModule.getDependencies()) {
                if (!groupId.equals(dependency.getGroupId())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMissingSupportRepository() {
        return !this.haveLocalRepository(SdkMavenRepository.ANDROID);
    }

    public boolean isMissingGoogleRepository() {
        return !this.haveLocalRepository(SdkMavenRepository.GOOGLE);
    }

    static {
        String repository = System.getProperty(MAVEN_URL_PROPERTY);
        repository = repository == null ? "jcenter()" : "jcenter();" + NL + "        maven { url '" + repository + "' }";
        MAVEN_REPOSITORY = repository;
    }

    private static class ImportException
    extends RuntimeException {
        private String mMessage;

        private ImportException(String message) {
            this.mMessage = message;
        }

        @Override
        public String getMessage() {
            return this.mMessage;
        }

        @Override
        public String toString() {
            return this.getMessage();
        }
    }

    public static interface CopyHandler {
        public boolean handle(File var1, File var2, boolean var3, ImportModule var4) throws IOException;
    }
}

