/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class GeneratedFileWritingAccessProvider
extends WritingAccessProvider {
    @NotNull
    private final GradleProjectInfo myProjectInfo;
    @NotNull
    private final ProjectFileIndex myProjectFileIndex;

    public GeneratedFileWritingAccessProvider(@NotNull GradleProjectInfo projectInfo, @NotNull ProjectFileIndex projectFileIndex) {
        this.myProjectInfo = projectInfo;
        this.myProjectFileIndex = projectFileIndex;
    }

    @NotNull
    public Collection<VirtualFile> requestWriting(VirtualFile ... files) {
        ArrayList<VirtualFile> readOnlyFiles = new ArrayList<VirtualFile>();
        for (VirtualFile file : files) {
            if (!this.isInBuildFolderAndNotSource(file)) continue;
            readOnlyFiles.add(file);
        }
        return readOnlyFiles;
    }

    public boolean isPotentiallyWritable(@NotNull VirtualFile file) {
        return !this.isInBuildFolderAndNotSource(file);
    }

    private boolean isInBuildFolderAndNotSource(@NotNull VirtualFile file) {
        if (this.myProjectFileIndex.isInSource(file)) {
            return false;
        }
        AndroidModuleModel androidModel = this.myProjectInfo.findAndroidModelInModule(file, false);
        if (androidModel == null) {
            return false;
        }
        File buildFolderPath = androidModel.getAndroidProject().getBuildFolder();
        VirtualFile buildFolder = VfsUtil.findFileByIoFile((File)buildFolderPath, (boolean)false);
        if (buildFolder == null || !buildFolder.isDirectory()) {
            return false;
        }
        return VfsUtilCore.isAncestor((VirtualFile)buildFolder, (VirtualFile)file, (boolean)false);
    }
}

