/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.entity;

import com.android.tools.idea.gradle.editor.entity.AbstractGradleEditorEntity;
import com.android.tools.idea.gradle.editor.entity.GradleEditorSourceBinding;
import com.android.tools.idea.gradle.editor.entity.GradleEntityDeclarationValueLocationAware;
import com.android.tools.idea.gradle.editor.entity.GradleEntityDefinitionValueLocationAware;
import com.android.tools.idea.gradle.editor.metadata.GradleEditorEntityMetaData;
import com.android.tools.idea.gradle.editor.value.GradleEditorEntityValueManager;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalDependencyGradleEditorEntity
extends AbstractGradleEditorEntity
implements GradleEntityDeclarationValueLocationAware,
GradleEntityDefinitionValueLocationAware {
    @NotNull
    private String myScope;
    @NotNull
    private final List<GradleEditorSourceBinding> myScopeBindings = Lists.newArrayList();
    @NotNull
    private String myGroupId;
    @NotNull
    private final List<GradleEditorSourceBinding> myGroupIdSourceBindings = Lists.newArrayList();
    @NotNull
    private String myArtifactId;
    @NotNull
    private final List<GradleEditorSourceBinding> myArtifactIdSourceBindings = Lists.newArrayList();
    @NotNull
    private String myVersion;
    @NotNull
    private final List<GradleEditorSourceBinding> myVersionSourceBindings = Lists.newArrayList();
    @NotNull
    private final GradleEditorSourceBinding myVersionDeclarationLocation;
    @NotNull
    private final GradleEditorEntityValueManager myVersionValueManager;

    public ExternalDependencyGradleEditorEntity(@NotNull String scope, @NotNull List<GradleEditorSourceBinding> scopeSourceBindings, @NotNull String groupId, @NotNull List<GradleEditorSourceBinding> groupIdSourceBindings, @NotNull String artifactId, @NotNull List<GradleEditorSourceBinding> artifactIdSourceBindings, @NotNull String version, @NotNull List<GradleEditorSourceBinding> versionSourceBindings, @NotNull GradleEditorSourceBinding entityLocation, @NotNull GradleEditorSourceBinding versionDeclarationLocation, @NotNull GradleEditorEntityValueManager versionValueManager, @NotNull Set<GradleEditorEntityMetaData> metaData) {
        super(entityLocation, metaData, null);
        this.myScope = scope;
        this.myScopeBindings.addAll(scopeSourceBindings);
        this.myGroupId = groupId;
        this.myGroupIdSourceBindings.addAll(groupIdSourceBindings);
        this.myArtifactId = artifactId;
        this.myArtifactIdSourceBindings.addAll(artifactIdSourceBindings);
        this.myVersion = version;
        this.myVersionSourceBindings.addAll(versionSourceBindings);
        this.myVersionDeclarationLocation = versionDeclarationLocation;
        this.myVersionValueManager = versionValueManager;
    }

    @Override
    @NotNull
    public String getName() {
        return String.format("%s %s:%s:%s", this.myScope, this.myGroupId, this.myArtifactId, this.myVersion);
    }

    @NotNull
    public String getScope() {
        return this.myScope;
    }

    @NotNull
    public List<GradleEditorSourceBinding> getScopeBindings() {
        return this.myScopeBindings;
    }

    @NotNull
    public String getGroupId() {
        return this.myGroupId;
    }

    @NotNull
    public List<GradleEditorSourceBinding> getGroupIdSourceBindings() {
        return this.myGroupIdSourceBindings;
    }

    @NotNull
    public String getArtifactId() {
        return this.myArtifactId;
    }

    @NotNull
    public List<GradleEditorSourceBinding> getArtifactIdSourceBindings() {
        return this.myArtifactIdSourceBindings;
    }

    @NotNull
    public String getVersion() {
        return this.myVersion;
    }

    @NotNull
    public List<GradleEditorSourceBinding> getVersionSourceBindings() {
        return this.myVersionSourceBindings;
    }

    @Override
    @NotNull
    public GradleEditorSourceBinding getDeclarationValueLocation() {
        return this.myVersionDeclarationLocation;
    }

    @Override
    @Nullable
    public GradleEditorSourceBinding getDefinitionValueLocation() {
        return this.myVersionSourceBindings.size() == 1 ? this.myVersionSourceBindings.get(0) : null;
    }

    @NotNull
    public GradleEditorEntityValueManager getVersionValueManager() {
        return this.myVersionValueManager;
    }

    @Nullable
    public String changeVersion(@NotNull String newVersion) {
        if (newVersion.equals(this.getVersion())) {
            return null;
        }
        List<GradleEditorSourceBinding> sourceBindings = this.getVersionSourceBindings();
        if (sourceBindings.size() != 1) {
            return String.format("Can't apply version '%s' to the entity '%s'. Reason: expected the entity to hold only one version source binding but it has %d (%s)", newVersion, this, sourceBindings.size(), sourceBindings);
        }
        GradleEditorSourceBinding binding = sourceBindings.get(0);
        RangeMarker rangeMarker = binding.getRangeMarker();
        if (!rangeMarker.isValid()) {
            return String.format("Can't apply version '%s' to the entity '%s'. Reason: source file binding is incorrect", newVersion, this);
        }
        this.myVersion = newVersion;
        rangeMarker.getDocument().replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)newVersion);
        return null;
    }

    @Override
    public void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.myVersionDeclarationLocation);
        for (GradleEditorSourceBinding binding : this.myScopeBindings) {
            Disposer.dispose((Disposable)binding);
        }
        for (GradleEditorSourceBinding binding : this.myGroupIdSourceBindings) {
            Disposer.dispose((Disposable)binding);
        }
        for (GradleEditorSourceBinding binding : this.myArtifactIdSourceBindings) {
            Disposer.dispose((Disposable)binding);
        }
        for (GradleEditorSourceBinding binding : this.myVersionSourceBindings) {
            Disposer.dispose((Disposable)binding);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (!this.getMetaData().isEmpty()) {
            buffer.append('[').append(Joiner.on((char)'|').join(this.getMetaData())).append("] ");
        }
        buffer.append(this.myScope.isEmpty() ? String.format("<defined %d times>", this.myScopeBindings.size()) : this.myScope);
        buffer.append(" ").append(this.myGroupId.isEmpty() ? String.format("<defined %d times>", this.myGroupIdSourceBindings.size()) : this.myGroupId);
        buffer.append(":").append(this.myArtifactId.isEmpty() ? String.format("<defined %d times>", this.myArtifactIdSourceBindings.size()) : this.myArtifactId);
        buffer.append(":").append(this.myVersion.isEmpty() ? String.format("<defined %d times>", this.myVersionSourceBindings.size()) : this.myVersion);
        return buffer.toString();
    }
}

