/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.entity;

import com.android.tools.idea.gradle.editor.entity.GradleEditorEntity;
import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GradleEditorEntityGroup
implements Disposable {
    @NotNull
    private final String myName;
    @NotNull
    private final List<GradleEditorEntity> myEntities;
    @NotNull
    private final List<GradleEditorEntity> myEntitiesView;

    public GradleEditorEntityGroup(@NotNull String name) {
        this(name, Collections.emptyList());
    }

    public GradleEditorEntityGroup(@NotNull String name, @NotNull Iterable<GradleEditorEntity> entities) {
        this.myName = name;
        this.myEntities = Lists.newArrayList(entities);
        this.myEntitiesView = Collections.unmodifiableList(this.myEntities);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public List<GradleEditorEntity> getEntities() {
        return this.myEntitiesView;
    }

    public void addEntity(@NotNull GradleEditorEntity entity) {
        this.myEntities.add(entity);
    }

    public void dispose() {
        for (GradleEditorEntity entity : this.myEntities) {
            Disposer.dispose((Disposable)entity);
        }
    }

    public String toString() {
        return String.format("%s [%d entities]", this.myName, this.myEntities.size());
    }
}

