/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.filters;

import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.util.Projects;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GradleConsoleReRunFilterProvider
implements ConsoleFilterProvider {
    @NotNull
    public Filter[] getDefaultFilters(@NotNull Project project) {
        if (!Projects.isBuildWithGradle(project)) {
            return Filter.EMPTY_ARRAY;
        }
        return new Filter[]{new MyReRunBuildFilter()};
    }

    private static class MyReRunBuildFilter
    implements Filter {
        private String line;
        private List<Filter.ResultItem> links;
        private int lineStart;

        private MyReRunBuildFilter() {
        }

        public Filter.Result applyFilter(String line, int entireLength) {
            if (line == null) {
                return null;
            }
            this.line = line;
            this.lineStart = entireLength - line.length();
            this.links = new ArrayList<Filter.ResultItem>();
            String trimLine = line.trim();
            if (!trimLine.contains("Run with --") || !trimLine.endsWith("option to get the stack trace.") && !trimLine.endsWith("option to get more log output.")) {
                return null;
            }
            this.addLinkIfMatch("Run with --stacktrace", "--stacktrace");
            this.addLinkIfMatch("Run with --info", "--info");
            this.addLinkIfMatch("Run with --debug option", "--debug");
            this.addLinkIfMatch("--debug option", "--debug");
            if (this.links.isEmpty()) {
                return null;
            }
            return new Filter.Result(this.links);
        }

        private void addLinkIfMatch(@NotNull String text, @NotNull String option) {
            int index = this.line.indexOf(text);
            if (index != -1) {
                this.links.add(this.createLink(this.lineStart + index, this.lineStart + index + text.length(), option));
            }
        }

        @NotNull
        private Filter.ResultItem createLink(int start, int end, @NotNull String option) {
            ArrayList<String> options = new ArrayList<String>();
            options.add(option);
            return new Filter.ResultItem(start, end, project -> GradleBuildInvoker.getInstance(project).rebuildWithTempOptions(options));
        }
    }
}

