/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.model.java;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.Serializable;
import org.gradle.tooling.model.GradleModuleVersion;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarLibraryDependency
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    @NonNls
    private static final String UNRESOLVED_DEPENDENCY_PREFIX = "unresolved dependency - ";
    @NotNull
    private final String myName;
    @Nullable
    private final File myBinaryPath;
    @Nullable
    private final File mySourcePath;
    @Nullable
    private final File myJavadocPath;
    @Nullable
    private final String myScope;
    @Nullable
    private final GradleModuleVersion myModuleVersion;
    private final boolean myResolved;

    @NotNull
    public static String getDependencyName(@NotNull File binaryPath, boolean resolved) {
        if (resolved) {
            return binaryPath.isFile() ? FileUtil.getNameWithoutExtension((File)binaryPath) : FileUtil.sanitizeFileName((String)binaryPath.getPath());
        }
        return binaryPath.getName().substring(UNRESOLVED_DEPENDENCY_PREFIX.length()).replace(' ', ':');
    }

    public static boolean isResolved(@NotNull String libraryName) {
        return !libraryName.startsWith(UNRESOLVED_DEPENDENCY_PREFIX);
    }

    public JarLibraryDependency(@NotNull String name, @Nullable File binaryPath, @Nullable File sourcePath, @Nullable File javadocPath, @Nullable String scope, @Nullable GradleModuleVersion moduleVersion, boolean resolved) {
        this.myName = name;
        this.myBinaryPath = binaryPath;
        this.mySourcePath = sourcePath;
        this.myJavadocPath = javadocPath;
        this.myScope = scope;
        this.myModuleVersion = moduleVersion;
        this.myResolved = resolved;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @Nullable
    public File getBinaryPath() {
        return this.myBinaryPath;
    }

    @Nullable
    public File getSourcePath() {
        return this.mySourcePath;
    }

    @Nullable
    public File getJavadocPath() {
        return this.myJavadocPath;
    }

    @Nullable
    public String getScope() {
        return this.myScope;
    }

    @Nullable
    public GradleModuleVersion getModuleVersion() {
        return this.myModuleVersion;
    }

    public boolean isResolved() {
        return this.myResolved;
    }
}

