/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.notification;

import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.sync.GradleFiles;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ThreeState;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSyncStatusNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    @NotNull
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"android.gradle.sync.status");
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleProjectInfo myProjectInfo;
    @NotNull
    private final GradleSyncState mySyncState;

    public ProjectSyncStatusNotificationProvider(@NotNull Project project, @NotNull GradleProjectInfo projectInfo, @NotNull GradleSyncState syncState) {
        this.myProject = project;
        this.myProjectInfo = projectInfo;
        this.mySyncState = syncState;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        NotificationPanel oldPanel = (NotificationPanel)((Object)fileEditor.getUserData(this.getKey()));
        NotificationPanel.Type newPanelType = this.notificationPanelType();
        return oldPanel != null && oldPanel.type == newPanelType ? oldPanel : newPanelType.create(this.myProject);
    }

    @VisibleForTesting
    @NotNull
    NotificationPanel.Type notificationPanelType() {
        if (!this.myProjectInfo.isBuildWithGradle()) {
            return NotificationPanel.Type.NONE;
        }
        if (!this.mySyncState.areSyncNotificationsEnabled()) {
            return NotificationPanel.Type.NONE;
        }
        if (this.mySyncState.isSyncInProgress()) {
            return NotificationPanel.Type.IN_PROGRESS;
        }
        if (this.mySyncState.lastSyncFailed()) {
            return NotificationPanel.Type.FAILED;
        }
        if (this.mySyncState.getSummary().hasSyncErrors()) {
            return NotificationPanel.Type.ERRORS;
        }
        ThreeState gradleSyncNeeded = this.mySyncState.isSyncNeeded();
        if (gradleSyncNeeded == ThreeState.YES) {
            return NotificationPanel.Type.SYNC_NEEDED;
        }
        return NotificationPanel.Type.NONE;
    }

    private static class SyncProblemNotificationPanel
    extends NotificationPanel {
        SyncProblemNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type, @NotNull String text) {
            super(type, text);
            this.createActionLabel("Try Again", () -> GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_USER_REQUEST, null));
            this.createActionLabel("Open 'Messages' View", () -> ExternalSystemNotificationManager.getInstance((Project)project).openMessageView(GradleUtil.GRADLE_SYSTEM_ID, NotificationSource.PROJECT_SYNC));
            this.createActionLabel("Show Log in " + ShowFilePathAction.getFileManagerName(), () -> {
                File logFile = new File(PathManager.getLogPath(), "idea.log");
                ShowFilePathAction.openFile((File)logFile);
            });
        }
    }

    private static class StaleGradleModelNotificationPanel
    extends NotificationPanel {
        StaleGradleModelNotificationPanel(@NotNull Project project, @NotNull NotificationPanel.Type type, @NotNull String text) {
            super(type, text);
            this.createActionLabel("Sync Now", () -> GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, GradleSyncStats.Trigger.TRIGGER_USER_REQUEST, null));
        }
    }

    @VisibleForTesting
    static class NotificationPanel
    extends EditorNotificationPanel {
        @NotNull
        private final Type type;

        NotificationPanel(@NotNull Type type, @NotNull String text) {
            this.type = type;
            this.setText(text);
        }

        static enum Type {
            NONE{

                @Override
                @Nullable
                NotificationPanel create(@NotNull Project project) {
                    return null;
                }
            }
            ,
            IN_PROGRESS{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project) {
                    return new NotificationPanel(this, "Gradle project sync in progress...");
                }
            }
            ,
            FAILED{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project) {
                    String text = "Gradle project sync failed. Basic functionality (e.g. editing, debugging) will not work properly.";
                    return new SyncProblemNotificationPanel(project, this, text);
                }
            }
            ,
            ERRORS{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project) {
                    String text = "Gradle project sync completed with some errors. Open the 'Messages' view to see the errors found.";
                    return new SyncProblemNotificationPanel(project, this, text);
                }
            }
            ,
            SYNC_NEEDED{

                @Override
                @NotNull
                NotificationPanel create(@NotNull Project project) {
                    boolean buildFilesModified = GradleFiles.getInstance(project).areExternalBuildFilesModified();
                    String text = (buildFilesModified ? "External build files" : "Gradle files") + " have changed since last project sync. A project sync may be necessary for the IDE to work properly.";
                    return new StaleGradleModelNotificationPanel(project, this, text);
                }
            };


            @Nullable
            abstract NotificationPanel create(@NotNull Project var1);
        }
    }
}

