/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.npw.project;

import com.android.builder.model.SourceProvider;
import com.android.tools.idea.npw.project.AndroidProjectPaths;
import com.android.tools.idea.npw.project.AndroidSourceSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.IdeaSourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class GradleAndroidProjectPaths
implements AndroidProjectPaths {
    @Nullable
    private File myModuleRoot;
    @Nullable
    private File mySrcRoot;
    @Nullable
    private File myTestRoot;
    @Nullable
    private File myResDirectory;
    @Nullable
    private File myAidlRoot;
    @Nullable
    private File myManifestDirectory;

    @Override
    @Nullable
    public File getModuleRoot() {
        return this.myModuleRoot;
    }

    @Nullable
    private static File appendPackageToRoot(@Nullable File root, @Nullable String packageName) {
        if (root == null || packageName == null) {
            return root;
        }
        String packagePath = packageName.replace('.', File.separatorChar);
        return new File(root, packagePath);
    }

    @Override
    @Nullable
    public File getSrcDirectory(@Nullable String packageName) {
        return GradleAndroidProjectPaths.appendPackageToRoot(this.mySrcRoot, packageName);
    }

    @Override
    @Nullable
    public File getTestDirectory(@Nullable String packageName) {
        return GradleAndroidProjectPaths.appendPackageToRoot(this.myTestRoot, packageName);
    }

    @Override
    @Nullable
    public File getResDirectory() {
        return this.myResDirectory;
    }

    @Override
    @Nullable
    public File getAidlDirectory(@Nullable String packageName) {
        return GradleAndroidProjectPaths.appendPackageToRoot(this.myAidlRoot, packageName);
    }

    @Override
    @Nullable
    public File getManifestDirectory() {
        return this.myManifestDirectory;
    }

    public static AndroidSourceSet createDummySourceSet() {
        return GradleAndroidProjectPaths.createDefaultSourceSetAt(new File(""));
    }

    public static AndroidSourceSet createDefaultSourceSetAt(@NotNull File moduleRoot) {
        File baseSrcDir = new File(moduleRoot, "src");
        File baseFlavourDir = new File(baseSrcDir, "main");
        GradleAndroidProjectPaths paths = new GradleAndroidProjectPaths();
        paths.myModuleRoot = moduleRoot;
        paths.mySrcRoot = new File(baseFlavourDir, "java");
        paths.myTestRoot = new File(baseSrcDir.getPath(), "androidTest" + File.separatorChar + "java");
        paths.myResDirectory = new File(baseFlavourDir, "res");
        paths.myAidlRoot = new File(baseFlavourDir, "aidl");
        paths.myManifestDirectory = baseFlavourDir;
        return new AndroidSourceSet("main", paths);
    }

    @NotNull
    private static List<SourceProvider> getSourceProviders(@NotNull AndroidFacet androidFacet, @Nullable VirtualFile targetDirectory) {
        if (targetDirectory != null) {
            return IdeaSourceProvider.getSourceProvidersForFile(androidFacet, targetDirectory, androidFacet.getMainSourceProvider());
        }
        return IdeaSourceProvider.getAllSourceProviders(androidFacet);
    }

    @NotNull
    public static List<AndroidSourceSet> getSourceSets(@NotNull AndroidFacet androidFacet, @Nullable VirtualFile targetDirectory) {
        ArrayList sourceSets = Lists.newArrayList();
        Module module = androidFacet.getModule();
        for (SourceProvider sourceProvider : GradleAndroidProjectPaths.getSourceProviders(androidFacet, targetDirectory)) {
            GradleAndroidProjectPaths paths = new GradleAndroidProjectPaths();
            VirtualFile[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            if (roots.length > 0) {
                paths.myModuleRoot = VfsUtilCore.virtualToIoFile((VirtualFile)roots[0]);
            }
            paths.mySrcRoot = (File)Iterables.getFirst((Iterable)sourceProvider.getJavaDirectories(), null);
            List testsRoot = ModuleRootManager.getInstance((Module)module).getSourceRoots(JavaModuleSourceRootTypes.TESTS);
            if (!testsRoot.isEmpty()) {
                paths.myTestRoot = VfsUtilCore.virtualToIoFile((VirtualFile)((VirtualFile)testsRoot.get(0)));
            }
            paths.myResDirectory = (File)Iterables.getFirst((Iterable)sourceProvider.getResDirectories(), null);
            paths.myAidlRoot = (File)Iterables.getFirst((Iterable)sourceProvider.getAidlDirectories(), null);
            paths.myManifestDirectory = sourceProvider.getManifestFile().getParentFile();
            sourceSets.add(new AndroidSourceSet(sourceProvider.getName(), paths));
        }
        return sourceSets;
    }
}

