/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.parser;

import com.android.tools.idea.gradle.parser.BuildFileStatement;
import com.android.tools.idea.gradle.parser.GradleGroovyFile;
import com.android.tools.idea.gradle.parser.UnparseableStatement;
import com.android.tools.idea.gradle.parser.ValueFactory;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public abstract class BuildFileStatementFactory
extends ValueFactory<BuildFileStatement> {
    @Override
    public void setValues(@NotNull GrStatementOwner closure, @NotNull List<BuildFileStatement> statements, @Nullable ValueFactory.KeyFilter filter) {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)closure.getProject());
        closure = (GrStatementOwner)closure.replace((PsiElement)factory.createClosureFromText("{\n}"));
        for (BuildFileStatement statement : statements) {
            PsiElement lastElement = null;
            for (PsiElement element : statement.getGroovyElements(factory)) {
                closure.addBefore(element, closure.getLastChild());
                lastElement = element;
            }
            if (lastElement == null || lastElement.getText().endsWith("\n")) continue;
            closure.addBefore(factory.createLineTerminator("\n"), closure.getLastChild());
        }
        GradleGroovyFile.reformatClosure(closure);
    }

    @Override
    protected void setValue(@NotNull GrStatementOwner closure, @NotNull BuildFileStatement value, @Nullable ValueFactory.KeyFilter filter) {
    }

    @NotNull
    protected static List<BuildFileStatement> getUnparseableStatements(@NotNull PsiElement element) {
        if (element instanceof PsiComment || element instanceof GrStatement) {
            return ImmutableList.of((Object)new UnparseableStatement(element));
        }
        return Collections.emptyList();
    }
}

