/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.parser;

import com.android.tools.idea.gradle.parser.BuildFileKey;
import com.android.tools.idea.gradle.parser.BuildFileStatement;
import com.android.tools.idea.gradle.parser.Dependency;
import com.android.tools.idea.gradle.parser.GradleGroovyFile;
import com.android.tools.idea.gradle.parser.UnparseableStatement;
import com.android.tools.idea.gradle.parser.ValueFactory;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;

public class GradleBuildFile
extends GradleGroovyFile {
    public static final Object UNRECOGNIZED_VALUE = "Unrecognized value";

    @Nullable
    public static GradleBuildFile get(@NotNull Module module) {
        VirtualFile file = GradleUtil.getGradleBuildFile(module);
        return file != null ? new GradleBuildFile(file, module.getProject()) : null;
    }

    public GradleBuildFile(@NotNull VirtualFile buildFile, @NotNull Project project) {
        super(buildFile, project);
    }

    @Deprecated
    @NotNull
    public List<BuildFileStatement> getDependencies() {
        Object dependencies2 = this.getValue(BuildFileKey.DEPENDENCIES);
        if (dependencies2 == null) {
            return Collections.emptyList();
        }
        assert (dependencies2 instanceof List);
        return (List)dependencies2;
    }

    @Nullable
    public Object getValue(@NotNull BuildFileKey key) {
        this.checkInitialized();
        return this.getValue((GrStatementOwner)this.myGroovyFile, key);
    }

    @Nullable
    public Object getValue(@Nullable GrStatementOwner root, @NotNull BuildFileKey key) {
        this.checkInitialized();
        if (root == null) {
            root = this.myGroovyFile;
        }
        return GradleBuildFile.getValueStatic(root, key);
    }

    @Nullable
    public GrStatementOwner getClosure(String path) {
        this.checkInitialized();
        GrMethodCall method = GradleBuildFile.getMethodCallByPath((GrStatementOwner)this.myGroovyFile, path);
        if (method == null) {
            return null;
        }
        return GradleBuildFile.getMethodClosureArgument(method);
    }

    public void setValue(@NotNull BuildFileKey key, @NotNull Object value) {
        this.checkInitialized();
        this.commitDocumentChanges();
        this.setValue((GrStatementOwner)this.myGroovyFile, key, value, null);
    }

    public void setValue(@Nullable GrStatementOwner root, @NotNull BuildFileKey key, @NotNull Object value) {
        this.checkInitialized();
        this.commitDocumentChanges();
        this.setValue(root, key, value, null);
    }

    public void setValue(@NotNull BuildFileKey key, @NotNull Object value, @Nullable ValueFactory.KeyFilter filter) {
        this.checkInitialized();
        this.commitDocumentChanges();
        this.setValue((GrStatementOwner)this.myGroovyFile, key, value, filter);
    }

    public void setValue(@Nullable GrStatementOwner root, @NotNull BuildFileKey key, @NotNull Object value, @Nullable ValueFactory.KeyFilter filter) {
        this.checkInitialized();
        this.commitDocumentChanges();
        if (root == null) {
            root = this.myGroovyFile;
        }
        GradleBuildFile.setValueStatic(root, key, value, true, filter);
    }

    public boolean removeValue(@Nullable GrStatementOwner root, @NotNull BuildFileKey key) {
        GrMethodCall method;
        this.checkInitialized();
        this.commitDocumentChanges();
        if (root == null) {
            root = this.myGroovyFile;
        }
        if ((method = GradleBuildFile.getMethodCallByPath(root, key.getPath())) != null) {
            GrStatementOwner parent = (GrStatementOwner)method.getParent();
            parent.removeElements(new PsiElement[]{method});
            GradleBuildFile.reformatClosure(parent);
            return true;
        }
        return false;
    }

    public boolean hasDependency(@NotNull BuildFileStatement statement) {
        List currentDeps = (List)this.getValue(BuildFileKey.DEPENDENCIES);
        if (currentDeps == null) {
            return false;
        }
        return GradleBuildFile.hasDependency(currentDeps, statement);
    }

    public static boolean hasDependency(@NotNull List<BuildFileStatement> currentDeps, @NotNull BuildFileStatement statement) {
        if (currentDeps.contains(statement)) {
            return true;
        }
        if (!(statement instanceof Dependency)) {
            return false;
        }
        for (BuildFileStatement currentStatement : currentDeps) {
            if (!(currentStatement instanceof Dependency) || !((Dependency)currentStatement).matches((Dependency)statement)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<String> getPlugins(GroovyFile buildScript) {
        ArrayList plugins = Lists.newArrayListWithExpectedSize((int)1);
        for (GrMethodCall methodCall : GradleBuildFile.getMethodCalls((GrStatementOwner)buildScript, "apply")) {
            Map<String, Object> values = GradleBuildFile.getNamedArgumentValues(methodCall);
            Object plugin = values.get("plugin");
            if (plugin == null) continue;
            plugins.add(plugin.toString());
        }
        return plugins;
    }

    @NotNull
    public List<String> getPlugins() {
        return GradleBuildFile.getPlugins(this.myGroovyFile);
    }

    public boolean hasAndroidPlugin() {
        List<String> plugins = this.getPlugins();
        return plugins.contains("com.android.application") || plugins.contains("android") || plugins.contains("com.android.library") || plugins.contains("android-library");
    }

    public static boolean shouldWriteValue(@Nullable Object currentValue, @Nullable Object newValue) {
        if (Objects.equal((Object)currentValue, (Object)newValue)) {
            return false;
        }
        if (!(currentValue instanceof List) || !(newValue instanceof List)) {
            return true;
        }
        List currentList = (List)currentValue;
        List newList = (List)newValue;
        if (currentList.size() != newList.size()) {
            return true;
        }
        for (int i = 0; i < currentList.size(); ++i) {
            Object newObj;
            Object currentObj = currentList.get(i);
            if (currentObj.equals(newObj = newList.get(i)) || currentObj instanceof UnparseableStatement && newObj instanceof UnparseableStatement) continue;
            return true;
        }
        return false;
    }
}

