/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.plugin;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.MavenRepositories;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleValue;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.EmbeddedDistributionPaths;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.android.AndroidPlugin;
import org.jetbrains.annotations.NotNull;

public abstract class AndroidPluginGeneration {
    public static final AndroidPluginGeneration ORIGINAL = new AndroidPluginGeneration(){

        @Override
        @NotNull
        public String getArtifactId() {
            return "gradle";
        }

        @Override
        @NotNull
        protected String getApplicationPluginId() {
            return "com.android.application";
        }

        @Override
        @NotNull
        protected String getLibraryPluginId() {
            return "com.android.library";
        }

        @Override
        @NotNull
        public String getLatestKnownVersion() {
            return this.getLatestKnownVersion(this);
        }

        @Override
        @NotNull
        protected String getRecommendedVersion() {
            return "2.3.2";
        }

        @Override
        @NotNull
        public String getDescription() {
            return "Android Gradle plugin";
        }
    };
    public static final AndroidPluginGeneration COMPONENT = new AndroidPluginGeneration(){

        @Override
        @NotNull
        public String getArtifactId() {
            return "gradle-experimental";
        }

        @Override
        @NotNull
        protected String getApplicationPluginId() {
            return "com.android.model.application";
        }

        @Override
        @NotNull
        protected String getLibraryPluginId() {
            return "com.android.model.library";
        }

        @Override
        @NotNull
        public String getLatestKnownVersion() {
            return this.getLatestKnownVersion(this);
        }

        @Override
        @NotNull
        protected String getRecommendedVersion() {
            return "0.9.0";
        }

        @Override
        @NotNull
        public String getDescription() {
            return "Android Gradle \"experimental\" plugin";
        }
    };
    private static AndroidPluginGeneration[] ourValues = new AndroidPluginGeneration[]{ORIGINAL, COMPONENT};

    public boolean isApplicationPluginIdIn(@NotNull Collection<String> pluginIds) {
        return pluginIds.contains(this.getApplicationPluginId());
    }

    @NotNull
    protected abstract String getApplicationPluginId();

    protected abstract String getLibraryPluginId();

    public boolean isAndroidPlugin(@NotNull String artifactId, String groupId) {
        return this.getArtifactId().equals(artifactId) && AndroidPluginGeneration.getGroupId().equals(groupId);
    }

    @NotNull
    public abstract String getArtifactId();

    public static AndroidPluginGeneration find(@NotNull String artifactId, String groupId) {
        for (AndroidPluginGeneration generation : ourValues) {
            if (!generation.isAndroidPlugin(artifactId, groupId)) continue;
            return generation;
        }
        return null;
    }

    @NotNull
    public static String getGroupId() {
        return "com.android.tools.build";
    }

    @NotNull
    public static AndroidPluginGeneration[] values() {
        return ourValues;
    }

    public static AndroidPluginGeneration find(@NotNull Module module) {
        GradleBuildModel buildModel;
        AndroidModuleModel gradleModel = AndroidModuleModel.get(module);
        if (gradleModel != null) {
            try {
                return gradleModel.getAndroidProject().getPluginGeneration() == 2 ? COMPONENT : ORIGINAL;
            }
            catch (UnsupportedMethodException unsupportedMethodException) {
                // empty catch block
            }
        }
        if ((buildModel = GradleBuildModel.get(module)) != null) {
            List<String> appliedPlugins = GradleValue.getValues(buildModel.appliedPlugins());
            for (AndroidPluginGeneration generation : ourValues) {
                if (!appliedPlugins.contains(generation.getApplicationPluginId()) && !appliedPlugins.contains(generation.getLibraryPluginId())) continue;
                return generation;
            }
        }
        return null;
    }

    @NotNull
    public abstract String getLatestKnownVersion();

    @NotNull
    protected String getLatestKnownVersion(@NotNull AndroidPluginGeneration generation) {
        String artifactId = generation.getArtifactId();
        FileOp fileOp = FileOpUtils.create();
        List<File> repoPaths = EmbeddedDistributionPaths.getInstance().findAndroidStudioLocalMavenRepoPaths();
        Optional<GradleCoordinate> highestValueCoordinate = repoPaths.stream().map(repoPath -> MavenRepositories.getHighestInstalledVersion((String)AndroidPluginGeneration.getGroupId(), (String)artifactId, (File)repoPath, null, (boolean)true, (FileOp)fileOp)).filter(Objects::nonNull).max(GradleCoordinate.COMPARE_PLUS_HIGHER);
        if (!highestValueCoordinate.isPresent()) {
            if (IdeInfo.getInstance().isAndroidStudio() && !AndroidPlugin.isGuiTestingMode() && !ApplicationManager.getApplication().isInternal() && !ApplicationManager.getApplication().isUnitTestMode()) {
                throw new IllegalStateException("Gradle plugin missing from the offline Maven repo");
            }
            String version = generation.getRecommendedVersion();
            this.getLog().info("'" + artifactId + "' plugin missing from the offline Maven repo, will use default " + version);
            return version;
        }
        return highestValueCoordinate.get().getRevision();
    }

    @NotNull
    protected abstract String getRecommendedVersion();

    @NotNull
    private Logger getLog() {
        return Logger.getInstance(this.getClass());
    }

    @NotNull
    public abstract String getDescription();
}

