/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.plugin;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.model.values.GradleValue;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.util.BuildFileProcessor;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPluginInfo {
    @NotNull
    private final Module myModule;
    @NotNull
    private final AndroidPluginGeneration myPluginGeneration;
    @Nullable
    private final GradleVersion myPluginVersion;
    @Nullable
    private final VirtualFile myPluginBuildFile;

    @Nullable
    public static AndroidPluginInfo find(@NotNull Project project) {
        return AndroidPluginInfo.find(project, false);
    }

    @Nullable
    public static AndroidPluginInfo searchInBuildFilesOnly(@NotNull Project project) {
        return AndroidPluginInfo.find(project, true);
    }

    @Nullable
    private static AndroidPluginInfo find(@NotNull Project project, boolean searchInBuildFilesOnly) {
        boolean pluginVersionFound;
        Module appModule = null;
        AndroidModuleModel appGradleModel = null;
        VirtualFile pluginBuildFile = null;
        if (!searchInBuildFilesOnly) {
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                AndroidModuleModel gradleModel = AndroidModuleModel.get(module);
                if (gradleModel == null || gradleModel.getAndroidProject().getProjectType() != 0) continue;
                appModule = module;
                appGradleModel = gradleModel;
                break;
            }
        }
        GradleVersion pluginVersion = appGradleModel != null ? appGradleModel.getModelVersion() : null;
        AndroidPluginGeneration pluginGeneration = null;
        if (appModule != null && (pluginGeneration = AndroidPluginGeneration.find(appModule)) == AndroidPluginGeneration.COMPONENT) {
            pluginVersion = null;
        }
        boolean appModuleFound = appModule != null;
        boolean bl = pluginVersionFound = pluginVersion != null;
        if (!appModuleFound || !pluginVersionFound) {
            BuildFileSearchResult result = AndroidPluginInfo.searchInBuildFiles(project, !appModuleFound);
            if (result.appVirtualFile != null) {
                appModule = ModuleUtilCore.findModuleForFile((VirtualFile)result.appVirtualFile, (Project)project);
            }
            if (StringUtil.isNotEmpty((String)result.pluginVersion)) {
                pluginVersion = GradleVersion.tryParse((String)result.pluginVersion);
            }
            if (pluginGeneration == null) {
                pluginGeneration = result.pluginGeneration;
            }
            pluginBuildFile = result.pluginVirtualFile;
        }
        if (appModule != null && pluginGeneration != null) {
            return new AndroidPluginInfo(appModule, pluginGeneration, pluginVersion, pluginBuildFile);
        }
        return null;
    }

    @NotNull
    private static BuildFileSearchResult searchInBuildFiles(@NotNull Project project, boolean searchForAppModule) {
        BuildFileSearchResult result = new BuildFileSearchResult();
        BuildFileProcessor.getInstance().processRecursively(project, (Processor<GradleBuildModel>)((Processor)buildModel -> {
            boolean keepSearchingForPluginVersion;
            boolean keepSearchingForAppModule;
            boolean bl = keepSearchingForAppModule = searchForAppModule && result.appVirtualFile == null;
            if (keepSearchingForAppModule) {
                List<String> pluginIds = GradleValue.getValues(buildModel.appliedPlugins());
                for (AndroidPluginGeneration generation : AndroidPluginGeneration.values()) {
                    if (!generation.isApplicationPluginIdIn(pluginIds)) continue;
                    result.appVirtualFile = buildModel.getVirtualFile();
                    result.pluginGeneration = generation;
                    keepSearchingForAppModule = false;
                    break;
                }
            }
            boolean bl2 = keepSearchingForPluginVersion = result.pluginVersion == null;
            if (keepSearchingForPluginVersion) {
                DependenciesModel dependencies2 = buildModel.buildscript().dependencies();
                for (ArtifactDependencyModel dependency : dependencies2.artifacts("classpath")) {
                    for (AndroidPluginGeneration generation : AndroidPluginGeneration.values()) {
                        if (!generation.isAndroidPlugin(dependency.name().value(), (String)dependency.group().value())) continue;
                        String version = (String)dependency.version().value();
                        if (StringUtil.isNotEmpty((String)version)) {
                            result.pluginVirtualFile = buildModel.getVirtualFile();
                            result.pluginVersion = version;
                        }
                        keepSearchingForPluginVersion = false;
                        break;
                    }
                    if (keepSearchingForPluginVersion) continue;
                    break;
                }
            }
            return keepSearchingForAppModule || keepSearchingForPluginVersion;
        }));
        return result;
    }

    @VisibleForTesting
    public AndroidPluginInfo(@NotNull Module module, @NotNull AndroidPluginGeneration pluginGeneration, @Nullable GradleVersion pluginVersion, @Nullable VirtualFile pluginBuildFile) {
        this.myModule = module;
        this.myPluginGeneration = pluginGeneration;
        this.myPluginVersion = pluginVersion;
        this.myPluginBuildFile = pluginBuildFile;
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public AndroidPluginGeneration getPluginGeneration() {
        return this.myPluginGeneration;
    }

    @Nullable
    public GradleVersion getPluginVersion() {
        return this.myPluginVersion;
    }

    @Nullable
    public VirtualFile getPluginBuildFile() {
        return this.myPluginBuildFile;
    }

    public boolean isExperimental() {
        return this.getPluginGeneration() == AndroidPluginGeneration.COMPONENT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidPluginInfo that = (AndroidPluginInfo)o;
        return Objects.equals(this.myModule, that.myModule) && Objects.equals(this.myPluginGeneration, that.myPluginGeneration) && Objects.equals(this.myPluginVersion, that.myPluginVersion) && Objects.equals(this.myPluginBuildFile, that.myPluginBuildFile);
    }

    public int hashCode() {
        return Objects.hash(this.myModule, this.myPluginGeneration, this.myPluginVersion, this.myPluginBuildFile);
    }

    private static class BuildFileSearchResult {
        @Nullable
        VirtualFile appVirtualFile;
        @Nullable
        VirtualFile pluginVirtualFile;
        @Nullable
        AndroidPluginGeneration pluginGeneration;
        @Nullable
        String pluginVersion;

        private BuildFileSearchResult() {
        }
    }
}

