/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.plugin;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.plugin.AndroidPluginGeneration;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.hyperlink.SearchInBuildFilesHyperlink;
import com.android.tools.idea.gradle.util.BuildFileProcessor;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPluginVersionUpdater {
    @NotNull
    private final Project myProject;
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final GradleSyncInvoker mySyncInvoker;
    @NotNull
    private final TextSearch myTextSearch;

    @NotNull
    public static AndroidPluginVersionUpdater getInstance(@NotNull Project project) {
        return (AndroidPluginVersionUpdater)ServiceManager.getService((Project)project, AndroidPluginVersionUpdater.class);
    }

    public AndroidPluginVersionUpdater(@NotNull Project project, @NotNull GradleSyncState syncState) {
        this(project, syncState, GradleSyncInvoker.getInstance(), new TextSearch(project));
    }

    @VisibleForTesting
    AndroidPluginVersionUpdater(@NotNull Project project, @NotNull GradleSyncState syncState, @NotNull GradleSyncInvoker syncInvoker, @NotNull TextSearch textSearch) {
        this.myProject = project;
        this.mySyncState = syncState;
        this.mySyncInvoker = syncInvoker;
        this.myTextSearch = textSearch;
    }

    public UpdateResult updatePluginVersionAndSync(@NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion, boolean invalidateLastSyncOnFailure) {
        String msg;
        UpdateResult result = this.updatePluginVersion(pluginVersion, gradleVersion);
        Throwable pluginVersionUpdateError = result.getPluginVersionUpdateError();
        Throwable gradleVersionUpdateError = result.getGradleVersionUpdateError();
        if (pluginVersionUpdateError != null) {
            msg = String.format("Failed to update Android plugin to version '%1$s'", pluginVersion);
            AndroidPluginVersionUpdater.logUpdateError(msg, pluginVersionUpdateError);
        }
        if (gradleVersionUpdateError != null) {
            msg = String.format("Failed to update Gradle to version '%1$s'", gradleVersion);
            AndroidPluginVersionUpdater.logUpdateError(msg, gradleVersionUpdateError);
        }
        this.handleUpdateResult(result, invalidateLastSyncOnFailure);
        return result;
    }

    @VisibleForTesting
    void handleUpdateResult(@NotNull UpdateResult result, boolean invalidateLastSyncOnFailure) {
        Throwable pluginVersionUpdateError = result.getPluginVersionUpdateError();
        if (pluginVersionUpdateError != null || result.getGradleVersionUpdateError() != null) {
            if (invalidateLastSyncOnFailure) {
                this.mySyncState.invalidateLastSync("Failed to update either Android plugin version or Gradle version");
            }
            if (pluginVersionUpdateError != null) {
                this.myTextSearch.execute();
            }
        } else if (result.isPluginVersionUpdated() || result.isGradleVersionUpdated()) {
            if (!this.mySyncState.lastSyncFailedOrHasIssues()) {
                this.mySyncState.syncEnded();
            }
            GradleSyncInvoker.Request request = new GradleSyncInvoker.Request().setCleanProject().setTrigger(GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED);
            this.mySyncInvoker.requestProjectSync(this.myProject, request, null);
        }
    }

    private static void logUpdateError(@NotNull String msg, @NotNull Throwable error) {
        String cause = error.getMessage();
        if (StringUtil.isNotEmpty((String)cause)) {
            msg = msg + ": " + cause;
        }
        Logger.getInstance(AndroidPluginVersionUpdater.class).warn(msg);
    }

    @NotNull
    public UpdateResult updatePluginVersion(@NotNull GradleVersion pluginVersion, @Nullable GradleVersion gradleVersion) {
        String basePath;
        boolean updateModels;
        ArrayList modelsToUpdate = Lists.newArrayList();
        BuildFileProcessor.getInstance().processRecursively(this.myProject, (Processor<GradleBuildModel>)((Processor)buildModel -> {
            DependenciesModel dependencies2 = buildModel.buildscript().dependencies();
            for (ArtifactDependencyModel dependency : dependencies2.artifacts("classpath")) {
                String groupId;
                String artifactId = dependency.name().value();
                if (AndroidPluginGeneration.find(artifactId, groupId = (String)dependency.group().value()) == null) continue;
                String versionValue = (String)dependency.version().value();
                if (!StringUtil.isEmpty((String)versionValue) && pluginVersion.compareTo(versionValue) == 0) break;
                dependency.setVersion(pluginVersion.toString());
                modelsToUpdate.add(buildModel);
                break;
            }
            return true;
        }));
        UpdateResult result = new UpdateResult();
        boolean bl = updateModels = !modelsToUpdate.isEmpty();
        if (updateModels) {
            try {
                WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> {
                    for (GradleBuildModel buildModel : modelsToUpdate) {
                        buildModel.applyChanges();
                    }
                    result.pluginVersionUpdated();
                    return null;
                });
            }
            catch (Throwable e) {
                result.setPluginVersionUpdateError(e);
            }
        }
        if (gradleVersion != null && (basePath = this.myProject.getBasePath()) != null) {
            try {
                File wrapperPropertiesFilePath = GradleWrapper.getDefaultPropertiesFilePath(new File(basePath));
                GradleWrapper gradleWrapper = GradleWrapper.get(wrapperPropertiesFilePath);
                String current = gradleWrapper.getGradleVersion();
                GradleVersion parsedCurrent = null;
                if (current != null) {
                    parsedCurrent = GradleVersion.tryParse((String)current);
                }
                if (parsedCurrent != null && !GradleUtil.isSupportedGradleVersion(parsedCurrent)) {
                    gradleWrapper.updateDistributionUrl(gradleVersion.toString());
                    result.gradleVersionUpdated();
                }
            }
            catch (Throwable e) {
                result.setGradleVersionUpdateError(e);
            }
        }
        return result;
    }

    @VisibleForTesting
    static class TextSearch {
        @NotNull
        private final Project myProject;

        TextSearch(@NotNull Project project) {
            this.myProject = project;
        }

        void execute() {
            String msg = "Failed to update the version of the Android Gradle plugin.\n\nPlease click 'OK' to perform a textual search and then update the build files manually.";
            Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)"Unexpected Error");
            String textToFind = AndroidPluginGeneration.getGroupId() + ":" + AndroidPluginGeneration.ORIGINAL.getArtifactId();
            SearchInBuildFilesHyperlink.searchInBuildFiles(textToFind, this.myProject);
        }
    }

    public static class UpdateResult {
        @Nullable
        private Throwable myPluginVersionUpdateError;
        @Nullable
        private Throwable myGradleVersionUpdateError;
        private boolean myPluginVersionUpdated;
        private boolean myGradleVersionUpdated;

        @VisibleForTesting
        public UpdateResult() {
        }

        @Nullable
        public Throwable getPluginVersionUpdateError() {
            return this.myPluginVersionUpdateError;
        }

        void setPluginVersionUpdateError(@NotNull Throwable error) {
            this.myPluginVersionUpdateError = error;
        }

        @Nullable
        public Throwable getGradleVersionUpdateError() {
            return this.myGradleVersionUpdateError;
        }

        void setGradleVersionUpdateError(@NotNull Throwable error) {
            this.myGradleVersionUpdateError = error;
        }

        public boolean isPluginVersionUpdated() {
            return this.myPluginVersionUpdated;
        }

        void pluginVersionUpdated() {
            this.myPluginVersionUpdated = true;
        }

        public boolean isGradleVersionUpdated() {
            return this.myGradleVersionUpdated;
        }

        void gradleVersionUpdated() {
            this.myGradleVersionUpdated = true;
        }

        public boolean versionUpdateSuccess() {
            return (this.myPluginVersionUpdated || this.myGradleVersionUpdated) && this.myPluginVersionUpdateError == null && this.myGradleVersionUpdateError == null;
        }
    }
}

