/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.dependencies.GradleDependencyManager;
import com.android.tools.idea.gradle.npw.project.GradleAndroidProjectPaths;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.build.GradleProjectBuilder;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.variant.view.BuildVariantView;
import com.android.tools.idea.npw.project.AndroidSourceSet;
import com.android.tools.idea.project.BuildSystemService;
import com.android.tools.idea.templates.GradleFilePsiMerger;
import com.android.tools.idea.templates.GradleFileSimpleMerger;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleBuildSystemService
extends BuildSystemService {
    @Override
    public boolean isApplicable(@NotNull Project project) {
        return GradleProjectInfo.getInstance(project).isBuildWithGradle();
    }

    @Override
    public void buildProject(@NotNull Project project) {
        GradleProjectBuilder.getInstance(project).compileJava();
    }

    @Override
    public void syncProject(@NotNull Project project) {
        if (project.isInitialized()) {
            BuildVariantView.getInstance(project).projectImportStarted();
            GradleBuildSystemService.syncAndGenerateSources(project, GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED);
        } else {
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
                if (!GradleProjectInfo.getInstance(project).isNewOrImportedProject()) {
                    GradleBuildSystemService.syncAndGenerateSources(project, GradleSyncStats.Trigger.TRIGGER_PROJECT_LOADED);
                }
            });
        }
    }

    private static void syncAndGenerateSources(@NotNull Project project, GradleSyncStats.Trigger trigger) {
        GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(project, trigger, null);
    }

    @Override
    public void addDependency(@NotNull Module module, @NotNull String artifact) {
        GradleDependencyManager manager = GradleDependencyManager.getInstance(module.getProject());
        GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)(artifact + ":+"));
        manager.ensureLibraryIsIncluded(module, Collections.singletonList(coordinate), null);
    }

    @Override
    public String mergeBuildFiles(@NotNull String dependencies2, @NotNull String destinationContents, @NotNull Project project, @Nullable String supportLibVersionFilter) {
        if (project.isInitialized()) {
            return GradleFilePsiMerger.mergeGradleFiles(dependencies2, destinationContents, project, supportLibVersionFilter);
        }
        return GradleFileSimpleMerger.mergeGradleFiles(dependencies2, destinationContents, project, supportLibVersionFilter);
    }

    @Override
    public List<AndroidSourceSet> getSourceSets(@NotNull AndroidFacet facet, @Nullable VirtualFile targetDirectory) {
        return GradleAndroidProjectPaths.getSourceSets(facet, targetDirectory);
    }
}

