/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.project.build.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.settings.AndroidStudioGradleProjectSettings;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleProjectInfo {
    @NotNull
    private final Project myProject;
    @NotNull
    private final AndroidProjectInfo myProjectInfo;
    @NotNull
    private final AndroidStudioGradleProjectSettings myGradleProjectSettings;
    @NotNull
    private final ProjectFileIndex myProjectFileIndex;
    @NotNull
    private final AtomicReference<String> myProjectCreationErrorRef = new AtomicReference();
    private volatile boolean myIsNewOrImportedProject;

    @NotNull
    public static GradleProjectInfo getInstance(@NotNull Project project) {
        return (GradleProjectInfo)ServiceManager.getService((Project)project, GradleProjectInfo.class);
    }

    public GradleProjectInfo(@NotNull Project project, @NotNull AndroidProjectInfo projectInfo, @NotNull AndroidStudioGradleProjectSettings gradleProjectSettings, @NotNull ProjectFileIndex projectFileIndex) {
        this.myProject = project;
        this.myProjectInfo = projectInfo;
        this.myGradleProjectSettings = gradleProjectSettings;
        this.myProjectFileIndex = projectFileIndex;
    }

    public boolean canUseLocalMavenRepo() {
        return !this.myGradleProjectSettings.DISABLE_EMBEDDED_MAVEN_REPO;
    }

    public boolean isNewOrImportedProject() {
        return this.myIsNewOrImportedProject;
    }

    public void setNewOrImportedProject(boolean newOrImportedProject) {
        this.myIsNewOrImportedProject = newOrImportedProject;
    }

    @Nullable
    public String getProjectCreationError() {
        return this.myProjectCreationErrorRef.get();
    }

    public void setProjectCreationError(@Nullable String error) {
        this.myProjectCreationErrorRef.set(error);
    }

    public boolean isDirectGradleBuildEnabled() {
        AndroidGradleBuildConfiguration buildConfiguration = AndroidGradleBuildConfiguration.getInstance(this.myProject);
        return buildConfiguration.USE_EXPERIMENTAL_FASTER_BUILD;
    }

    public boolean isBuildWithGradle() {
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
            for (Module module : moduleManager.getModules()) {
                if (!GradleFacet.isAppliedTo(module)) continue;
                return true;
            }
            if (GradleSyncState.getInstance(this.myProject).getSummary().getSyncTimestamp() != -1L) {
                return true;
            }
            return this.hasTopLevelGradleBuildFile();
        });
    }

    public boolean hasTopLevelGradleBuildFile() {
        if (this.myProject.isDefault()) {
            return false;
        }
        File projectFolderPath = Projects.getBaseDirPath(this.myProject);
        File buildFilePath = new File(projectFolderPath, "build.gradle");
        return buildFilePath.isFile();
    }

    @NotNull
    public List<Module> getAndroidModules() {
        ImmutableList.Builder modules = ImmutableList.builder();
        ReadAction.run(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                if (AndroidFacet.getInstance(module) == null || GradleFacet.getInstance(module) == null) continue;
                modules.add((Object)module);
            }
        });
        return modules.build();
    }

    public void forEachAndroidModule(@NotNull Consumer<AndroidFacet> consumer) {
        ReadAction.run(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                AndroidFacet androidFacet = AndroidFacet.getInstance(module);
                if (androidFacet == null || GradleFacet.getInstance(module) == null) continue;
                consumer.consume((Object)androidFacet);
            }
        });
    }

    @Nullable
    public AndroidModuleModel findAndroidModelInModule(@NotNull VirtualFile file) {
        return this.findAndroidModelInModule(file, true);
    }

    @Nullable
    public AndroidModuleModel findAndroidModelInModule(@NotNull VirtualFile file, boolean honorExclusion) {
        Module module = this.findModuleForFile(file, honorExclusion);
        if (module == null) {
            VirtualFile rootFolder;
            if (this.myProjectInfo.requiresAndroidModel() && (rootFolder = this.myProject.getBaseDir()) != null) {
                for (VirtualFile parent = file.getParent(); parent != null && parent.equals(rootFolder) && (module = this.findModuleForFile(file, honorExclusion)) == null; parent = parent.getParent()) {
                }
            }
            if (module == null) {
                return null;
            }
        }
        if (module.isDisposed()) {
            this.getLog().warn("Attempted to get an Android Facet from a disposed module");
            return null;
        }
        return AndroidModuleModel.get(module);
    }

    @Nullable
    private Module findModuleForFile(@NotNull VirtualFile file, boolean honorExclusion) {
        return this.myProjectFileIndex.getModuleForFile(file, honorExclusion);
    }

    @NotNull
    private Logger getLog() {
        return Logger.getInstance(this.getClass());
    }
}

