/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.build.BuildContext;
import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.BuildSummary;
import com.android.tools.idea.gradle.project.build.GradleBuildListener;
import com.android.tools.idea.project.IndexingSuspender;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import javax.annotation.concurrent.GuardedBy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleBuildState {
    @VisibleForTesting
    static final Topic<GradleBuildListener> GRADLE_BUILD_TOPIC = new Topic("Gradle build", GradleBuildListener.class);
    private static final int INDEXING_WAIT_TIMEOUT_MILLIS = 10000;
    @NotNull
    private final Project myProject;
    @NotNull
    private final MessageBus myMessageBus;
    @NotNull
    private final Object myLock = new Object();
    @NotNull
    private final Object myIndexingLock = new Object();
    private boolean myFlagIsIndexingAware = StudioFlags.GRADLE_INVOCATIONS_INDEXING_AWARE.get();
    @GuardedBy(value="myLock")
    @Nullable
    private BuildContext myCurrentContext;
    @GuardedBy(value="myLock")
    @Nullable
    private BuildSummary mySummary;

    @NotNull
    public static MessageBusConnection subscribe(@NotNull Project project, @NotNull GradleBuildListener listener) {
        return GradleBuildState.subscribe(project, listener, (Disposable)project);
    }

    @NotNull
    public static MessageBusConnection subscribe(@NotNull Project project, @NotNull GradleBuildListener listener, @NotNull Disposable parentDisposable) {
        MessageBusConnection connection = project.getMessageBus().connect(parentDisposable);
        connection.subscribe(GRADLE_BUILD_TOPIC, (Object)listener);
        return connection;
    }

    @NotNull
    public static GradleBuildState getInstance(@NotNull Project project) {
        return (GradleBuildState)ServiceManager.getService((Project)project, GradleBuildState.class);
    }

    public GradleBuildState(@NotNull Project project, @NotNull MessageBus messageBus) {
        this.myProject = project;
        this.myMessageBus = messageBus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildStarted(@NotNull BuildContext context) {
        Object object = this.myLock;
        synchronized (object) {
            this.myCurrentContext = context;
            this.myFlagIsIndexingAware = StudioFlags.GRADLE_INVOCATIONS_INDEXING_AWARE.get();
            this.ensureNoIndexingDuringBuild();
        }
        this.syncPublisher((Consumer<GradleBuildListener>)((Consumer)listener -> listener.buildStarted(context)));
    }

    private void ensureNoIndexingDuringBuild() {
        if (this.myFlagIsIndexingAware) {
            IndexingSuspender.queue(this.myProject, "Gradle Build", this.myIndexingLock, this::isBuildInProgress, 10000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildFinished(@NotNull BuildStatus status) {
        BuildContext context;
        Object object = this.myLock;
        synchronized (object) {
            context = this.myCurrentContext;
            this.myCurrentContext = null;
            this.mySummary = new BuildSummary(status, context);
            if (this.myFlagIsIndexingAware) {
                this.unblockIndexing();
            }
        }
        this.syncPublisher((Consumer<GradleBuildListener>)((Consumer)listener -> listener.buildFinished(status, context)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unblockIndexing() {
        if (this.myFlagIsIndexingAware) {
            Object object = this.myIndexingLock;
            synchronized (object) {
                this.myIndexingLock.notifyAll();
            }
        }
    }

    private void syncPublisher(@NotNull Consumer<GradleBuildListener> consumer) {
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> consumer.consume(this.myMessageBus.syncPublisher(GRADLE_BUILD_TOPIC)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBuildInProgress() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myCurrentContext != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BuildContext getCurrentContext() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myCurrentContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BuildSummary getSummary() {
        Object object = this.myLock;
        synchronized (object) {
            return this.mySummary;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Object object = this.myLock;
        synchronized (object) {
            this.myCurrentContext = null;
            this.mySummary = null;
        }
    }
}

