/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build;

import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.GradleExperimentalSettings;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class GradleProjectBuilder {
    @NotNull
    private final Project myProject;
    @NotNull
    private final AndroidProjectInfo myAndroidProjectInfo;
    @NotNull
    private final GradleProjectInfo myGradleProjectInfo;
    @NotNull
    private final BuildSettings myBuildSettings;
    @NotNull
    private final GradleBuildInvoker myBuildInvoker;
    @NotNull
    private final CompilerManager myCompilerManager;

    @NotNull
    public static GradleProjectBuilder getInstance(@NotNull Project project) {
        return (GradleProjectBuilder)ServiceManager.getService((Project)project, GradleProjectBuilder.class);
    }

    public GradleProjectBuilder(@NotNull Project project, @NotNull AndroidProjectInfo androidProjectInfo, @NotNull GradleProjectInfo gradleProjectInfo, @NotNull BuildSettings buildSettings, @NotNull GradleBuildInvoker buildInvoker, @NotNull CompilerManager compilerManager) {
        this.myProject = project;
        this.myAndroidProjectInfo = androidProjectInfo;
        this.myGradleProjectInfo = gradleProjectInfo;
        this.myBuildSettings = buildSettings;
        this.myBuildInvoker = buildInvoker;
        this.myCompilerManager = compilerManager;
    }

    public void compileJava() {
        if (this.myAndroidProjectInfo.requiresAndroidModel()) {
            if (this.myGradleProjectInfo.isDirectGradleBuildEnabled()) {
                Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
                this.myBuildInvoker.compileJava(modules, TestCompileType.ALL);
                return;
            }
            this.buildProjectWithJps(BuildMode.COMPILE_JAVA);
        }
    }

    public void clean() {
        if (this.myAndroidProjectInfo.requiresAndroidModel()) {
            if (this.myGradleProjectInfo.isDirectGradleBuildEnabled()) {
                this.myBuildInvoker.cleanProject();
                return;
            }
            this.buildProjectWithJps(BuildMode.CLEAN);
        }
    }

    public void cleanAndGenerateSources() {
        this.doGenerateSources(true);
    }

    public void generateSources() {
        this.doGenerateSources(false);
    }

    private void doGenerateSources(boolean cleanProject) {
        if (!this.isSourceGenerationEnabled()) {
            return;
        }
        if (this.myAndroidProjectInfo.requiresAndroidModel()) {
            if (this.myGradleProjectInfo.isDirectGradleBuildEnabled()) {
                if (cleanProject) {
                    this.myBuildInvoker.cleanAndGenerateSources();
                    return;
                }
                this.myBuildInvoker.generateSources();
                return;
            }
            this.buildProjectWithJps(BuildMode.SOURCE_GEN);
        }
    }

    public boolean isSourceGenerationEnabled() {
        if (this.myAndroidProjectInfo.requiresAndroidModel()) {
            int moduleCount = ModuleManager.getInstance((Project)this.myProject).getModules().length;
            GradleExperimentalSettings settings = GradleExperimentalSettings.getInstance();
            return GradleProjectBuilder.isSourceGenerationEnabled(settings, moduleCount);
        }
        return false;
    }

    @VisibleForTesting
    @Contract(pure=true)
    static boolean isSourceGenerationEnabled(@NotNull GradleExperimentalSettings settings, int moduleCount) {
        return !settings.SKIP_SOURCE_GEN_ON_PROJECT_SYNC || moduleCount <= settings.MAX_MODULE_COUNT_FOR_SOURCE_GEN;
    }

    private void buildProjectWithJps(@NotNull BuildMode buildMode) {
        this.myBuildSettings.setBuildMode(buildMode);
        this.myCompilerManager.make(null);
    }
}

