/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build;

import com.android.ide.common.blame.Message;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.ContentEntries;
import com.android.tools.idea.gradle.util.FilePaths;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.AbstractIterator;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.ThreeState;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class PostProjectBuildTasksExecutor {
    private static final Key<Boolean> UPDATE_JAVA_LANG_LEVEL_AFTER_BUILD = Key.create((String)"android.gradle.project.update.java.lang");
    private static final Key<Long> PROJECT_LAST_BUILD_TIMESTAMP_KEY = Key.create((String)"android.gradle.project.last.build.timestamp");
    @NotNull
    private final Project myProject;

    @NotNull
    public static PostProjectBuildTasksExecutor getInstance(@NotNull Project project) {
        return (PostProjectBuildTasksExecutor)ServiceManager.getService((Project)project, PostProjectBuildTasksExecutor.class);
    }

    public PostProjectBuildTasksExecutor(@NotNull Project project) {
        this.myProject = project;
    }

    public void onBuildCompletion(@NotNull CompileContext context) {
        Object errors = Collections.emptyIterator();
        CompilerMessage[] errorMessages = context.getMessages(CompilerMessageCategory.ERROR);
        if (errorMessages.length > 0) {
            errors = new CompilerMessageIterator(errorMessages);
        }
        this.onBuildCompletion((Iterator<String>)errors, errorMessages.length);
    }

    @Nullable
    public Long getLastBuildTimestamp() {
        return (Long)this.myProject.getUserData(PROJECT_LAST_BUILD_TIMESTAMP_KEY);
    }

    public void onBuildCompletion(@NotNull GradleInvocationResult result) {
        Object errors = Collections.emptyIterator();
        List<Message> errorMessages = result.getCompilerMessages(Message.Kind.ERROR);
        if (!errorMessages.isEmpty()) {
            errors = new MessageIterator(errorMessages);
        }
        this.onBuildCompletion((Iterator<String>)errors, errorMessages.size());
    }

    @VisibleForTesting
    void onBuildCompletion(Iterator<String> errorMessages, int errorCount) {
        if (AndroidProjectInfo.getInstance(this.myProject).requiresAndroidModel()) {
            Projects.executeProjectChanges(this.myProject, this::excludeOutputFolders);
            if (Projects.isOfflineBuildModeEnabled(this.myProject)) {
                while (errorMessages.hasNext()) {
                    String error = errorMessages.next();
                    if (error == null || !PostProjectBuildTasksExecutor.unresolvedDependenciesFound(error)) continue;
                    this.notifyUnresolvedDependenciesInOfflineMode();
                    break;
                }
            }
            this.refreshProject();
            BuildSettings buildSettings = BuildSettings.getInstance(this.myProject);
            BuildMode buildMode = buildSettings.getBuildMode();
            buildSettings.clear();
            this.myProject.putUserData(PROJECT_LAST_BUILD_TIMESTAMP_KEY, (Object)System.currentTimeMillis());
            this.syncJavaLangLevel();
            if (this.isSyncNeeded(buildMode, errorCount)) {
                GradleSyncInvoker.Request request = new GradleSyncInvoker.Request().setGenerateSourcesOnSuccess(false).setTrigger(GradleSyncStats.Trigger.TRIGGER_PROJECT_MODIFIED);
                GradleSyncInvoker.getInstance().requestProjectSync(this.myProject, request, null);
            }
            if (Projects.isSyncRequestedDuringBuild(this.myProject)) {
                Projects.setSyncRequestedDuringBuild(this.myProject, null);
                GradleSyncInvoker.getInstance().requestProjectSyncAndSourceGeneration(this.myProject, GradleSyncStats.Trigger.TRIGGER_USER_REQUEST, null);
            }
        }
    }

    private boolean isSyncNeeded(@Nullable BuildMode buildMode, int errorCount) {
        if (BuildMode.DEFAULT_BUILD_MODE.equals((Object)buildMode) && GradleSyncState.getInstance(this.myProject).lastSyncFailed() && errorCount == 0) {
            return true;
        }
        return !BuildMode.SOURCE_GEN.equals((Object)buildMode) && GradleSyncState.getInstance(this.myProject).isSyncNeeded().equals((Object)ThreeState.YES);
    }

    private void excludeOutputFolders() {
        if (this.myProject.isDisposed()) {
            return;
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        if (this.myProject.isDisposed()) {
            return;
        }
        for (Module module : moduleManager.getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || !facet.requiresAndroidModel()) continue;
            PostProjectBuildTasksExecutor.excludeOutputFolders(facet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void excludeOutputFolders(@NotNull AndroidFacet facet) {
        AndroidModuleModel androidModel = AndroidModuleModel.get(facet);
        if (androidModel == null) {
            return;
        }
        File buildFolderPath = androidModel.getAndroidProject().getBuildFolder();
        if (!buildFolderPath.isDirectory()) {
            return;
        }
        Module module = facet.getModule();
        if (module.getProject().isDisposed()) {
            return;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        ModifiableRootModel rootModel = moduleRootManager.getModifiableModel();
        try {
            ContentEntry[] contentEntries = rootModel.getContentEntries();
            ContentEntry parent = ContentEntries.findParentContentEntry(buildFolderPath, Arrays.stream(contentEntries));
            if (parent == null) {
                rootModel.dispose();
                return;
            }
            List<File> excludedFolderPaths = androidModel.getExcludedFolderPaths();
            for (File folderPath : excludedFolderPaths) {
                parent.addExcludeFolder(FilePaths.pathToIdeaUrl(folderPath));
            }
        }
        finally {
            if (!rootModel.isDisposed()) {
                rootModel.commit();
            }
        }
    }

    private static boolean unresolvedDependenciesFound(@NotNull String errorMessage) {
        return errorMessage.contains("Could not resolve all dependencies");
    }

    private void notifyUnresolvedDependenciesInOfflineMode() {
        NotificationHyperlink disableOfflineModeHyperlink = new NotificationHyperlink("disable.gradle.offline.mode", "Disable offline mode"){

            @Override
            protected void execute(@NotNull Project project) {
                GradleSettings.getInstance((Project)PostProjectBuildTasksExecutor.this.myProject).setOfflineWork(false);
            }
        };
        String title = "Unresolved Dependencies";
        String text = "Unresolved dependencies detected while building project in offline mode. Please disable offline mode and try again.";
        AndroidNotification.getInstance(this.myProject).showBalloon(title, text, NotificationType.ERROR, disableOfflineModeHyperlink);
    }

    private void refreshProject() {
        VirtualFile rootDir;
        String projectPath = this.myProject.getBasePath();
        if (projectPath != null && (rootDir = LocalFileSystem.getInstance().findFileByPath(projectPath)) != null && rootDir.isDirectory()) {
            rootDir.refresh(true, true);
        }
    }

    public void updateJavaLangLevelAfterBuild() {
        this.myProject.putUserData(UPDATE_JAVA_LANG_LEVEL_AFTER_BUILD, (Object)true);
    }

    private void syncJavaLangLevel() {
        Boolean updateJavaLangLevel = (Boolean)this.myProject.getUserData(UPDATE_JAVA_LANG_LEVEL_AFTER_BUILD);
        if (updateJavaLangLevel == null || !updateJavaLangLevel.booleanValue()) {
            return;
        }
        this.myProject.putUserData(UPDATE_JAVA_LANG_LEVEL_AFTER_BUILD, null);
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)true, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)this.myProject){

            public void execute() {
                LanguageLevelProjectExtension ext;
                LanguageLevel langLevel;
                if (PostProjectBuildTasksExecutor.this.myProject.isOpen() && (langLevel = PostProjectBuildTasksExecutor.this.getMaxJavaLangLevel()) != null && langLevel != (ext = LanguageLevelProjectExtension.getInstance((Project)PostProjectBuildTasksExecutor.this.myProject)).getLanguageLevel()) {
                    ext.setLanguageLevel(langLevel);
                }
            }
        });
    }

    @VisibleForTesting
    @Nullable
    LanguageLevel getMaxJavaLangLevel() {
        Module[] modules;
        LanguageLevel maxLangLevel = null;
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            LanguageLevel langLevel;
            AndroidModuleModel androidModel;
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet == null || (androidModel = AndroidModuleModel.get(facet)) == null || (langLevel = androidModel.getJavaLanguageLevel()) == null || maxLangLevel != null && maxLangLevel.compareTo((Enum)langLevel) >= 0) continue;
            maxLangLevel = langLevel;
        }
        return maxLangLevel;
    }

    private static class MessageIterator
    extends AbstractIterator<String> {
        private final Iterator<Message> myIterator;

        MessageIterator(@NotNull Collection<Message> compilerMessages) {
            this.myIterator = compilerMessages.iterator();
        }

        @Nullable
        protected String computeNext() {
            if (!this.myIterator.hasNext()) {
                return (String)this.endOfData();
            }
            Message msg = this.myIterator.next();
            return msg != null ? msg.getText() : null;
        }
    }

    private static class CompilerMessageIterator
    extends AbstractIterator<String> {
        @NotNull
        private final CompilerMessage[] myErrors;
        private int counter;

        CompilerMessageIterator(@NotNull CompilerMessage[] errors) {
            this.myErrors = errors;
        }

        @Nullable
        protected String computeNext() {
            if (this.counter >= this.myErrors.length) {
                return (String)this.endOfData();
            }
            return this.myErrors[this.counter++].getMessage();
        }
    }
}

