/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.compiler;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.build.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.project.build.invoker.GradleTaskFinder;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.execution.configurations.CommandLineTokenizer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.net.HttpConfigurable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class AndroidGradleBuildProcessParametersProvider
extends BuildProcessParametersProvider {
    @NotNull
    private final Project myProject;

    public AndroidGradleBuildProcessParametersProvider(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public List<String> getVMArguments() {
        if (!GradleProjectInfo.getInstance(this.myProject).isBuildWithGradle()) {
            return Collections.emptyList();
        }
        ArrayList<String> jvmArgs = new ArrayList<String>();
        AndroidGradleBuildConfiguration buildConfiguration = AndroidGradleBuildConfiguration.getInstance(this.myProject);
        AndroidGradleBuildProcessParametersProvider.populateJvmArgs(buildConfiguration, jvmArgs, this.myProject);
        GradleExecutionSettings executionSettings = GradleUtil.getGradleExecutionSettings(this.myProject);
        if (executionSettings != null) {
            this.populateJvmArgs(executionSettings, jvmArgs);
        }
        this.populateJvmArgs(BuildSettings.getInstance(this.myProject), jvmArgs);
        if (!IdeInfo.getInstance().isAndroidStudio()) {
            AndroidGradleBuildProcessParametersProvider.addHttpProxySettings(jvmArgs);
        }
        return jvmArgs;
    }

    @VisibleForTesting
    static void populateJvmArgs(@NotNull AndroidGradleBuildConfiguration buildConfiguration, @NotNull List<String> jvmArgs, @NotNull Project project) {
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.offline.mode", (boolean)GradleSettings.getInstance((Project)project).isOfflineWork()));
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.configuration.on.demand", (boolean)buildConfiguration.USE_CONFIGURATION_ON_DEMAND));
        String[] commandLineOptions = buildConfiguration.getCommandLineOptions();
        int optionCount = 0;
        for (String option : commandLineOptions) {
            String name = "com.android.studio.gradle.daemon.command.line.option." + optionCount++;
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)name, (String)option));
        }
    }

    @VisibleForTesting
    void populateJvmArgs(@NotNull GradleExecutionSettings executionSettings, @NotNull List<String> jvmArgs) {
        File javaHome;
        String serviceDirectory;
        String gradleHome = executionSettings.getGradleHome();
        if (gradleHome != null && !gradleHome.isEmpty()) {
            gradleHome = FileUtil.toSystemDependentName((String)gradleHome);
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.home.path", (String)gradleHome));
        }
        if ((serviceDirectory = executionSettings.getServiceDirectory()) != null && !serviceDirectory.isEmpty()) {
            serviceDirectory = FileUtil.toSystemDependentName((String)serviceDirectory);
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.service.dir.path", (String)serviceDirectory));
        }
        if ((javaHome = IdeSdks.getInstance().getJdkPath()) != null) {
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.java.home.path", (String)javaHome.getPath()));
        }
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.project.path", (String)Projects.getBaseDirPath(this.myProject).getPath()));
        boolean verboseProcessing = executionSettings.isVerboseProcessing();
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.use.verbose.logging", (boolean)verboseProcessing));
        if (!IdeInfo.getInstance().isAndroidStudio()) {
            String jvmOptions = executionSettings.getDaemonVmOptions();
            int jvmOptionCount = 0;
            if (jvmOptions != null && !jvmOptions.isEmpty()) {
                CommandLineTokenizer tokenizer = new CommandLineTokenizer(jvmOptions);
                while (tokenizer.hasMoreTokens()) {
                    String name = "com.android.studio.gradle.daemon.jvm.option." + jvmOptionCount++;
                    jvmArgs.add(AndroidGradleSettings.createJvmArg((String)name, (String)tokenizer.nextToken()));
                }
            }
        }
    }

    private static void addHttpProxySettings(@NotNull List<String> jvmArgs) {
        AndroidGradleBuildProcessParametersProvider.populateHttpProxyProperties(jvmArgs, HttpConfigurable.getInstance().getJvmProperties(false, null));
    }

    @VisibleForTesting
    static void populateHttpProxyProperties(List<String> jvmArgs, List<Pair<String, String>> properties) {
        int propertyCount = properties.size();
        for (int i = 0; i < propertyCount; ++i) {
            Pair<String, String> property = properties.get(i);
            String name = "com.android.studio.gradle.proxy.property." + i;
            String value = (String)property.first + ":" + (String)property.second;
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)name, (String)value));
        }
    }

    private void populateJvmArgs(@NotNull BuildSettings buildSettings, @NotNull List<String> jvmArgs) {
        BuildMode buildMode = buildSettings.getBuildMode();
        if (buildMode == null) {
            buildMode = BuildMode.DEFAULT_BUILD_MODE;
        }
        jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.build.mode", (String)buildMode.toString()));
        this.populateGradleTasksToInvoke(buildMode, jvmArgs);
    }

    @VisibleForTesting
    void populateGradleTasksToInvoke(@NotNull BuildMode buildMode, @NotNull List<String> jvmArgs) {
        if (buildMode == BuildMode.ASSEMBLE_TRANSLATE) {
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.gradle.tasks.0", (String)"assembleTranslate"));
            return;
        }
        BuildSettings buildSettings = BuildSettings.getInstance(this.myProject);
        Module[] modulesToBuild = buildSettings.getModulesToBuild();
        if (modulesToBuild == null || buildMode == BuildMode.ASSEMBLE && GradleSyncState.getInstance(this.myProject).lastSyncFailed()) {
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)"com.android.studio.gradle.gradle.tasks.0", (String)"assemble"));
            return;
        }
        TestCompileType testCompileType = TestCompileType.get(buildSettings.getRunConfigurationTypeId());
        List<String> tasks = GradleTaskFinder.getInstance().findTasksToExecute(modulesToBuild, buildMode, testCompileType);
        int taskCount = tasks.size();
        for (int i = 0; i < taskCount; ++i) {
            String name = "com.android.studio.gradle.gradle.tasks." + i;
            jvmArgs.add(AndroidGradleSettings.createJvmArg((String)name, (String)tasks.get(i)));
        }
    }

    public boolean isProcessPreloadingEnabled() {
        return !GradleProjectInfo.getInstance(this.myProject).isBuildWithGradle();
    }
}

