/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.GradleConnector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildStopper {
    @NotNull
    private final Map<ExternalSystemTaskId, CancellationTokenSource> myMap = new ConcurrentHashMap<ExternalSystemTaskId, CancellationTokenSource>();

    @NotNull
    public CancellationTokenSource createAndRegisterTokenSource(@NotNull ExternalSystemTaskId id) {
        CancellationTokenSource tokenSource = GradleConnector.newCancellationTokenSource();
        this.myMap.put(id, tokenSource);
        return tokenSource;
    }

    void register(@NotNull ExternalSystemTaskId id, CancellationTokenSource tokenSource) {
        this.myMap.put(id, tokenSource);
    }

    public void attemptToStopBuild(@NotNull ExternalSystemTaskId id, @Nullable ProgressIndicator progressIndicator) {
        CancellationTokenSource token;
        if (progressIndicator != null) {
            if (progressIndicator.isCanceled()) {
                return;
            }
            if (progressIndicator.isRunning()) {
                progressIndicator.setText("Stopping Gradle build...");
                progressIndicator.cancel();
            }
        }
        if ((token = this.remove(id)) != null) {
            token.cancel();
        }
    }

    @Nullable
    public CancellationTokenSource remove(@NotNull ExternalSystemTaskId taskId) {
        return this.myMap.remove(taskId);
    }

    public boolean contains(@NotNull ExternalSystemTaskId taskId) {
        return this.myMap.containsKey(taskId);
    }

    @Nullable
    CancellationTokenSource get(@NotNull ExternalSystemTaskId taskId) {
        return this.myMap.get(taskId);
    }
}

