/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.build.invoker.BuildStopper;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.build.invoker.GradleTaskFinder;
import com.android.tools.idea.gradle.project.build.invoker.GradleTasksExecutor;
import com.android.tools.idea.gradle.project.build.invoker.GradleTasksExecutorFactory;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.tooling.BuildAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleBuildInvoker {
    @NotNull
    private final Project myProject;
    @NotNull
    private final FileDocumentManager myDocumentManager;
    @NotNull
    private final GradleTasksExecutorFactory myTaskExecutorFactory;
    @NotNull
    private final Set<AfterGradleInvocationTask> myAfterTasks = new LinkedHashSet<AfterGradleInvocationTask>();
    @NotNull
    private final List<String> myOneTimeGradleOptions = new ArrayList<String>();
    @NotNull
    private final List<String> myLastBuildTasks = new ArrayList<String>();
    @NotNull
    private final BuildStopper myBuildStopper = new BuildStopper();

    @NotNull
    public static GradleBuildInvoker getInstance(@NotNull Project project) {
        return (GradleBuildInvoker)ServiceManager.getService((Project)project, GradleBuildInvoker.class);
    }

    public GradleBuildInvoker(@NotNull Project project, @NotNull FileDocumentManager documentManager) {
        this(project, documentManager, new GradleTasksExecutorFactory());
    }

    @VisibleForTesting
    protected GradleBuildInvoker(@NotNull Project project, @NotNull FileDocumentManager documentManager, @NotNull GradleTasksExecutorFactory tasksExecutorFactory) {
        this.myProject = project;
        this.myDocumentManager = documentManager;
        this.myTaskExecutorFactory = tasksExecutorFactory;
    }

    public void cleanProject() {
        this.setProjectBuildMode(BuildMode.CLEAN);
        Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        ArrayList<String> tasks = new ArrayList<String>(GradleTaskFinder.getInstance().findTasksToExecute(modules, BuildMode.SOURCE_GEN, TestCompileType.ALL));
        GradleBuildInvoker.addCleanTask(tasks);
        this.executeTasks(tasks, Collections.singletonList(GradleBuildInvoker.createGenerateSourcesOnlyProperty()));
    }

    public void cleanAndGenerateSources() {
        this.generateSources(true);
    }

    public void generateSources() {
        this.generateSources(false);
    }

    private void generateSources(boolean cleanProject) {
        BuildMode buildMode = BuildMode.SOURCE_GEN;
        this.setProjectBuildMode(buildMode);
        Module[] modules = ModuleManager.getInstance((Project)this.myProject).getModules();
        ArrayList<String> tasks = new ArrayList<String>(GradleTaskFinder.getInstance().findTasksToExecute(modules, buildMode, TestCompileType.ALL));
        if (cleanProject) {
            GradleBuildInvoker.addCleanTask(tasks);
        }
        this.executeTasks(tasks, Collections.singletonList(GradleBuildInvoker.createGenerateSourcesOnlyProperty()));
    }

    private static void addCleanTask(@NotNull List<String> tasks) {
        tasks.add(0, "clean");
    }

    @NotNull
    private static String createGenerateSourcesOnlyProperty() {
        return AndroidGradleSettings.createProjectProperty((String)"android.injected.generateSourcesOnly", (boolean)true);
    }

    public void compileJava(@NotNull Module[] modules, @NotNull TestCompileType testCompileType) {
        BuildMode buildMode = BuildMode.COMPILE_JAVA;
        this.setProjectBuildMode(buildMode);
        List<String> tasks = GradleTaskFinder.getInstance().findTasksToExecute(modules, buildMode, testCompileType);
        this.executeTasks(tasks);
    }

    public void assemble(@NotNull Module[] modules, @NotNull TestCompileType testCompileType) {
        this.assemble(modules, testCompileType, Collections.emptyList());
    }

    public void assemble(@NotNull Module[] modules, @NotNull TestCompileType testCompileType, @Nullable BuildAction<?> buildAction) {
        this.assemble(modules, testCompileType, Collections.emptyList(), buildAction);
    }

    public void assemble(@NotNull Module[] modules, @NotNull TestCompileType testCompileType, @NotNull List<String> arguments) {
        this.assemble(modules, testCompileType, arguments, null);
    }

    public void assemble(@NotNull Module[] modules, @NotNull TestCompileType testCompileType, @NotNull List<String> arguments, @Nullable BuildAction<?> buildAction) {
        BuildMode buildMode = BuildMode.ASSEMBLE;
        this.setProjectBuildMode(buildMode);
        List<String> tasks = GradleTaskFinder.getInstance().findTasksToExecute(modules, buildMode, testCompileType);
        this.executeTasks(tasks, arguments, buildAction);
    }

    public void rebuild() {
        BuildMode buildMode = BuildMode.REBUILD;
        this.setProjectBuildMode(buildMode);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        List<String> tasks = GradleTaskFinder.getInstance().findTasksToExecute(moduleManager.getModules(), buildMode, TestCompileType.ALL);
        this.executeTasks(tasks);
    }

    public void rebuildWithTempOptions(@NotNull List<String> options) {
        this.myOneTimeGradleOptions.addAll(options);
        try {
            if (this.myLastBuildTasks.isEmpty()) {
                this.rebuild();
            } else {
                ArrayList<String> tasksFromLastBuild = new ArrayList<String>();
                tasksFromLastBuild.addAll(this.myLastBuildTasks);
                this.executeTasks(tasksFromLastBuild);
            }
        }
        finally {
            this.myOneTimeGradleOptions.clear();
        }
    }

    private void setProjectBuildMode(@NotNull BuildMode buildMode) {
        BuildSettings.getInstance(this.myProject).setBuildMode(buildMode);
    }

    public void executeTasks(@NotNull List<String> gradleTasks) {
        this.executeTasks(gradleTasks, this.myOneTimeGradleOptions);
    }

    public void executeTasks(@NotNull List<String> tasks, @Nullable BuildMode buildMode, @NotNull List<String> commandLineArguments, @Nullable BuildAction buildAction) {
        if (buildMode != null) {
            this.setProjectBuildMode(buildMode);
        }
        this.executeTasks(tasks, commandLineArguments, buildAction);
    }

    public void executeTasks(@NotNull List<String> gradleTasks, @NotNull List<String> commandLineArguments) {
        this.executeTasks(gradleTasks, commandLineArguments, null);
    }

    private void executeTasks(@NotNull List<String> gradleTasks, @NotNull List<String> commandLineArguments, @Nullable BuildAction buildAction) {
        ArrayList<String> jvmArguments = new ArrayList<String>();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            File androidHomePath;
            LocalProperties localProperties;
            try {
                localProperties = new LocalProperties(this.myProject);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (localProperties.getAndroidSdkPath() == null && (androidHomePath = IdeSdks.getInstance().getAndroidSdkPath()) != null) {
                jvmArguments.add(AndroidGradleSettings.createAndroidHomeJvmArg((String)androidHomePath.getPath()));
            }
        }
        Request request = new Request(this.myProject, gradleTasks);
        request.setJvmArguments(jvmArguments).setCommandLineArguments(commandLineArguments).setBuildAction(buildAction);
        this.executeTasks(request);
    }

    public void executeTasks(@NotNull Request request) {
        this.myLastBuildTasks.clear();
        List<String> gradleTasks = request.getGradleTasks();
        this.myLastBuildTasks.addAll(gradleTasks);
        GradleBuildInvoker.getLogger().info("About to execute Gradle tasks: " + gradleTasks);
        if (gradleTasks.isEmpty()) {
            return;
        }
        GradleTasksExecutor executor = this.myTaskExecutorFactory.create(request, this.myBuildStopper);
        Runnable executeTasksTask = () -> {
            this.myDocumentManager.saveAllDocuments();
            if (StudioFlags.GRADLE_INVOCATIONS_INDEXING_AWARE.get().booleanValue()) {
                DumbService.getInstance((Project)this.myProject).runWhenSmart(() -> ((GradleTasksExecutor)executor).queue());
            } else {
                executor.queue();
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            executeTasksTask.run();
        } else if (request.isWaitForCompletion()) {
            executor.queueAndWaitForCompletion();
        } else {
            TransactionGuard.getInstance().submitTransactionAndWait(executeTasksTask);
        }
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(GradleBuildInvoker.class);
    }

    public void stopBuild(@NotNull ExternalSystemTaskId id) {
        this.myBuildStopper.attemptToStopBuild(id, null);
    }

    public void add(@NotNull AfterGradleInvocationTask task) {
        this.myAfterTasks.add(task);
    }

    @VisibleForTesting
    @NotNull
    protected AfterGradleInvocationTask[] getAfterInvocationTasks() {
        return this.myAfterTasks.toArray(new AfterGradleInvocationTask[this.myAfterTasks.size()]);
    }

    public void remove(@NotNull AfterGradleInvocationTask task) {
        this.myAfterTasks.remove(task);
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public static class Request {
        @NotNull
        private final Project myProject;
        @NotNull
        private final List<String> myGradleTasks;
        @NotNull
        private final List<String> myJvmArguments;
        @NotNull
        private final List<String> myCommandLineArguments;
        @NotNull
        private final ExternalSystemTaskId myTaskId;
        @Nullable
        private ExternalSystemTaskNotificationListener myTaskListener;
        @Nullable
        private File myBuildFilePath;
        @Nullable
        private BuildAction myBuildAction;
        private boolean myWaitForCompletion;

        public Request(@NotNull Project project, String ... gradleTasks) {
            this(project, Arrays.asList(gradleTasks));
        }

        public Request(@NotNull Project project, @NotNull List<String> gradleTasks) {
            this(project, gradleTasks, ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.EXECUTE_TASK, (Project)project));
        }

        public Request(@NotNull Project project, @NotNull List<String> gradleTasks, @NotNull ExternalSystemTaskId taskId) {
            this.myProject = project;
            this.myGradleTasks = new ArrayList<String>(gradleTasks);
            this.myJvmArguments = new ArrayList<String>();
            this.myCommandLineArguments = new ArrayList<String>();
            this.myTaskId = taskId;
        }

        @NotNull
        Project getProject() {
            return this.myProject;
        }

        @NotNull
        List<String> getGradleTasks() {
            return this.myGradleTasks;
        }

        @NotNull
        List<String> getJvmArguments() {
            return this.myJvmArguments;
        }

        @NotNull
        public Request setJvmArguments(@NotNull List<String> jvmArguments) {
            this.myJvmArguments.clear();
            this.myJvmArguments.addAll(jvmArguments);
            return this;
        }

        @NotNull
        List<String> getCommandLineArguments() {
            return this.myCommandLineArguments;
        }

        @NotNull
        public Request setCommandLineArguments(@NotNull List<String> commandLineArguments) {
            this.myCommandLineArguments.clear();
            this.myCommandLineArguments.addAll(commandLineArguments);
            return this;
        }

        @Nullable
        public ExternalSystemTaskNotificationListener getTaskListener() {
            return this.myTaskListener;
        }

        @NotNull
        public Request setTaskListener(@Nullable ExternalSystemTaskNotificationListener taskListener) {
            this.myTaskListener = taskListener;
            return this;
        }

        @NotNull
        ExternalSystemTaskId getTaskId() {
            return this.myTaskId;
        }

        @Nullable
        File getBuildFilePath() {
            return this.myBuildFilePath;
        }

        @NotNull
        public Request setBuildFilePath(@Nullable File buildFilePath) {
            this.myBuildFilePath = buildFilePath;
            return this;
        }

        boolean isWaitForCompletion() {
            return this.myWaitForCompletion;
        }

        @NotNull
        public Request waitForCompletion() {
            this.myWaitForCompletion = true;
            return this;
        }

        @Nullable
        public BuildAction getBuildAction() {
            return this.myBuildAction;
        }

        @NotNull
        public Request setBuildAction(@Nullable BuildAction buildAction) {
            this.myBuildAction = buildAction;
            return this;
        }

        public String toString() {
            return "RequestSettings{myGradleTasks=" + this.myGradleTasks + ", myJvmArguments=" + this.myJvmArguments + ", myCommandLineArguments=" + this.myCommandLineArguments + ", myBuildAction=" + this.myBuildAction + '}';
        }
    }

    public static interface AfterGradleInvocationTask {
        public void execute(@NotNull GradleInvocationResult var1);
    }
}

