/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.android.ide.common.blame.Message;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import org.gradle.tooling.BuildCancelledException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleInvocationResult {
    @NotNull
    private final List<String> myTasks;
    @NotNull
    private final ListMultimap<Message.Kind, Message> myCompilerMessagesByKind = ArrayListMultimap.create();
    @Nullable
    private final Object myModel;
    private final boolean myBuildSuccessful;
    private final boolean myBuildCancelled;

    public GradleInvocationResult(@NotNull List<String> tasks, @NotNull List<Message> compilerMessages, @Nullable Throwable buildError) {
        this(tasks, compilerMessages, buildError, null);
    }

    public GradleInvocationResult(@NotNull List<String> tasks, @NotNull List<Message> compilerMessages, @Nullable Throwable buildError, @Nullable Object model) {
        this.myTasks = tasks;
        this.myBuildSuccessful = buildError == null;
        this.myBuildCancelled = buildError != null && GradleUtil.hasCause(buildError, BuildCancelledException.class);
        for (Message msg : compilerMessages) {
            this.myCompilerMessagesByKind.put((Object)msg.getKind(), (Object)msg);
        }
        this.myModel = model;
    }

    @NotNull
    public List<String> getTasks() {
        return this.myTasks;
    }

    @NotNull
    public List<Message> getCompilerMessages(@NotNull Message.Kind kind) {
        return this.myCompilerMessagesByKind.get((Object)kind);
    }

    public boolean isBuildSuccessful() {
        return this.myBuildSuccessful;
    }

    public boolean isBuildCancelled() {
        return this.myBuildCancelled;
    }

    @Nullable
    public Object getModel() {
        return this.myModel;
    }
}

