/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.android.builder.model.BaseArtifact;
import com.android.builder.model.TestedTargetVariant;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacetConfiguration;
import com.android.tools.idea.gradle.project.facet.java.JavaFacet;
import com.android.tools.idea.gradle.project.facet.java.JavaFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.ide.android.IdeBaseArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeVariant;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

public class GradleTaskFinder {
    @NotNull
    public static GradleTaskFinder getInstance() {
        return (GradleTaskFinder)ServiceManager.getService(GradleTaskFinder.class);
    }

    @NotNull
    public List<String> findTasksToExecuteForTest(@NotNull Module[] testedModules, @NotNull Module[] modules, @NotNull BuildMode buildMode, @NotNull TestCompileType testCompileType) {
        List<String> allTasks = this.findTasksToExecute(modules, buildMode, TestCompileType.NONE);
        List<String> testedModulesTasks = this.findTasksToExecute(testedModules, buildMode, testCompileType);
        for (String task : testedModulesTasks) {
            if (allTasks.contains(task)) continue;
            allTasks.add(task);
        }
        return allTasks;
    }

    @NotNull
    public List<String> findTasksToExecute(@NotNull Module[] modules, @NotNull BuildMode buildMode, @NotNull TestCompileType testCompileType) {
        Project project;
        ArrayList<String> tasks = new ArrayList<String>();
        if (BuildMode.ASSEMBLE == buildMode && GradleSyncState.getInstance(project = modules[0].getProject()).lastSyncFailed()) {
            return Collections.singletonList("assemble");
        }
        for (Project module : modules) {
            if ("buildSrc".equals(module.getName())) continue;
            this.findAndAddGradleBuildTasks((Module)module, buildMode, tasks, testCompileType);
        }
        if (buildMode == BuildMode.REBUILD && !tasks.isEmpty()) {
            tasks.add(0, "clean");
        }
        if (tasks.isEmpty()) {
            String format = "Unable to find Gradle tasks for project '%1$s' using BuildMode %2$s";
            GradleTaskFinder.getLogger().info(String.format(format, modules[0].getProject().getName(), buildMode.name()));
        }
        return tasks;
    }

    private void findAndAddGradleBuildTasks(@NotNull Module module, @NotNull BuildMode buildMode, @NotNull List<String> tasks, @NotNull TestCompileType testCompileType) {
        block17: {
            String gradlePath;
            block16: {
                GradleFacet gradleFacet = GradleFacet.getInstance(module);
                if (gradleFacet == null) {
                    return;
                }
                gradlePath = ((GradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
                if (StringUtil.isEmpty((String)gradlePath)) {
                    String msg = String.format("Module '%1$s' does not have a Gradle path. It is likely that this module was manually added by the user.", module.getName());
                    GradleTaskFinder.getLogger().info(msg);
                    return;
                }
                if (GradleTaskFinder.isCompositeBuild(module)) {
                    String msg = String.format("Module '%1$s' comes from composite build, skip gradle tasks.", module.getName());
                    GradleTaskFinder.getLogger().info(msg);
                    return;
                }
                AndroidFacet androidFacet = AndroidFacet.getInstance(module);
                if (androidFacet == null) break block16;
                JpsAndroidModuleProperties properties = androidFacet.getProperties();
                AndroidModuleModel androidModel = AndroidModuleModel.get(module);
                switch (buildMode) {
                    case CLEAN: 
                    case SOURCE_GEN: {
                        this.addAfterSyncTasks(tasks, gradlePath, properties);
                        if (androidModel != null) {
                            this.addAfterSyncTasksForTestArtifacts(tasks, gradlePath, testCompileType, androidModel);
                            break;
                        }
                        break block17;
                    }
                    case ASSEMBLE: 
                    case REBUILD: {
                        this.addTaskIfSpecified(tasks, gradlePath, properties.ASSEMBLE_TASK_NAME);
                        if (testCompileType != TestCompileType.ALL && androidModel != null) {
                            for (BaseArtifact baseArtifact : testCompileType.getArtifacts(androidModel.getSelectedVariant())) {
                                this.addTaskIfSpecified(tasks, gradlePath, baseArtifact.getAssembleTaskName());
                            }
                        }
                        this.addAssembleTasksForTargetVariants(tasks, module);
                        break;
                    }
                    default: {
                        this.addAfterSyncTasks(tasks, gradlePath, properties);
                        if (androidModel != null) {
                            this.addAfterSyncTasksForTestArtifacts(tasks, gradlePath, testCompileType, androidModel);
                            for (BaseArtifact baseArtifact : testCompileType.getArtifacts(androidModel.getSelectedVariant())) {
                                this.addTaskIfSpecified(tasks, gradlePath, baseArtifact.getCompileTaskName());
                            }
                        }
                        if (testCompileType != TestCompileType.UNIT_TESTS) {
                            this.addTaskIfSpecified(tasks, gradlePath, properties.COMPILE_JAVA_TASK_NAME);
                            break;
                        }
                        break block17;
                    }
                }
                break block17;
            }
            JavaFacet javaFacet = JavaFacet.getInstance(module);
            if (javaFacet != null && ((JavaFacetConfiguration)javaFacet.getConfiguration()).BUILDABLE) {
                String gradleTaskName = javaFacet.getGradleTaskName(buildMode);
                if (gradleTaskName != null) {
                    tasks.add(this.createBuildTask(gradlePath, gradleTaskName));
                }
                if (TestCompileType.UNIT_TESTS.equals(testCompileType)) {
                    tasks.add(this.createBuildTask(gradlePath, "testClasses"));
                }
            }
        }
    }

    static boolean isCompositeBuild(@NotNull Module module) {
        String projectPath = module.getProject().getBaseDir().getPath();
        GradleProjectSettings projectSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)module.getProject()).getLinkedProjectSettings(projectPath);
        if (projectSettings == null) {
            return false;
        }
        GradleProjectSettings.CompositeBuild compositeBuild = projectSettings.getCompositeBuild();
        if (compositeBuild == null) {
            return false;
        }
        VirtualFile moduleFile = module.getModuleFile();
        if (moduleFile == null) {
            return false;
        }
        String modulePath = moduleFile.getParent().getPath();
        for (BuildParticipant participant : compositeBuild.getCompositeParticipants()) {
            if (!participant.getProjects().contains(modulePath)) continue;
            return true;
        }
        return false;
    }

    private void addAssembleTasksForTargetVariants(@NotNull List<String> tasks, @NotNull Module testOnlyModule) {
        AndroidModuleModel testAndroidModel = AndroidModuleModel.get(testOnlyModule);
        if (testAndroidModel == null || !testAndroidModel.getFeatures().isTestedTargetVariantsSupported() || testAndroidModel.getAndroidProject().getProjectType() != 2) {
            return;
        }
        for (TestedTargetVariant testedTargetVariant : testAndroidModel.getSelectedVariant().getTestedTargetVariants()) {
            String targetVariantName;
            Variant targetVariant;
            AndroidModuleModel targetAndroidModel;
            String targetProjectGradlePath = testedTargetVariant.getTargetProjectPath();
            Module targetModule = GradleUtil.findModuleByGradlePath(testOnlyModule.getProject(), targetProjectGradlePath);
            if (targetModule == null || (targetAndroidModel = AndroidModuleModel.get(targetModule)) == null || (targetVariant = targetAndroidModel.findVariantByName(targetVariantName = testedTargetVariant.getTargetVariant())) == null) continue;
            this.addTaskIfSpecified(tasks, targetProjectGradlePath, targetVariant.getMainArtifact().getAssembleTaskName());
        }
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(GradleTaskFinder.class);
    }

    private void addAfterSyncTasksForTestArtifacts(@NotNull List<String> tasks, @NotNull String gradlePath, @NotNull TestCompileType testCompileType, @NotNull AndroidModuleModel androidModel) {
        IdeVariant variant = androidModel.getSelectedVariant();
        Collection<IdeBaseArtifact> testArtifacts = testCompileType.getArtifacts(variant);
        for (IdeBaseArtifact artifact : testArtifacts) {
            for (String taskName : artifact.getIdeSetupTaskNames()) {
                this.addTaskIfSpecified(tasks, gradlePath, taskName);
            }
        }
    }

    private void addAfterSyncTasks(@NotNull List<String> tasks, @NotNull String gradlePath, @NotNull JpsAndroidModuleProperties properties) {
        for (String taskName : properties.AFTER_SYNC_TASK_NAMES) {
            this.addTaskIfSpecified(tasks, gradlePath, taskName);
        }
    }

    private void addTaskIfSpecified(@NotNull List<String> tasks, @NotNull String gradlePath, @Nullable String gradleTaskName) {
        String buildTask;
        if (StringUtil.isNotEmpty((String)gradleTaskName) && !tasks.contains(buildTask = this.createBuildTask(gradlePath, gradleTaskName))) {
            tasks.add(buildTask);
        }
    }

    @NotNull
    public String createBuildTask(@NotNull String gradleProjectPath, @NotNull String taskName) {
        if (gradleProjectPath.equals(":")) {
            return gradleProjectPath + taskName;
        }
        return gradleProjectPath + ":" + taskName;
    }
}

