/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.MessageView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GradleTasksExecutor
extends Task.Backgroundable {
    @NotNull
    public static final NotificationGroup LOGGING_NOTIFICATION = NotificationGroup.logOnlyGroup((String)"Gradle Build (Logging)");
    @NotNull
    public static final NotificationGroup BALLOON_NOTIFICATION = NotificationGroup.balloonGroup((String)"Gradle Build (Balloon)");
    protected static final Key<Key<?>> CONTENT_ID_KEY = Key.create((String)"CONTENT_ID");

    protected GradleTasksExecutor(@Nullable Project project) {
        super(project, "Gradle Build Running", true);
    }

    public abstract void queueAndWaitForCompletion();

    public static void clearMessageView(@NotNull Project project) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!project.isDisposed()) {
                GradleTasksExecutor.removeUnpinnedBuildMessages(project, null);
            }
        });
    }

    protected static void removeUnpinnedBuildMessages(@NotNull Project project, @Nullable Content toKeep) {
        if (project.isInitialized()) {
            Content[] contents;
            MessageView messageView = MessageView.SERVICE.getInstance((Project)project);
            for (Content content : contents = messageView.getContentManager().getContents()) {
                if (content.isPinned() || content == toKeep || content.getUserData(CONTENT_ID_KEY) == null) continue;
                messageView.getContentManager().removeContent(content, true);
            }
        }
    }
}

