/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.fd.FlightRecorder;
import com.android.tools.idea.fd.InstantRunBuildProgressListener;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.gradle.output.parser.BuildOutputParser;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.project.build.BuildContext;
import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.GradleBuildState;
import com.android.tools.idea.gradle.project.build.compiler.AndroidGradleBuildConfiguration;
import com.android.tools.idea.gradle.project.build.console.view.GradleConsoleView;
import com.android.tools.idea.gradle.project.build.invoker.BuildProcessController;
import com.android.tools.idea.gradle.project.build.invoker.BuildStopper;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.project.build.invoker.GradleOutputForwarder;
import com.android.tools.idea.gradle.project.build.invoker.GradleTasksExecutor;
import com.android.tools.idea.gradle.project.build.invoker.TaskExecutionProgressIndicator;
import com.android.tools.idea.gradle.project.build.invoker.messages.GradleBuildTreeViewPanel;
import com.android.tools.idea.gradle.project.common.GradleInitScripts;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.SelectSdkDialog;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.intellij.compiler.CompilerManagerImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.pom.Navigatable;
import com.intellij.ui.AppIcon;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import net.jcip.annotations.GuardedBy;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.BuildCancelledException;
import org.gradle.tooling.BuildException;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.CancellationTokenSource;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.ProgressListener;
import org.jetbrains.android.AndroidPlugin;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.execution.GradleProgressEventConverter;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;

class GradleTasksExecutorImpl
extends GradleTasksExecutor {
    private static final ExternalSystemTaskNotificationListener GRADLE_LISTENER = new ExternalSystemTaskNotificationListenerAdapter(){};
    private static final long ONE_MINUTE_MS = 60000L;
    @NonNls
    private static final String CONTENT_NAME = "Gradle Build";
    @NonNls
    private static final String APP_ICON_ID = "compiler";
    private static final int BUFFER_SIZE = 2048;
    private static final String GRADLE_RUNNING_MSG_TITLE = "Gradle Running";
    private static final String PASSWORD_KEY_SUFFIX = ".password=";
    @NotNull
    private final Key<Key<?>> myContentId = Key.create((String)"compile_content");
    @NotNull
    private final Object myMessageViewLock = new Object();
    @NotNull
    private final Object myCompletionLock = new Object();
    @NotNull
    private final GradleBuildInvoker.Request myRequest;
    @NotNull
    private final BuildStopper myBuildStopper;
    @GuardedBy(value="myCompletionLock")
    private int myCompletionCounter;
    @GuardedBy(value="myMessageViewLock")
    @Nullable
    private GradleBuildTreeViewPanel myErrorTreeView;
    @NotNull
    private final GradleExecutionHelper myHelper = new GradleExecutionHelper();
    private volatile int myErrorCount;
    private volatile int myWarningCount;
    @NotNull
    private volatile ProgressIndicator myProgressIndicator = new EmptyProgressIndicator();
    private volatile boolean myMessageViewIsPrepared;
    private volatile boolean myMessagesAutoActivated;
    private CloseListener myCloseListener;

    GradleTasksExecutorImpl(@NotNull GradleBuildInvoker.Request request, @NotNull BuildStopper buildStopper) {
        super(request.getProject());
        this.myRequest = request;
        this.myBuildStopper = buildStopper;
    }

    public String getProcessId() {
        return "GradleTaskInvocation";
    }

    @Nullable
    public Task.NotificationInfo getNotificationInfo() {
        return new Task.NotificationInfo(this.myErrorCount > 0 ? "Gradle Invocation (errors)" : "Gradle Invocation (success)", "Gradle Invocation Finished", this.myErrorCount + " Errors, " + this.myWarningCount + " Warnings", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@NotNull ProgressIndicator indicator) {
        if (IdeInfo.getInstance().isAndroidStudio()) {
            GradleUtil.clearStoredGradleJvmArgs(this.getProject());
        }
        this.myProgressIndicator = indicator;
        ProjectManager projectManager = ProjectManager.getInstance();
        Project project = this.myRequest.getProject();
        this.myCloseListener = new CloseListener();
        projectManager.addProjectManagerListener(project, (ProjectManagerListener)this.myCloseListener);
        Semaphore semaphore = ((CompilerManagerImpl)CompilerManager.getInstance((Project)project)).getCompilationSemaphore();
        boolean acquired = false;
        try {
            try {
                while (!acquired) {
                    acquired = semaphore.tryAcquire(300L, TimeUnit.MILLISECONDS);
                    if (!this.myProgressIndicator.isCanceled()) continue;
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.addIndicatorDelegate();
            this.invokeGradleTasks();
        }
        finally {
            try {
                this.myProgressIndicator.stop();
                projectManager.removeProjectManagerListener(project, (ProjectManagerListener)this.myCloseListener);
            }
            finally {
                if (acquired) {
                    semaphore.release();
                }
            }
        }
    }

    private void addIndicatorDelegate() {
        if (this.myProgressIndicator instanceof ProgressIndicatorEx) {
            ProgressIndicatorEx indicator = (ProgressIndicatorEx)this.myProgressIndicator;
            indicator.addStateDelegate((ProgressIndicatorEx)new ProgressIndicatorStateDelegate(this.myRequest.getTaskId(), this.myBuildStopper));
        }
    }

    private void closeView() {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = GradleTasksExecutorImpl.this.myMessageViewLock;
                synchronized (object) {
                    if (GradleTasksExecutorImpl.this.myErrorTreeView != null && !GradleTasksExecutorImpl.this.myRequest.getProject().isDisposed()) {
                        this.addStatisticsMessage(CompilerBundle.message((String)"statistics.error.count", (Object[])new Object[]{GradleTasksExecutorImpl.this.myErrorCount}));
                        this.addStatisticsMessage(CompilerBundle.message((String)"statistics.warnings.count", (Object[])new Object[]{GradleTasksExecutorImpl.this.myWarningCount}));
                        GradleTasksExecutorImpl.this.addMessage(new Message(Message.Kind.INFO, "See complete output in console", SourceFilePosition.UNKNOWN, new SourceFilePosition[0]), new OpenGradleConsole());
                        GradleTasksExecutorImpl.this.myErrorTreeView.selectFirstMessage();
                    }
                }
            }

            private void addStatisticsMessage(@NotNull String text) {
                GradleTasksExecutorImpl.this.addMessage(new Message(Message.Kind.STATISTICS, text, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]), null);
            }
        }, ModalityState.NON_MODAL);
    }

    private void invokeGradleTasks() {
        File buildFilePath;
        Application application;
        Runnable task;
        Project project = this.myRequest.getProject();
        GradleExecutionSettings executionSettings = GradleUtil.getOrCreateGradleExecutionSettings(project);
        AtomicReference<Object> model = new AtomicReference<Object>(null);
        Function executeTasksFunction = connection -> {
            block34: {
                String testOutput;
                ExternalSystemTaskId id;
                InstantRunBuildProgressListener instantRunProgressListener;
                Throwable buildError;
                GradleOutputForwarder output;
                Stopwatch stopwatch;
                block33: {
                    stopwatch = Stopwatch.createStarted();
                    GradleConsoleView consoleView = GradleConsoleView.getInstance(this.myProject);
                    consoleView.clear();
                    BuildAction buildAction = this.myRequest.getBuildAction();
                    boolean isRunBuildAction = buildAction != null;
                    List<String> gradleTasks = this.myRequest.getGradleTasks();
                    this.addMessage(new Message(Message.Kind.INFO, "Gradle tasks " + gradleTasks, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]), null);
                    String executingTasksText = "Executing tasks: " + gradleTasks;
                    consoleView.print(executingTasksText + SystemProperties.getLineSeparator() + SystemProperties.getLineSeparator(), ConsoleViewContentType.NORMAL_OUTPUT);
                    this.addToEventLog(executingTasksText, MessageType.INFO);
                    output = new GradleOutputForwarder(consoleView);
                    buildError = null;
                    instantRunProgressListener = null;
                    id = this.myRequest.getTaskId();
                    CancellationTokenSource cancellationTokenSource = this.myBuildStopper.createAndRegisterTokenSource(id);
                    BuildMode buildMode = BuildSettings.getInstance(this.myProject).getBuildMode();
                    GradleBuildState buildState = GradleBuildState.getInstance(this.myProject);
                    buildState.buildStarted(new BuildContext(project, gradleTasks, buildMode));
                    try {
                        AndroidGradleBuildConfiguration buildConfiguration = AndroidGradleBuildConfiguration.getInstance(project);
                        ArrayList commandLineArguments = Lists.newArrayList((Object[])buildConfiguration.getCommandLineOptions());
                        if (buildConfiguration.USE_CONFIGURATION_ON_DEMAND && !commandLineArguments.contains("--configure-on-demand")) {
                            commandLineArguments.add("--configure-on-demand");
                        }
                        if (!commandLineArguments.contains("--parallel") && CompilerWorkspaceConfiguration.getInstance((Project)project).PARALLEL_COMPILATION) {
                            commandLineArguments.add("--parallel");
                        }
                        commandLineArguments.add(AndroidGradleSettings.createProjectProperty((String)"android.injected.invoked.from.ide", (boolean)true));
                        commandLineArguments.addAll(this.myRequest.getCommandLineArguments());
                        GradleInitScripts initScripts = GradleInitScripts.getInstance();
                        initScripts.addLocalMavenRepoInitScriptCommandLineArg(commandLineArguments);
                        GradleUtil.attemptToUseEmbeddedGradle(project);
                        String logMessage = "Build command line options: " + commandLineArguments;
                        if (logMessage.contains(PASSWORD_KEY_SUFFIX)) {
                            ArrayList<String> replaced = new ArrayList<String>(commandLineArguments.size());
                            for (String option : commandLineArguments) {
                                int index = option.indexOf(PASSWORD_KEY_SUFFIX);
                                if (index == -1) {
                                    replaced.add(option);
                                    continue;
                                }
                                replaced.add(option.substring(0, index + PASSWORD_KEY_SUFFIX.length()) + "*********");
                            }
                            logMessage = ((Object)replaced).toString();
                        }
                        GradleTasksExecutorImpl.getLogger().info(logMessage);
                        ArrayList<String> jvmArguments = new ArrayList<String>(this.myRequest.getJvmArguments());
                        BuildLauncher operation = isRunBuildAction ? connection.action(buildAction) : connection.newBuild();
                        GradleExecutionHelper.prepare((LongRunningOperation)operation, (ExternalSystemTaskId)id, (GradleExecutionSettings)executionSettings, (ExternalSystemTaskNotificationListener)GRADLE_LISTENER, jvmArguments, (List)commandLineArguments, (ProjectConnection)connection);
                        File javaHome = IdeSdks.getInstance().getJdkPath();
                        if (javaHome != null) {
                            operation.setJavaHome(javaHome);
                        }
                        if (isRunBuildAction) {
                            ((BuildActionExecuter)operation).forTasks(ArrayUtil.toStringArray(gradleTasks));
                        } else {
                            operation.forTasks(ArrayUtil.toStringArray(gradleTasks));
                        }
                        operation.withCancellationToken(cancellationTokenSource.token());
                        GradleOutputForwarder.Listener outputListener = null;
                        ExternalSystemTaskNotificationListener taskListener = this.myRequest.getTaskListener();
                        if (taskListener != null) {
                            outputListener = (contentType, data, offset, length) -> {
                                if (this.myBuildStopper.contains(id)) {
                                    taskListener.onTaskOutput(id, new String(data, offset, length), contentType != ConsoleViewContentType.ERROR_OUTPUT);
                                }
                            };
                        }
                        output.attachTo((LongRunningOperation)operation, outputListener);
                        if (taskListener != null) {
                            operation.addProgressListener(event -> {
                                if (this.myBuildStopper.contains(id)) {
                                    taskListener.onStatusChange(GradleProgressEventConverter.convert((ExternalSystemTaskId)id, (ProgressEvent)event));
                                }
                            });
                        }
                        if (InstantRunSettings.isInstantRunEnabled() && InstantRunSettings.isRecorderEnabled()) {
                            instantRunProgressListener = new InstantRunBuildProgressListener();
                            operation.addProgressListener((ProgressListener)instantRunProgressListener);
                        }
                        if (isRunBuildAction) {
                            model.set(((BuildActionExecuter)operation).run());
                        } else {
                            operation.run();
                        }
                        buildState.buildFinished(BuildStatus.SUCCESS);
                        if (buildError == null) break block33;
                    }
                    catch (BuildException e) {
                        buildError = e;
                        break block34;
                    }
                    catch (Throwable e2) {
                        String testOutput2;
                        block35: {
                            buildError = e2;
                            this.handleTaskExecutionError(e2);
                            if (buildError == null) break block35;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            if (GradleTasksExecutorImpl.wasBuildCanceled(buildError)) {
                                buildState.buildFinished(BuildStatus.CANCELED);
                            } else {
                                buildState.buildFinished(BuildStatus.FAILED);
                            }
                        }
                        this.myBuildStopper.remove(id);
                        String gradleOutput = output.toString();
                        if (instantRunProgressListener != null) {
                            FlightRecorder.get(this.myProject).saveBuildOutput(gradleOutput, instantRunProgressListener);
                        }
                        Application application = ApplicationManager.getApplication();
                        if (AndroidPlugin.isGuiTestingMode() && StringUtil.isNotEmpty((String)(testOutput2 = (String)application.getUserData(AndroidPlugin.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY)))) {
                            gradleOutput = testOutput2;
                            application.putUserData(AndroidPlugin.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY, null);
                        }
                        this.showGradleOutput(gradleOutput, output, stopwatch, buildError, model.get());
                        break block34;
                    }
                    finally {
                        String testOutput3;
                        if (buildError != null) {
                            if (GradleTasksExecutorImpl.wasBuildCanceled(buildError)) {
                                buildState.buildFinished(BuildStatus.CANCELED);
                            } else {
                                buildState.buildFinished(BuildStatus.FAILED);
                            }
                        }
                        this.myBuildStopper.remove(id);
                        String gradleOutput = output.toString();
                        if (instantRunProgressListener != null) {
                            FlightRecorder.get(this.myProject).saveBuildOutput(gradleOutput, instantRunProgressListener);
                        }
                        Application application = ApplicationManager.getApplication();
                        if (AndroidPlugin.isGuiTestingMode() && StringUtil.isNotEmpty((String)(testOutput3 = (String)application.getUserData(AndroidPlugin.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY)))) {
                            gradleOutput = testOutput3;
                            application.putUserData(AndroidPlugin.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY, null);
                        }
                        this.showGradleOutput(gradleOutput, output, stopwatch, buildError, model.get());
                    }
                    if (GradleTasksExecutorImpl.wasBuildCanceled(buildError)) {
                        buildState.buildFinished(BuildStatus.CANCELED);
                    } else {
                        buildState.buildFinished(BuildStatus.FAILED);
                    }
                }
                this.myBuildStopper.remove(id);
                String gradleOutput = output.toString();
                if (instantRunProgressListener != null) {
                    FlightRecorder.get(this.myProject).saveBuildOutput(gradleOutput, instantRunProgressListener);
                }
                Application application = ApplicationManager.getApplication();
                if (AndroidPlugin.isGuiTestingMode() && StringUtil.isNotEmpty((String)(testOutput = (String)application.getUserData(AndroidPlugin.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY)))) {
                    gradleOutput = testOutput;
                    application.putUserData(AndroidPlugin.GRADLE_BUILD_OUTPUT_IN_GUI_TEST_KEY, null);
                }
                this.showGradleOutput(gradleOutput, output, stopwatch, buildError, model.get());
            }
            return null;
        };
        if (AndroidPlugin.isGuiTestingMode() && (task = (Runnable)(application = ApplicationManager.getApplication()).getUserData(AndroidPlugin.EXECUTE_BEFORE_PROJECT_BUILD_IN_GUI_TEST_KEY)) != null) {
            application.putUserData(AndroidPlugin.EXECUTE_BEFORE_PROJECT_BUILD_IN_GUI_TEST_KEY, null);
            task.run();
        }
        File projectDirPath = (buildFilePath = this.myRequest.getBuildFilePath()) != null ? buildFilePath : Projects.getBaseDirPath(project);
        this.myHelper.execute(projectDirPath.getPath(), executionSettings, executeTasksFunction);
    }

    private void showGradleOutput(@NotNull String gradleOutput, @NotNull GradleOutputForwarder output, @NotNull Stopwatch stopwatch, @Nullable Throwable buildError, @Nullable Object model) {
        Application application = ApplicationManager.getApplication();
        ArrayList<Message> buildMessages = new ArrayList<Message>();
        GradleTasksExecutorImpl.collectMessages(gradleOutput, buildMessages).doWhenDone(() -> {
            boolean hasError = false;
            for (Message message : buildMessages) {
                if (message.getKind() != Message.Kind.ERROR) continue;
                hasError = true;
                break;
            }
            if (!hasError && this.myErrorCount == 0 && buildError != null && buildError instanceof BuildException) {
                GradleTasksExecutorImpl.addBuildExceptionAsMessage((BuildException)buildError, output.getStdErr(), buildMessages);
            }
            output.close();
            stopwatch.stop();
            this.add(buildMessages);
            if (!this.myProgressIndicator.isCanceled()) {
                this.closeView();
            }
            application.invokeLater(() -> this.notifyGradleInvocationCompleted(stopwatch.elapsed(TimeUnit.MILLISECONDS)));
            if (buildError == null || !GradleTasksExecutorImpl.wasBuildCanceled(buildError)) {
                application.invokeLater(this::showMessages);
            }
            if (this.getProject().isDisposed()) {
                return;
            }
            GradleInvocationResult result = new GradleInvocationResult(this.myRequest.getGradleTasks(), buildMessages, buildError, model);
            for (GradleBuildInvoker.AfterGradleInvocationTask task : GradleBuildInvoker.getInstance(this.getProject()).getAfterInvocationTasks()) {
                task.execute(result);
            }
        });
    }

    private static boolean wasBuildCanceled(@NotNull Throwable buildError) {
        return GradleUtil.hasCause(buildError, BuildCancelledException.class);
    }

    @NotNull
    private static ActionCallback collectMessages(@NotNull String gradleOutput, @NotNull List<Message> messages) {
        ActionCallback callback = new ActionCallback();
        Runnable task = () -> {
            Iterable parsers = JpsServiceManager.getInstance().getExtensions(PatternAwareOutputParser.class);
            List compilerMessages = new BuildOutputParser(parsers).parseGradleOutput(gradleOutput, true);
            messages.addAll(compilerMessages);
            callback.setDone();
        };
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            task.run();
        } else {
            application.executeOnPooledThread(task);
        }
        return callback;
    }

    private void add(@NotNull List<Message> buildMessages) {
        this.prepareMessageView();
        Runnable addMessageTask = () -> {
            this.openMessageView();
            for (Message message : buildMessages) {
                this.incrementErrorOrWarningCount(message);
                if (!GradleTasksExecutorImpl.shouldShow(message)) continue;
                this.add(message, null);
            }
        };
        TransactionGuard.submitTransaction((Disposable)this.myProject, (Runnable)addMessageTask);
    }

    private void handleTaskExecutionError(@NotNull Throwable e) {
        if (this.myProgressIndicator.isCanceled()) {
            GradleTasksExecutorImpl.getLogger().info("Failed to complete Gradle execution. Project may be closing or already closed.", e);
            return;
        }
        Throwable rootCause = ExceptionUtil.getRootCause((Throwable)e);
        String error = Strings.nullToEmpty((String)rootCause.getMessage());
        if (error.contains("Build cancelled")) {
            return;
        }
        Runnable showErrorTask = () -> {
            String msg = "Failed to complete Gradle execution.";
            msg = StringUtil.isEmpty((String)error) ? msg + " Cause: unknown." : msg + "\n\nCause:\n" + error;
            this.addMessage(new Message(Message.Kind.ERROR, msg, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]), null);
            this.showMessages();
            if (IdeInfo.getInstance().isAndroidStudio() && error.startsWith("Supplied javaHome is not a valid folder")) {
                IdeSdks ideSdks = IdeSdks.getInstance();
                File androidHome = ideSdks.getAndroidSdkPath();
                String androidSdkPath = androidHome != null ? androidHome.getPath() : null;
                SelectSdkDialog selectSdkDialog = new SelectSdkDialog(null, androidSdkPath);
                selectSdkDialog.setModal(true);
                if (selectSdkDialog.showAndGet()) {
                    String jdkHome = selectSdkDialog.getJdkHome();
                    UIUtil.invokeLaterIfNeeded(() -> ApplicationManager.getApplication().runWriteAction(() -> ideSdks.setJdkPath(new File(jdkHome))));
                }
            }
        };
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.myRequest.getProject(), (Runnable)showErrorTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addBuildExceptionAsMessage(@NotNull BuildException e, @NotNull String stdErr, @NotNull List<Message> buildMessages) {
        if (!stdErr.trim().isEmpty()) {
            Message msg = new Message(Message.Kind.ERROR, stdErr, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]);
            buildMessages.add(msg);
        } else {
            ByteArrayOutputStream out = new ByteArrayOutputStream(2048);
            try {
                e.printStackTrace(new PrintStream(out));
                String message = "Internal error:" + SystemProperties.getLineSeparator() + out.toString();
                Message msg = new Message(Message.Kind.ERROR, message, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]);
                buildMessages.add(msg);
            }
            finally {
                try {
                    Closeables.close((Closeable)out, (boolean)true);
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void addMessage(@NotNull Message message, @Nullable Navigatable navigatable) {
        this.prepareMessageView();
        this.incrementErrorOrWarningCount(message);
        if (GradleTasksExecutorImpl.shouldShow(message)) {
            Runnable addMessageTask = () -> {
                this.openMessageView();
                this.add(message, navigatable);
            };
            UIUtil.invokeLaterIfNeeded((Runnable)addMessageTask);
        }
    }

    private void incrementErrorOrWarningCount(@NotNull Message message) {
        Message.Kind kind = message.getKind();
        if (kind == Message.Kind.WARNING) {
            ++this.myWarningCount;
        } else if (kind == Message.Kind.ERROR) {
            ++this.myErrorCount;
        }
    }

    private static boolean shouldShow(@NotNull Message message) {
        Message.Kind kind = message.getKind();
        return kind != Message.Kind.SIMPLE && kind != Message.Kind.UNKNOWN;
    }

    private void prepareMessageView() {
        if (!this.myProgressIndicator.isRunning() || this.myMessageViewIsPrepared) {
            return;
        }
        this.myMessageViewIsPrepared = true;
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!this.myRequest.getProject().isDisposed()) {
                Object object = this.myMessageViewLock;
                synchronized (object) {
                    if (this.myErrorTreeView == null) {
                        GradleTasksExecutorImpl.removeUnpinnedBuildMessages(this.myRequest.getProject(), null);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openMessageView() {
        JComponent component2;
        if (this.myProgressIndicator.isCanceled()) {
            return;
        }
        Project project = this.myRequest.getProject();
        Object object = this.myMessageViewLock;
        synchronized (object) {
            if (this.myErrorTreeView != null) {
                return;
            }
            this.myErrorTreeView = new GradleBuildTreeViewPanel(project);
            ExternalSystemTaskId id = this.myRequest.getTaskId();
            this.myErrorTreeView.setProcessController(new BuildProcessController(id, this.myBuildStopper, this.myProgressIndicator));
            component2 = this.myErrorTreeView.getComponent();
        }
        Content content = ContentFactory.SERVICE.getInstance().createContent(component2, CONTENT_NAME, true);
        content.putUserData(CONTENT_ID_KEY, this.myContentId);
        MessageView messageView = this.getMessageView();
        ContentManager contentManager = messageView.getContentManager();
        contentManager.addContent(content);
        this.myCloseListener.setContent(contentManager, content);
        GradleTasksExecutorImpl.removeUnpinnedBuildMessages(this.myRequest.getProject(), content);
        contentManager.setSelectedContent(content);
    }

    private void activateGradleConsole() {
        ToolWindow window = this.getToolWindowManager().getToolWindow("Gradle Console");
        if (window != null) {
            window.activate(null, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(@NotNull Message message, @Nullable Navigatable navigatable) {
        Object object = this.myMessageViewLock;
        synchronized (object) {
            if (this.myErrorTreeView != null && !this.myRequest.getProject().isDisposed()) {
                boolean autoActivate;
                Message.Kind messageKind = message.getKind();
                int type = GradleTasksExecutorImpl.translateMessageKind(messageKind);
                String[] textLines = GradleTasksExecutorImpl.splitIntoLines(message);
                if (navigatable == null) {
                    VirtualFile file = this.findFileFrom(message);
                    List sourceFilePositions = message.getSourceFilePositions();
                    assert (!sourceFilePositions.isEmpty());
                    SourcePosition position = ((SourceFilePosition)sourceFilePositions.get(0)).getPosition();
                    int line = position.getStartLine();
                    int column = position.getStartColumn();
                    this.myErrorTreeView.addMessage(type, textLines, file, line, column, null);
                } else {
                    this.myErrorTreeView.addMessage(type, textLines, null, navigatable, null, null, null);
                }
                boolean bl = autoActivate = !this.myMessagesAutoActivated && type == 4;
                if (autoActivate) {
                    this.myMessagesAutoActivated = true;
                    this.activateMessageView();
                }
            }
        }
    }

    @NotNull
    private static String[] splitIntoLines(@NotNull Message message) {
        String text = message.getText();
        if (text.indexOf(10) == -1) {
            return new String[]{text};
        }
        return ArrayUtil.toStringArray((Collection)Splitter.on((char)'\n').splitToList((CharSequence)text));
    }

    @Nullable
    private VirtualFile findFileFrom(@NotNull Message message) {
        SourceFile source = ((SourceFilePosition)message.getSourceFilePositions().get(0)).getFile();
        if (source.getSourceFile() != null) {
            return VfsUtil.findFileByIoFile((File)source.getSourceFile(), (boolean)true);
        }
        if (source.getDescription() != null) {
            String gradlePath = source.getDescription();
            Module module = GradleUtil.findModuleByGradlePath(this.myRequest.getProject(), gradlePath);
            if (module != null) {
                GradleFacet facet = GradleFacet.getInstance(module);
                assert (facet != null);
                GradleModuleModel gradleModuleModel = facet.getGradleModuleModel();
                return gradleModuleModel != null ? gradleModuleModel.getBuildFile() : null;
            }
        }
        return null;
    }

    private static int translateMessageKind(@NotNull Message.Kind kind) {
        switch (kind) {
            case INFO: {
                return 3;
            }
            case WARNING: {
                return 5;
            }
            case ERROR: {
                return 4;
            }
            case STATISTICS: {
                return 2;
            }
            case SIMPLE: {
                return 1;
            }
        }
        GradleTasksExecutorImpl.getLogger().warn("Unknown message kind: " + kind);
        return 0;
    }

    @NotNull
    private static Logger getLogger() {
        return Logger.getInstance(GradleBuildInvoker.class);
    }

    private void notifyGradleInvocationCompleted(long durationMillis) {
        Project project = this.myRequest.getProject();
        if (!project.isDisposed()) {
            MessageType messageType;
            String statusMsg = this.createStatusMessage(durationMillis);
            MessageType messageType2 = this.myErrorCount > 0 ? MessageType.ERROR : (messageType = this.myWarningCount > 0 ? MessageType.WARNING : MessageType.INFO);
            if (durationMillis > 60000L) {
                BALLOON_NOTIFICATION.createNotification(statusMsg, messageType).notify(project);
            } else {
                this.addToEventLog(statusMsg, messageType);
            }
            GradleTasksExecutorImpl.getLogger().info(statusMsg);
        }
    }

    @NotNull
    private String createStatusMessage(long durationMillis) {
        String message = "Gradle build finished";
        if (this.myErrorCount > 0) {
            message = this.myWarningCount > 0 ? message + String.format(" with %d error(s) and %d warning(s)", this.myErrorCount, this.myWarningCount) : message + String.format(" with %d error(s)", this.myErrorCount);
        } else if (this.myWarningCount > 0) {
            message = message + String.format(" with %d warnings(s)", this.myWarningCount);
        }
        message = message + " in " + StringUtil.formatDuration((long)durationMillis);
        return message;
    }

    private void addToEventLog(@NotNull String message, @NotNull MessageType type) {
        LOGGING_NOTIFICATION.createNotification(message, type).notify(this.myProject);
    }

    @NotNull
    private ToolWindowManager getToolWindowManager() {
        return ToolWindowManager.getInstance((Project)this.myRequest.getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showMessages() {
        Object object = this.myMessageViewLock;
        synchronized (object) {
            if (this.myErrorTreeView != null && !this.myRequest.getProject().isDisposed()) {
                Content[] contents;
                MessageView messageView = this.getMessageView();
                for (Content content : contents = messageView.getContentManager().getContents()) {
                    if (content.getUserData(CONTENT_ID_KEY) == null) continue;
                    messageView.getContentManager().setSelectedContent(content);
                    return;
                }
            }
        }
    }

    @NotNull
    private MessageView getMessageView() {
        return MessageView.SERVICE.getInstance((Project)this.myRequest.getProject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateMessageView() {
        Object object = this.myMessageViewLock;
        synchronized (object) {
            ToolWindow window;
            if (this.myErrorTreeView != null && (window = this.getToolWindowManager().getToolWindow(ToolWindowId.MESSAGES_WINDOW)) != null) {
                window.activate(null, false);
            }
        }
    }

    private void attemptToStopBuild() {
        this.myBuildStopper.attemptToStopBuild(this.myRequest.getTaskId(), this.myProgressIndicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueAndWaitForCompletion() {
        int counterBefore;
        Object object = this.myCompletionLock;
        synchronized (object) {
            counterBefore = this.myCompletionCounter;
        }
        UIUtil.invokeLaterIfNeeded(() -> ((GradleTasksExecutorImpl)this).queue());
        object = this.myCompletionLock;
        synchronized (object) {
            while (this.myCompletionCounter <= counterBefore) {
                try {
                    this.myCompletionLock.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
        }
    }

    public void onSuccess() {
        super.onSuccess();
        this.onCompletion();
    }

    public void onCancel() {
        super.onCancel();
        this.onCompletion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCompletion() {
        Object object = this.myCompletionLock;
        synchronized (object) {
            ++this.myCompletionCounter;
            this.myCompletionLock.notifyAll();
        }
    }

    private class OpenGradleConsole
    implements Navigatable {
        private OpenGradleConsole() {
        }

        public void navigate(boolean requestFocus) {
            GradleTasksExecutorImpl.this.activateGradleConsole();
        }

        public boolean canNavigate() {
            return true;
        }

        public boolean canNavigateToSource() {
            return false;
        }
    }

    private class ProgressIndicatorStateDelegate
    extends TaskExecutionProgressIndicator {
        ProgressIndicatorStateDelegate(@NotNull ExternalSystemTaskId taskId, BuildStopper buildStopper) {
            super(taskId, buildStopper);
        }

        @Override
        void onCancel() {
            GradleTasksExecutorImpl.this.closeView();
            this.stopAppIconProgress();
        }

        public void stop() {
            super.stop();
            this.stopAppIconProgress();
        }

        private void stopAppIconProgress() {
            UIUtil.invokeLaterIfNeeded(() -> {
                Project project;
                AppIcon appIcon = AppIcon.getInstance();
                if (appIcon.hideProgress(project = GradleTasksExecutorImpl.this.myRequest.getProject(), (Object)GradleTasksExecutorImpl.APP_ICON_ID)) {
                    if (GradleTasksExecutorImpl.this.myErrorCount > 0) {
                        appIcon.setErrorBadge(project, String.valueOf(GradleTasksExecutorImpl.this.myErrorCount));
                        appIcon.requestAttention(project, true);
                    } else {
                        appIcon.setOkBadge(project, true);
                        appIcon.requestAttention(project, false);
                    }
                }
            });
        }

        protected void onProgressChange() {
            GradleTasksExecutorImpl.this.prepareMessageView();
        }
    }

    private class CloseListener
    extends ContentManagerAdapter
    implements ProjectManagerListener {
        private ContentManager myContentManager;
        @Nullable
        private Content myContent;
        private boolean myIsApplicationExitingOrProjectClosing;
        private boolean myUserAcceptedCancel;

        private CloseListener() {
        }

        public void projectOpened(Project project) {
        }

        public boolean canCloseProject(Project project) {
            if (!project.equals(GradleTasksExecutorImpl.this.myProject)) {
                return true;
            }
            if (this.shouldPromptUser()) {
                this.myUserAcceptedCancel = this.askUserToCancelGradleExecution();
                if (!this.myUserAcceptedCancel) {
                    return false;
                }
                GradleTasksExecutorImpl.this.attemptToStopBuild();
                return true;
            }
            return !GradleTasksExecutorImpl.this.myProgressIndicator.isRunning();
        }

        public void projectClosed(Project project) {
            if (project.equals(GradleTasksExecutorImpl.this.myProject) && this.myContent != null) {
                this.myContentManager.removeContent(this.myContent, true);
            }
        }

        public void projectClosing(Project project) {
            if (project.equals(GradleTasksExecutorImpl.this.myProject)) {
                this.myIsApplicationExitingOrProjectClosing = true;
            }
        }

        void setContent(@NotNull ContentManager contentManager, @Nullable Content content) {
            this.myContent = content;
            this.myContentManager = contentManager;
            contentManager.addContentManagerListener((ContentManagerListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void contentRemoved(ContentManagerEvent event) {
            if (event.getContent() == this.myContent) {
                Object object = GradleTasksExecutorImpl.this.myMessageViewLock;
                synchronized (object) {
                    Project project = GradleTasksExecutorImpl.this.myRequest.getProject();
                    if (GradleTasksExecutorImpl.this.myErrorTreeView != null && !project.isDisposed()) {
                        AppIcon appIcon;
                        Disposer.dispose((Disposable)GradleTasksExecutorImpl.this.myErrorTreeView);
                        GradleTasksExecutorImpl.this.myErrorTreeView = null;
                        if (GradleTasksExecutorImpl.this.myProgressIndicator.isRunning()) {
                            GradleTasksExecutorImpl.this.attemptToStopBuild();
                        }
                        if ((appIcon = AppIcon.getInstance()).hideProgress(project, (Object)GradleTasksExecutorImpl.APP_ICON_ID)) {
                            appIcon.setErrorBadge(project, null);
                        }
                    }
                }
                this.myContentManager.removeContentManagerListener((ContentManagerListener)this);
                if (this.myContent != null) {
                    this.myContent.release();
                }
                this.myContent = null;
            }
        }

        public void contentRemoveQuery(ContentManagerEvent event) {
            if (event.getContent() == this.myContent && !GradleTasksExecutorImpl.this.myProgressIndicator.isCanceled() && this.shouldPromptUser()) {
                this.myUserAcceptedCancel = this.askUserToCancelGradleExecution();
                if (!this.myUserAcceptedCancel) {
                    event.consume();
                }
            }
        }

        private boolean shouldPromptUser() {
            return !this.myUserAcceptedCancel && !this.myIsApplicationExitingOrProjectClosing && GradleTasksExecutorImpl.this.myProgressIndicator.isRunning();
        }

        private boolean askUserToCancelGradleExecution() {
            String msg = "Gradle is running. Proceed with Project closing?";
            int result = Messages.showYesNoDialog((Project)GradleTasksExecutorImpl.this.myProject, (String)msg, (String)GradleTasksExecutorImpl.GRADLE_RUNNING_MSG_TITLE, (Icon)Messages.getQuestionIcon());
            return result == 0;
        }
    }
}

