/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker;

import com.android.tools.idea.gradle.project.model.ide.android.IdeAndroidArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeBaseArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeJavaArtifact;
import com.android.tools.idea.gradle.project.model.ide.android.IdeVariant;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestCompileType {
    public static final TestCompileType ALL = new TestCompileType(){

        @Override
        @NotNull
        public Collection<IdeBaseArtifact> getArtifacts(@NotNull IdeVariant variant) {
            return variant.getTestArtifacts();
        }
    };
    public static final TestCompileType ANDROID_TESTS = new TestCompileType(){

        @Override
        @NotNull
        public Collection<IdeBaseArtifact> getArtifacts(@NotNull IdeVariant variant) {
            IdeAndroidArtifact testArtifact = variant.getAndroidTestArtifact();
            return testArtifact != null ? Collections.singleton(testArtifact) : Collections.emptySet();
        }
    };
    public static final TestCompileType UNIT_TESTS = new TestCompileType(){

        @Override
        @NotNull
        public Collection<IdeBaseArtifact> getArtifacts(@NotNull IdeVariant variant) {
            IdeJavaArtifact testArtifact = variant.getUnitTestArtifact();
            return testArtifact != null ? Collections.singleton(testArtifact) : Collections.emptySet();
        }
    };
    public static final TestCompileType NONE = new TestCompileType(){

        @Override
        @NotNull
        public Collection<IdeBaseArtifact> getArtifacts(@NotNull IdeVariant variant) {
            return Collections.emptySet();
        }
    };

    @NotNull
    public abstract Collection<IdeBaseArtifact> getArtifacts(@NotNull IdeVariant var1);

    @NotNull
    public static TestCompileType get(@Nullable String runConfigurationId) {
        if (runConfigurationId != null) {
            if (AndroidCommonUtils.isInstrumentationTestConfiguration((String)runConfigurationId)) {
                return ANDROID_TESTS;
            }
            if (AndroidCommonUtils.isTestConfiguration((String)runConfigurationId)) {
                return UNIT_TESTS;
            }
        }
        return ALL;
    }
}

